/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.Cookie;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.CookieBasedSessionManagementMethodType;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.view.LayoutHelper;

public class ManualAuthenticationMethodType
extends AuthenticationMethodType {
    private static final int METHOD_IDENTIFIER = 0;
    private static final String METHOD_NAME = Constant.messages.getString("authentication.method.manual.name");
    private static final String API_METHOD_NAME = "manualAuthentication";
    private static final String ACTION_SET_CREDENTIALS = "manualAuthenticationCredentials";
    private static final String PARAM_SESSION_NAME = "sessionName";

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public boolean hasOptionsPanel() {
        return false;
    }

    @Override
    public boolean hasCredentialsOptionsPanel() {
        return true;
    }

    @Override
    public ManualAuthenticationMethod createAuthenticationMethod(int n) {
        return new ManualAuthenticationMethod(n);
    }

    @Override
    public AbstractAuthenticationMethodOptionsPanel buildOptionsPanel(Context context) {
        return null;
    }

    @Override
    public AbstractCredentialsOptionsPanel<? extends AuthenticationCredentials> buildCredentialsOptionsPanel(AuthenticationCredentials authenticationCredentials, Context context) {
        return new ManualAuthenticationCredentialsOptionsPanel((ManualAuthenticationCredentials)authenticationCredentials, context);
    }

    @Override
    public boolean isTypeForMethod(AuthenticationMethod authenticationMethod) {
        return authenticationMethod instanceof ManualAuthenticationMethod;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
    }

    @Override
    public AuthenticationMethod loadMethodFromSession(Session session, int n) {
        return new ManualAuthenticationMethod(n);
    }

    @Override
    public void persistMethodToSession(Session session, int n, AuthenticationMethod authenticationMethod) {
    }

    @Override
    public int getUniqueIdentifier() {
        return 0;
    }

    @Override
    public ManualAuthenticationCredentials createAuthenticationCredentials() {
        return new ManualAuthenticationCredentials();
    }

    public static ManualAuthenticationCredentials createAuthenticationCredentials(HttpSession httpSession) {
        ManualAuthenticationCredentials manualAuthenticationCredentials = new ManualAuthenticationCredentials();
        manualAuthenticationCredentials.setSelectedSession(httpSession);
        return manualAuthenticationCredentials;
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, null, null){

            @Override
            public void handleAction(JSONObject jSONObject) throws ApiException {
                Context context = ApiUtils.getContextByParamId(jSONObject, "contextId");
                ManualAuthenticationMethod manualAuthenticationMethod = ManualAuthenticationMethodType.this.createAuthenticationMethod(context.getIndex());
                if (!context.getAuthenticationMethod().isSameType(manualAuthenticationMethod)) {
                    AuthenticationMethodType.apiChangedAuthenticationMethodForContext(context.getIndex());
                }
                context.setAuthenticationMethod(manualAuthenticationMethod);
            }
        };
    }

    @Override
    public ApiDynamicActionImplementor getSetCredentialsForUserApiAction() {
        return new ApiDynamicActionImplementor(ACTION_SET_CREDENTIALS, new String[]{PARAM_SESSION_NAME}, null){

            @Override
            public void handleAction(JSONObject jSONObject) throws ApiException {
                Context context = ApiUtils.getContextByParamId(jSONObject, "contextId");
                int n = ApiUtils.getIntParam(jSONObject, "userId");
                if (!ManualAuthenticationMethodType.this.isTypeForMethod(context.getAuthenticationMethod())) {
                    throw new ApiException(ApiException.Type.BAD_TYPE, "User's credentials should match authentication method type of the context: " + context.getAuthenticationMethod().getType().getName());
                }
                ExtensionUserManagement extensionUserManagement = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
                User user = extensionUserManagement.getContextUserAuthManager(context.getIndex()).getUserById(n);
                if (user == null) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND, "userId");
                }
                String string = ApiUtils.getNonEmptyStringParam(jSONObject, ManualAuthenticationMethodType.PARAM_SESSION_NAME);
                ExtensionHttpSessions extensionHttpSessions = (ExtensionHttpSessions)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHttpSessions");
                if (extensionHttpSessions == null) {
                    throw new ApiException(ApiException.Type.NO_IMPLEMENTOR, "HttpSessions extension is not loaded.");
                }
                List<HttpSession> list = extensionHttpSessions.getHttpSessionsForContext(context);
                HttpSession httpSession = null;
                for (HttpSession httpSession2 : list) {
                    if (!httpSession2.getName().equals(string)) continue;
                    httpSession = httpSession2;
                    break;
                }
                if (httpSession == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ManualAuthenticationMethodType.PARAM_SESSION_NAME);
                }
                ManualAuthenticationCredentials manualAuthenticationCredentials = ManualAuthenticationMethodType.this.createAuthenticationCredentials();
                manualAuthenticationCredentials.setSelectedSession(httpSession);
                user.setAuthenticationCredentials(manualAuthenticationCredentials);
            }
        };
    }

    @Override
    public void exportData(Configuration configuration, AuthenticationMethod authenticationMethod) {
    }

    @Override
    public void importData(Configuration configuration, AuthenticationMethod authenticationMethod) throws ConfigurationException {
    }

    private static class ManualAuthenticationCredentialsOptionsPanel
    extends AbstractCredentialsOptionsPanel<ManualAuthenticationCredentials> {
        private static final long serialVersionUID = -8081914793980311435L;
        private static final Logger log = Logger.getLogger(ManualAuthenticationCredentialsOptionsPanel.class);
        private JComboBox<HttpSession> sessionsComboBox;
        private Context uiSharedContext;

        public ManualAuthenticationCredentialsOptionsPanel(ManualAuthenticationCredentials manualAuthenticationCredentials, Context context) {
            super(manualAuthenticationCredentials);
            this.uiSharedContext = context;
            this.initialize();
        }

        protected void initialize() {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(Constant.messages.getString("authentication.method.manual.field.session"));
            this.add((Component)jLabel, LayoutHelper.getGBC(0, 0, 1, 0.5));
            this.add(this.getSessionsComboBox(), LayoutHelper.getGBC(1, 0, 1, 0.5));
            this.getSessionsComboBox().setRenderer(new HttpSessionRenderer());
            this.add((Component)new JLabel(Constant.messages.getString("authentication.method.manual.field.description")), LayoutHelper.getGBC(0, 1, 2, 0.0, 0.0));
        }

        private JComboBox<HttpSession> getSessionsComboBox() {
            if (this.sessionsComboBox == null) {
                ExtensionHttpSessions extensionHttpSessions = (ExtensionHttpSessions)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHttpSessions");
                List<HttpSession> list = extensionHttpSessions.getHttpSessionsForContext(this.uiSharedContext);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found sessions for Manual Authentication Config: " + list));
                }
                this.sessionsComboBox = new JComboBox<HttpSession>(list.toArray(new HttpSession[list.size()]));
                this.sessionsComboBox.setSelectedItem(((ManualAuthenticationCredentials)this.getCredentials()).getSelectedSession());
            }
            return this.sessionsComboBox;
        }

        @Override
        public boolean validateFields() {
            if (this.sessionsComboBox.getSelectedIndex() < 0) {
                JOptionPane.showMessageDialog(this, Constant.messages.getString("authentication.method.manual.dialog.error.nosession.text"), Constant.messages.getString("authentication.method.manual.dialog.error.title"), 2);
                this.sessionsComboBox.requestFocusInWindow();
                return false;
            }
            return true;
        }

        @Override
        public void saveCredentials() {
            log.info((Object)("Saving Manual Authentication Method: " + this.getSessionsComboBox().getSelectedItem()));
            ((ManualAuthenticationCredentials)this.getCredentials()).setSelectedSession((HttpSession)this.getSessionsComboBox().getSelectedItem());
        }

        private static class HttpSessionRenderer
        extends BasicComboBoxRenderer {
            private static final long serialVersionUID = 3654541772447187317L;

            private HttpSessionRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null) {
                    HttpSession httpSession = (HttpSession)object;
                    this.setText(httpSession.getName());
                }
                return this;
            }
        }
    }

    private static class ManualAuthenticationCredentials
    implements AuthenticationCredentials {
        private static final String API_NAME = "ManualAuthenticationCredentials";
        private HttpSession selectedSession;

        private ManualAuthenticationCredentials() {
        }

        protected HttpSession getSelectedSession() {
            return this.selectedSession;
        }

        @Override
        public boolean isConfigured() {
            return this.selectedSession != null;
        }

        protected void setSelectedSession(HttpSession httpSession) {
            this.selectedSession = httpSession;
        }

        @Override
        public String encode(String string) {
            return Base64.encodeBase64String(this.selectedSession.getName().getBytes());
        }

        @Override
        public void decode(String string) {
            throw new IllegalStateException("Manual Authentication Credentials cannot be decoded.");
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("type", API_NAME);
            hashMap.put(ManualAuthenticationMethodType.PARAM_SESSION_NAME, this.selectedSession != null ? this.selectedSession.getName() : "");
            return new ApiResponseSet("credentials", hashMap);
        }
    }

    public static class ManualAuthenticationMethod
    extends AuthenticationMethod {
        private int contextId;

        public ManualAuthenticationMethod(int n) {
            this.contextId = n;
        }

        protected int getContextId() {
            return this.contextId;
        }

        @Override
        public boolean isConfigured() {
            return true;
        }

        @Override
        public AuthenticationCredentials createAuthenticationCredentials() {
            return new ManualAuthenticationCredentials();
        }

        @Override
        public WebSession authenticate(SessionManagementMethod sessionManagementMethod, AuthenticationCredentials authenticationCredentials, User user) {
            if (!(authenticationCredentials instanceof ManualAuthenticationCredentials)) {
                Logger.getLogger(ManualAuthenticationMethod.class).error((Object)"Manual authentication credentials should be used for Manual authentication.");
                throw new AuthenticationMethod.UnsupportedAuthenticationCredentialsException("Manual authentication credentials should be used for Manual authentication.");
            }
            ManualAuthenticationCredentials manualAuthenticationCredentials = (ManualAuthenticationCredentials)authenticationCredentials;
            CookieBasedSessionManagementMethodType.CookieBasedSession cookieBasedSession = new CookieBasedSessionManagementMethodType.CookieBasedSession();
            for (Map.Entry<String, Cookie> entry : manualAuthenticationCredentials.getSelectedSession().getTokenValuesUnmodifiableMap().entrySet()) {
                cookieBasedSession.getHttpState().addCookie(entry.getValue());
            }
            return cookieBasedSession;
        }

        @Override
        public AuthenticationMethodType getType() {
            return new ManualAuthenticationMethodType();
        }

        @Override
        public AuthenticationMethod duplicate() {
            return new ManualAuthenticationMethod(this.contextId);
        }

        @Override
        public void onMethodPersisted() {
        }

        @Override
        public void onMethodDiscarded() {
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            return new ApiResponseElement("methodName", ManualAuthenticationMethodType.API_METHOD_NAME);
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + this.contextId;
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ManualAuthenticationMethod manualAuthenticationMethod = (ManualAuthenticationMethod)object;
            return this.contextId == manualAuthenticationMethod.contextId;
        }
    }
}

