/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.component.split.request.RequestSplitComponent;
import org.zaproxy.zap.view.HttpPanelManager;

public class HttpPanelRequest
extends HttpPanel {
    private static final long serialVersionUID = 1L;
    protected JComboBox<String> comboChangeMethod;
    private static final String REQUEST_KEY = "request.";

    public HttpPanelRequest(boolean bl, String string) {
        super(bl, string + REQUEST_KEY);
        HttpPanelManager.getInstance().addRequestPanel(this);
        this.setHideable(false);
    }

    @Override
    protected void initComponents() {
        this.addComponent(new RequestSplitComponent(), Model.getSingleton().getOptionsParam().getConfig());
    }

    @Override
    protected void initSpecial() {
        if (this.isEditable()) {
            this.initComboChangeMethod();
        }
    }

    @Override
    public void setEnableViewSelect(boolean bl) {
        super.setEnableViewSelect(bl);
        if (this.isEditable()) {
            this.initComboChangeMethod();
            this.comboChangeMethod.setEnabled(bl);
        }
    }

    protected void initComboChangeMethod() {
        if (this.comboChangeMethod == null) {
            this.comboChangeMethod = new JComboBox();
            this.comboChangeMethod.setEditable(false);
            this.comboChangeMethod.setMaximumRowCount(9);
            this.comboChangeMethod.addItem(Constant.messages.getString("manReq.pullDown.method"));
            this.comboChangeMethod.addItem("CONNECT");
            this.comboChangeMethod.addItem("DELETE");
            this.comboChangeMethod.addItem("GET");
            this.comboChangeMethod.addItem("HEAD");
            this.comboChangeMethod.addItem("OPTIONS");
            this.comboChangeMethod.addItem("POST");
            this.comboChangeMethod.addItem("PUT");
            this.comboChangeMethod.addItem("TRACE");
            this.comboChangeMethod.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (HttpPanelRequest.this.message == null) {
                        HttpPanelRequest.this.comboChangeMethod.setSelectedIndex(0);
                        return;
                    }
                    if (HttpPanelRequest.this.comboChangeMethod.getSelectedIndex() > 0 && HttpPanelRequest.this.message instanceof HttpMessage) {
                        HttpPanelRequest.this.saveData();
                        ((HttpMessage)HttpPanelRequest.this.message).mutateHttpMethod((String)HttpPanelRequest.this.comboChangeMethod.getSelectedItem());
                        HttpPanelRequest.this.comboChangeMethod.setSelectedIndex(0);
                        HttpPanelRequest.this.updateContent();
                    }
                }
            });
            this.addOptions(this.comboChangeMethod, HttpPanel.OptionsLocation.BEGIN);
            this.comboChangeMethod.setEnabled(false);
        }
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        if (bl) {
            this.initComboChangeMethod();
            this.comboChangeMethod.setEnabled(true);
        }
    }
}

