/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.core;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ApiResponseElement;
import org.zaproxy.clientapi.core.ApiResponseList;
import org.zaproxy.clientapi.core.ApiResponseSet;
import org.zaproxy.clientapi.core.ClientApiException;

public final class ApiResponseFactory {
    private ApiResponseFactory() {
    }

    public static ApiResponse getResponse(Node node) throws ClientApiException {
        if (node == null) {
            throw new ClientApiException("Null node");
        }
        Node node2 = node.getAttributes().getNamedItem("type");
        if (node2 != null) {
            String string = node2.getNodeValue();
            if ("list".equals(string)) {
                return new ApiResponseList(node);
            }
            if ("set".equals(string)) {
                return new ApiResponseSet(node);
            }
            if ("exception".equals(string)) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string2 = namedNodeMap.getNamedItem("code").getNodeValue();
                String string3 = null;
                if (namedNodeMap.getNamedItem("detail") != null) {
                    string3 = namedNodeMap.getNamedItem("detail").getNodeValue();
                }
                throw new ClientApiException(node.getTextContent(), string2, string3);
            }
        }
        return new ApiResponseElement(node);
    }
}

