/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.search.suggest.document.CompletionTokenStream;
import org.apache.lucene.search.suggest.document.SuggestField;

public class ContextSuggestField
extends SuggestField {
    public static final int CONTEXT_SEPARATOR = 29;
    static final byte TYPE = 1;
    private final Set<CharSequence> contexts;

    public ContextSuggestField(String name, String value, int weight, CharSequence ... contexts) {
        super(name, value, weight);
        this.validate(value);
        this.contexts = new HashSet<CharSequence>(contexts != null ? contexts.length : 0);
        if (contexts != null) {
            Collections.addAll(this.contexts, contexts);
        }
    }

    protected Iterable<CharSequence> contexts() {
        return this.contexts;
    }

    @Override
    protected CompletionTokenStream wrapTokenStream(TokenStream stream) {
        CompletionTokenStream completionTokenStream;
        for (CharSequence context : this.contexts()) {
            this.validate(context);
        }
        PrefixTokenFilter prefixTokenFilter = new PrefixTokenFilter(stream, '\u001d', this.contexts());
        if (stream instanceof CompletionTokenStream) {
            completionTokenStream = (CompletionTokenStream)stream;
            completionTokenStream = new CompletionTokenStream((TokenStream)prefixTokenFilter, completionTokenStream.preserveSep, completionTokenStream.preservePositionIncrements, completionTokenStream.maxGraphExpansions);
        } else {
            completionTokenStream = new CompletionTokenStream((TokenStream)prefixTokenFilter);
        }
        return completionTokenStream;
    }

    @Override
    protected byte type() {
        return 1;
    }

    private void validate(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            if ('\u001d' != value.charAt(i)) continue;
            throw new IllegalArgumentException("Illegal value [" + value + "] UTF-16 codepoint [0x" + Integer.toHexString(value.charAt(i)) + "] at position " + i + " is a reserved character");
        }
    }

    private static final class PrefixTokenFilter
    extends TokenFilter {
        private final char separator;
        private final CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final PositionIncrementAttribute posAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private final Iterable<CharSequence> prefixes;
        private Iterator<CharSequence> currentPrefix;

        public PrefixTokenFilter(TokenStream input, char separator, Iterable<CharSequence> prefixes) {
            super(input);
            this.prefixes = prefixes;
            this.currentPrefix = null;
            this.separator = separator;
        }

        public boolean incrementToken() throws IOException {
            if (this.currentPrefix != null) {
                if (!this.currentPrefix.hasNext()) {
                    return this.input.incrementToken();
                }
                this.posAttr.setPositionIncrement(0);
            } else {
                this.currentPrefix = this.prefixes.iterator();
                this.termAttr.setEmpty();
                this.posAttr.setPositionIncrement(1);
            }
            this.termAttr.setEmpty();
            if (this.currentPrefix.hasNext()) {
                this.termAttr.append(this.currentPrefix.next());
            }
            this.termAttr.append(this.separator);
            return true;
        }

        public void reset() throws IOException {
            super.reset();
            this.currentPrefix = null;
        }
    }
}

