/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.cache.query.QueryCacheStats;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.percolator.stats.PercolateStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.search.suggest.completion.CompletionStats;

public class ClusterStatsIndices
implements ToXContent,
Streamable {
    private int indexCount;
    private ShardStats shards;
    private DocsStats docs;
    private StoreStats store;
    private FieldDataStats fieldData;
    private QueryCacheStats queryCache;
    private CompletionStats completion;
    private SegmentsStats segments;
    private PercolateStats percolate;

    private ClusterStatsIndices() {
    }

    public ClusterStatsIndices(ClusterStatsNodeResponse[] nodeResponses) {
        ObjectObjectHashMap countsPerIndex = new ObjectObjectHashMap();
        this.docs = new DocsStats();
        this.store = new StoreStats();
        this.fieldData = new FieldDataStats();
        this.queryCache = new QueryCacheStats();
        this.completion = new CompletionStats();
        this.segments = new SegmentsStats();
        this.percolate = new PercolateStats();
        for (ClusterStatsNodeResponse r : nodeResponses) {
            for (org.elasticsearch.action.admin.indices.stats.ShardStats shardStats : r.shardsStats()) {
                ShardStats indexShardStats = (ShardStats)countsPerIndex.get((Object)shardStats.getShardRouting().getIndex());
                if (indexShardStats == null) {
                    indexShardStats = new ShardStats();
                    countsPerIndex.put((Object)shardStats.getShardRouting().getIndex(), (Object)indexShardStats);
                }
                ++indexShardStats.total;
                CommonStats shardCommonStats = shardStats.getStats();
                if (shardStats.getShardRouting().primary()) {
                    ++indexShardStats.primaries;
                    this.docs.add(shardCommonStats.docs);
                }
                this.store.add(shardCommonStats.store);
                this.fieldData.add(shardCommonStats.fieldData);
                this.queryCache.add(shardCommonStats.queryCache);
                this.completion.add(shardCommonStats.completion);
                this.segments.add(shardCommonStats.segments);
                this.percolate.add(shardCommonStats.percolate);
            }
        }
        this.shards = new ShardStats();
        this.indexCount = countsPerIndex.size();
        for (ObjectObjectCursor indexCountsCursor : countsPerIndex) {
            this.shards.addIndexShardCount((ShardStats)indexCountsCursor.value);
        }
    }

    public int getIndexCount() {
        return this.indexCount;
    }

    public ShardStats getShards() {
        return this.shards;
    }

    public DocsStats getDocs() {
        return this.docs;
    }

    public StoreStats getStore() {
        return this.store;
    }

    public FieldDataStats getFieldData() {
        return this.fieldData;
    }

    public QueryCacheStats getQueryCache() {
        return this.queryCache;
    }

    public CompletionStats getCompletion() {
        return this.completion;
    }

    public SegmentsStats getSegments() {
        return this.segments;
    }

    public PercolateStats getPercolate() {
        return this.percolate;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.indexCount = in.readVInt();
        this.shards = ShardStats.readShardStats(in);
        this.docs = DocsStats.readDocStats(in);
        this.store = StoreStats.readStoreStats(in);
        this.fieldData = FieldDataStats.readFieldDataStats(in);
        this.queryCache = QueryCacheStats.readQueryCacheStats(in);
        this.completion = CompletionStats.readCompletionStats(in);
        this.segments = SegmentsStats.readSegmentsStats(in);
        this.percolate = PercolateStats.readPercolateStats(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.indexCount);
        this.shards.writeTo(out);
        this.docs.writeTo(out);
        this.store.writeTo(out);
        this.fieldData.writeTo(out);
        this.queryCache.writeTo(out);
        this.completion.writeTo(out);
        this.segments.writeTo(out);
        this.percolate.writeTo(out);
    }

    public static ClusterStatsIndices readIndicesStats(StreamInput in) throws IOException {
        ClusterStatsIndices indicesStats = new ClusterStatsIndices();
        indicesStats.readFrom(in);
        return indicesStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.COUNT, this.indexCount);
        this.shards.toXContent(builder, params);
        this.docs.toXContent(builder, params);
        this.store.toXContent(builder, params);
        this.fieldData.toXContent(builder, params);
        this.queryCache.toXContent(builder, params);
        this.completion.toXContent(builder, params);
        this.segments.toXContent(builder, params);
        this.percolate.toXContent(builder, params);
        return builder;
    }

    public static class ShardStats
    implements ToXContent,
    Streamable {
        int indices;
        int total;
        int primaries;
        int minIndexShards = -1;
        int maxIndexShards = -1;
        int minIndexPrimaryShards = -1;
        int maxIndexPrimaryShards = -1;
        double minIndexReplication = -1.0;
        double totalIndexReplication = 0.0;
        double maxIndexReplication = -1.0;

        public int getIndices() {
            return this.indices;
        }

        public int getTotal() {
            return this.total;
        }

        public int getPrimaries() {
            return this.primaries;
        }

        public double getReplication() {
            if (this.primaries == 0) {
                return 0.0;
            }
            return (double)(this.total - this.primaries) / (double)this.primaries;
        }

        public int getMaxIndexShards() {
            return this.maxIndexShards;
        }

        public int getMinIndexShards() {
            return this.minIndexShards;
        }

        public double getAvgIndexShards() {
            if (this.indices == 0) {
                return -1.0;
            }
            return (double)this.total / (double)this.indices;
        }

        public int getMaxIndexPrimaryShards() {
            return this.maxIndexPrimaryShards;
        }

        public int getMinIndexPrimaryShards() {
            return this.minIndexPrimaryShards;
        }

        public double getAvgIndexPrimaryShards() {
            if (this.indices == 0) {
                return -1.0;
            }
            return (double)this.primaries / (double)this.indices;
        }

        public double getMinIndexReplication() {
            return this.minIndexReplication;
        }

        public double getAvgIndexReplication() {
            if (this.indices == 0) {
                return -1.0;
            }
            return this.totalIndexReplication / (double)this.indices;
        }

        public double getMaxIndexReplication() {
            return this.maxIndexReplication;
        }

        public void addIndexShardCount(ShardStats indexShardCount) {
            ++this.indices;
            this.primaries += indexShardCount.primaries;
            this.total += indexShardCount.total;
            this.totalIndexReplication += indexShardCount.getReplication();
            if (this.indices == 1) {
                this.minIndexPrimaryShards = indexShardCount.primaries;
                this.maxIndexPrimaryShards = indexShardCount.primaries;
                this.minIndexShards = indexShardCount.total;
                this.maxIndexShards = indexShardCount.total;
                this.maxIndexReplication = this.minIndexReplication = indexShardCount.getReplication();
            } else {
                this.minIndexShards = Math.min(this.minIndexShards, indexShardCount.total);
                this.minIndexPrimaryShards = Math.min(this.minIndexPrimaryShards, indexShardCount.primaries);
                this.minIndexReplication = Math.min(this.minIndexReplication, indexShardCount.getReplication());
                this.maxIndexShards = Math.max(this.maxIndexShards, indexShardCount.total);
                this.maxIndexPrimaryShards = Math.max(this.maxIndexPrimaryShards, indexShardCount.primaries);
                this.maxIndexReplication = Math.max(this.maxIndexReplication, indexShardCount.getReplication());
            }
        }

        public static ShardStats readShardStats(StreamInput in) throws IOException {
            ShardStats c = new ShardStats();
            c.readFrom(in);
            return c;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.indices = in.readVInt();
            this.total = in.readVInt();
            this.primaries = in.readVInt();
            this.minIndexShards = in.readVInt();
            this.maxIndexShards = in.readVInt();
            this.minIndexPrimaryShards = in.readVInt();
            this.maxIndexPrimaryShards = in.readVInt();
            this.minIndexReplication = in.readDouble();
            this.totalIndexReplication = in.readDouble();
            this.maxIndexReplication = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.indices);
            out.writeVInt(this.total);
            out.writeVInt(this.primaries);
            out.writeVInt(this.minIndexShards);
            out.writeVInt(this.maxIndexShards);
            out.writeVInt(this.minIndexPrimaryShards);
            out.writeVInt(this.maxIndexPrimaryShards);
            out.writeDouble(this.minIndexReplication);
            out.writeDouble(this.totalIndexReplication);
            out.writeDouble(this.maxIndexReplication);
        }

        private void addIntMinMax(XContentBuilderString field, int min, int max, double avg, XContentBuilder builder) throws IOException {
            builder.startObject(field);
            builder.field(Fields.MIN, min);
            builder.field(Fields.MAX, max);
            builder.field(Fields.AVG, avg);
            builder.endObject();
        }

        private void addDoubleMinMax(XContentBuilderString field, double min, double max, double avg, XContentBuilder builder) throws IOException {
            builder.startObject(field);
            builder.field(Fields.MIN, min);
            builder.field(Fields.MAX, max);
            builder.field(Fields.AVG, avg);
            builder.endObject();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(Fields.SHARDS);
            if (this.indices > 0) {
                builder.field(Fields.TOTAL, this.total);
                builder.field(Fields.PRIMARIES, this.primaries);
                builder.field(Fields.REPLICATION, this.getReplication());
                builder.startObject(Fields.INDEX);
                this.addIntMinMax(Fields.SHARDS, this.minIndexShards, this.maxIndexShards, this.getAvgIndexShards(), builder);
                this.addIntMinMax(Fields.PRIMARIES, this.minIndexPrimaryShards, this.maxIndexPrimaryShards, this.getAvgIndexPrimaryShards(), builder);
                this.addDoubleMinMax(Fields.REPLICATION, this.minIndexReplication, this.maxIndexReplication, this.getAvgIndexReplication(), builder);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public String toString() {
            return "total [" + this.total + "] primaries [" + this.primaries + "]";
        }

        static final class Fields {
            static final XContentBuilderString SHARDS = new XContentBuilderString("shards");
            static final XContentBuilderString TOTAL = new XContentBuilderString("total");
            static final XContentBuilderString PRIMARIES = new XContentBuilderString("primaries");
            static final XContentBuilderString REPLICATION = new XContentBuilderString("replication");
            static final XContentBuilderString MIN = new XContentBuilderString("min");
            static final XContentBuilderString MAX = new XContentBuilderString("max");
            static final XContentBuilderString AVG = new XContentBuilderString("avg");
            static final XContentBuilderString INDEX = new XContentBuilderString("index");

            Fields() {
            }
        }
    }

    static final class Fields {
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }
}

