/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles.hdr;

import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.AbstractInternalHDRPercentiles;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class InternalHDRPercentiles
extends AbstractInternalHDRPercentiles
implements Percentiles {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("percentiles", "hdr_percentiles");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalHDRPercentiles readResult(StreamInput in) throws IOException {
            InternalHDRPercentiles result = new InternalHDRPercentiles();
            result.readFrom(in);
            return result;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalHDRPercentiles() {
    }

    public InternalHDRPercentiles(String name, double[] percents, DoubleHistogram state, boolean keyed, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, percents, state, keyed, formatter, pipelineAggregators, metaData);
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.keys, this.state);
    }

    @Override
    public double percentile(double percent) {
        if (this.state.getTotalCount() == 0L) {
            return Double.NaN;
        }
        return this.state.getValueAtPercentile(percent);
    }

    @Override
    public String percentileAsString(double percent) {
        return this.valueAsString(String.valueOf(percent));
    }

    @Override
    public double value(double key) {
        return this.percentile(key);
    }

    @Override
    protected AbstractInternalHDRPercentiles createReduced(String name, double[] keys, DoubleHistogram merged, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        return new InternalHDRPercentiles(name, keys, merged, keyed, this.valueFormatter, pipelineAggregators, metaData);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    public static class Iter
    extends UnmodifiableIterator<Percentile> {
        private final double[] percents;
        private final DoubleHistogram state;
        private int i;

        public Iter(double[] percents, DoubleHistogram state) {
            this.percents = percents;
            this.state = state;
            this.i = 0;
        }

        public boolean hasNext() {
            return this.i < this.percents.length;
        }

        public Percentile next() {
            InternalPercentile next = new InternalPercentile(this.percents[this.i], this.state.getValueAtPercentile(this.percents[this.i]));
            ++this.i;
            return next;
        }
    }
}

