/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.view.MapModule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;

public class LastOpenedList {
    private Controller mController;
    private int maxEntries = 25;
    private List mlastOpenedList = new LinkedList();
    private Map mRestorableToMapName = new HashMap();

    public LastOpenedList(Controller c, String restored) {
        this.mController = c;
        try {
            this.maxEntries = new Integer(c.getFrame().getProperty("last_opened_list_length"));
        }
        catch (NumberFormatException e) {
            Resources.getInstance().logException(e);
        }
        this.load(restored);
    }

    public void mapOpened(MapModule mapModule) {
        if (mapModule == null || mapModule.getModel() == null) {
            return;
        }
        String restoreString = mapModule.getModel().getRestorable();
        String name = mapModule.toString();
        this.add(restoreString, name);
    }

    public void add(String restoreString, String name) {
        if (restoreString == null) {
            return;
        }
        if (this.mlastOpenedList.contains(restoreString)) {
            this.mlastOpenedList.remove(restoreString);
        }
        this.mlastOpenedList.add(0, restoreString);
        this.mRestorableToMapName.put(restoreString, name);
        while (this.mlastOpenedList.size() > this.maxEntries) {
            this.mlastOpenedList.remove(this.mlastOpenedList.size() - 1);
        }
    }

    void mapClosed(MapModule map) {
    }

    public String save() {
        String str = new String();
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            str = str.concat((String)it.next() + ";");
        }
        return str;
    }

    void load(String data) {
        if (data != null) {
            StringTokenizer token = new StringTokenizer(data, ";");
            while (token.hasMoreTokens()) {
                this.mlastOpenedList.add(token.nextToken());
            }
        }
    }

    public boolean open(String restoreable) throws FileNotFoundException, XMLParseException, MalformedURLException, IOException, URISyntaxException {
        boolean changedToMapModule = this.mController.getMapModuleManager().tryToChangeToMapModule((String)this.mRestorableToMapName.get(restoreable));
        if (restoreable != null && !changedToMapModule) {
            String mode = Tools.getModeFromRestorable(restoreable);
            String fileName = Tools.getFileNameFromRestorable(restoreable);
            if (this.mController.createNewMode(mode)) {
                this.mController.getMode().restore(fileName);
                return true;
            }
        }
        return false;
    }

    ListIterator listIterator() {
        return this.mlastOpenedList.listIterator();
    }
}

