/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.AlphabetRegistrationException;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.cyrillic.CyrillicRegistration;
import org.scilab.forge.jlatexmath.greek.GreekRegistration;

public class WebStartAlphabetRegistration
implements AlphabetRegistration {
    private Character.UnicodeBlock[] blocks;
    private AlphabetRegistration reg;

    private WebStartAlphabetRegistration(Character.UnicodeBlock[] unicodeBlockArray) {
        this.blocks = unicodeBlockArray;
    }

    public static void register(Character.UnicodeBlock[] unicodeBlockArray) {
        DefaultTeXFont.registerAlphabet(new WebStartAlphabetRegistration(unicodeBlockArray));
    }

    public Character.UnicodeBlock[] getUnicodeBlock() {
        return this.blocks;
    }

    public Object getPackage() throws AlphabetRegistrationException {
        if (this.blocks == JLM_GREEK) {
            this.reg = new GreekRegistration();
        } else if (this.blocks == JLM_CYRILLIC) {
            this.reg = new CyrillicRegistration();
        } else {
            throw new AlphabetRegistrationException("Invalid Unicode Block");
        }
        return this.reg;
    }

    public String getTeXFontFileName() {
        return this.reg.getTeXFontFileName();
    }
}

