/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CoordinateConflictResolveCommand
extends ConflictResolveCommand {
    private final Conflict<? extends OsmPrimitive> conflict;
    private final MergeDecisionType decision;

    public CoordinateConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict, MergeDecisionType mergeDecisionType) {
        this.conflict = conflict;
        this.decision = mergeDecisionType;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in coordinates in {0}", this.conflict.getMy().getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (!this.decision.equals((Object)MergeDecisionType.KEEP_MINE)) {
            if (this.decision.equals((Object)MergeDecisionType.KEEP_THEIR)) {
                Node node = (Node)this.conflict.getMy();
                Node node2 = (Node)this.conflict.getTheir();
                node.setCoor(node2.getCoor());
            } else {
                throw new IllegalStateException(I18n.tr("Cannot resolve undecided conflict.", new Object[0]));
            }
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.conflict == null ? 0 : this.conflict.hashCode());
        n = 31 * n + (this.decision == null ? 0 : this.decision.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CoordinateConflictResolveCommand coordinateConflictResolveCommand = (CoordinateConflictResolveCommand)object;
        if (this.conflict == null ? coordinateConflictResolveCommand.conflict != null : !this.conflict.equals(coordinateConflictResolveCommand.conflict)) {
            return false;
        }
        return this.decision == coordinateConflictResolveCommand.decision;
    }
}

