/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.gui.MapView;

public class PaintVisitor
extends AbstractVisitor
implements ValidatorVisitor {
    private final Graphics g;
    private final MapView mv;
    private Color color;
    private boolean selected;
    private final Set<PaintedPoint> paintedPoints = new HashSet<PaintedPoint>();
    private final Set<PaintedSegment> paintedSegments = new HashSet<PaintedSegment>();

    public PaintVisitor(Graphics graphics, MapView mapView) {
        this.g = graphics;
        this.mv = mapView;
    }

    @Override
    public void visit(TestError testError) {
        if (testError != null && !testError.isIgnored()) {
            this.color = testError.getSeverity().getColor();
            this.selected = testError.isSelected();
            testError.visitHighlighted(this);
        }
    }

    @Override
    public void visit(OsmPrimitive osmPrimitive) {
        if (osmPrimitive.isUsable()) {
            osmPrimitive.accept(this);
        }
    }

    protected void drawNode(Node node, Color color) {
        PaintedPoint paintedPoint = new PaintedPoint(node.getCoor(), color);
        if (!this.paintedPoints.contains(paintedPoint)) {
            Point point = this.mv.getPoint(node);
            this.g.setColor(color);
            if (this.selected) {
                this.g.fillOval(point.x - 5, point.y - 5, 10, 10);
            } else {
                this.g.drawOval(point.x - 5, point.y - 5, 10, 10);
            }
            this.paintedPoints.add(paintedPoint);
        }
    }

    protected void drawSegment(Point point, Point point2, Color color) {
        this.g.setColor(color);
        double d = Math.atan2(point2.x - point.x, point2.y - point.y);
        double d2 = 5.0 * Math.cos(d);
        double d3 = 5.0 * Math.sin(d);
        int n = (int)Math.toDegrees(d);
        if (this.selected) {
            int[] nArray = new int[]{(int)((double)point.x + d2), (int)((double)point2.x + d2), (int)((double)point2.x - d2), (int)((double)point.x - d2)};
            int[] nArray2 = new int[]{(int)((double)point.y - d3), (int)((double)point2.y - d3), (int)((double)point2.y + d3), (int)((double)point.y + d3)};
            this.g.fillPolygon(nArray, nArray2, 4);
            this.g.fillArc(point.x - 5, point.y - 5, 10, 10, n, 180);
            this.g.fillArc(point2.x - 5, point2.y - 5, 10, 10, n, -180);
        } else {
            this.g.drawLine((int)((double)point.x + d2), (int)((double)point.y - d3), (int)((double)point2.x + d2), (int)((double)point2.y - d3));
            this.g.drawLine((int)((double)point.x - d2), (int)((double)point.y + d3), (int)((double)point2.x - d2), (int)((double)point2.y + d3));
            this.g.drawArc(point.x - 5, point.y - 5, 10, 10, n, 180);
            this.g.drawArc(point2.x - 5, point2.y - 5, 10, 10, n, -180);
        }
    }

    protected void drawSegment(Node node, Node node2, Color color) {
        PaintedSegment paintedSegment;
        if (node.isDrawable() && node2.isDrawable() && this.isSegmentVisible(node, node2) && !this.paintedSegments.contains(paintedSegment = new PaintedSegment(node.getCoor(), node2.getCoor(), color))) {
            this.drawSegment(this.mv.getPoint(node), this.mv.getPoint(node2), color);
            this.paintedSegments.add(paintedSegment);
        }
    }

    @Override
    public void visit(Node node) {
        if (node.isDrawable() && this.isNodeVisible(node)) {
            this.drawNode(node, this.color);
        }
    }

    @Override
    public void visit(Way way) {
        this.visit(way.getNodes());
    }

    @Override
    public void visit(WaySegment waySegment) {
        if (waySegment.lowerIndex < 0 || waySegment.lowerIndex + 1 >= waySegment.way.getNodesCount()) {
            return;
        }
        Node node = waySegment.way.getNodes().get(waySegment.lowerIndex);
        Node node2 = waySegment.way.getNodes().get(waySegment.lowerIndex + 1);
        this.drawSegment(node, node2, this.color);
    }

    @Override
    public void visit(Relation relation) {
    }

    protected boolean isNodeVisible(Node node) {
        Point point = this.mv.getPoint(node);
        return point.x >= 0 && point.y >= 0 && point.x <= this.mv.getWidth() && point.y <= this.mv.getHeight();
    }

    protected boolean isSegmentVisible(Node node, Node node2) {
        Point point = this.mv.getPoint(node);
        Point point2 = this.mv.getPoint(node2);
        if (point.x < 0 && point2.x < 0) {
            return false;
        }
        if (point.y < 0 && point2.y < 0) {
            return false;
        }
        if (point.x > this.mv.getWidth() && point2.x > this.mv.getWidth()) {
            return false;
        }
        return point.y <= this.mv.getHeight() || point2.y <= this.mv.getHeight();
    }

    @Override
    public void visit(List<Node> list) {
        Node node = null;
        for (Node node2 : list) {
            if (node == null) {
                node = node2;
                continue;
            }
            this.drawSegment(node, node2, this.color);
            node = node2;
        }
    }

    public void clearPaintedObjects() {
        this.paintedPoints.clear();
        this.paintedSegments.clear();
    }

    protected static class PaintedSegment
    extends PaintedPoint {
        private final LatLon p2;

        public PaintedSegment(LatLon latLon, LatLon latLon2, Color color) {
            super(latLon, color);
            this.p2 = latLon2;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + this.p2.hashCode();
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            PaintedSegment paintedSegment = (PaintedSegment)object;
            return this.p2.equals(paintedSegment.p2);
        }
    }

    protected static class PaintedPoint {
        protected final LatLon p1;
        protected final Color color;

        public PaintedPoint(LatLon latLon, Color color) {
            this.p1 = latLon;
            this.color = color;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.p1.hashCode();
            n = 31 * n + this.color.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PaintedPoint paintedPoint = (PaintedPoint)object;
            if (!this.p1.equals(paintedPoint.p1)) {
                return false;
            }
            return this.color.equals(paintedPoint.color);
        }
    }
}

