/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.ScanexTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TemplatedTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.imagery.CachedAttributionBingAerialTileSource;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.tools.I18n;

public class TMSLayer
extends AbstractCachedTileSourceLayer {
    private static final String CACHE_REGION_NAME = "TMS";
    private static final String PREFERENCE_PREFIX = "imagery.tms";
    public static final IntegerProperty PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.tms.min_zoom_lvl", AbstractTileSourceLayer.PROP_MIN_ZOOM_LVL.get());
    public static final IntegerProperty PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.tms.max_zoom_lvl", AbstractTileSourceLayer.PROP_MAX_ZOOM_LVL.get());
    public static final BooleanProperty PROP_ADD_TO_SLIPPYMAP_CHOOSER = new BooleanProperty("imagery.tms.add_to_slippymap_chooser", true);

    public TMSLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
    }

    @Override
    protected AbstractTMSTileSource getTileSource(ImageryInfo imageryInfo) throws IllegalArgumentException {
        return TMSLayer.getTileSourceStatic(imageryInfo, new Runnable(){

            @Override
            public void run() {
                Main.debug("Attribution loaded, running loadAllErrorTiles");
                TMSLayer.this.loadAllErrorTiles(true);
            }
        });
    }

    @Override
    public final boolean isProjectionSupported(Projection projection) {
        return "EPSG:3857".equals(projection.toCode()) || "EPSG:4326".equals(projection.toCode());
    }

    @Override
    public final String nameSupportedProjections() {
        return I18n.tr("EPSG:4326 and Mercator projection are supported", new Object[0]);
    }

    public static AbstractTMSTileSource getTileSourceStatic(ImageryInfo imageryInfo) throws IllegalArgumentException {
        return TMSLayer.getTileSourceStatic(imageryInfo, null);
    }

    public static AbstractTMSTileSource getTileSourceStatic(ImageryInfo imageryInfo, Runnable runnable) throws IllegalArgumentException {
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.TMS) {
            TemplatedTMSTileSource.checkUrl(imageryInfo.getUrl());
            TemplatedTMSTileSource templatedTMSTileSource = new TemplatedTMSTileSource(imageryInfo);
            imageryInfo.setAttribution(templatedTMSTileSource);
            return templatedTMSTileSource;
        }
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.BING) {
            return new CachedAttributionBingAerialTileSource(imageryInfo, runnable);
        }
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.SCANEX) {
            return new ScanexTileSource(imageryInfo);
        }
        return null;
    }

    @Override
    protected Class<? extends TileLoader> getTileLoaderClass() {
        return TMSCachedTileLoader.class;
    }

    @Override
    protected String getCacheName() {
        return CACHE_REGION_NAME;
    }

    public static CacheAccess<String, BufferedImageCacheEntry> getCache() {
        return AbstractCachedTileSourceLayer.getCache(CACHE_REGION_NAME);
    }
}

