/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public class WikiReader {
    private final String baseurl;

    public WikiReader(String string) {
        this.baseurl = string;
    }

    public WikiReader() {
        this(Main.pref.get("help.baseurl", Main.getJOSMWebsite()));
    }

    public final String getBaseUrlWiki() {
        return this.baseurl + "/wiki/";
    }

    public String read(String string) throws IOException {
        URL uRL = new URL(string);
        try (BufferedReader bufferedReader = Utils.openURLReader(uRL);){
            boolean bl = string.endsWith("?format=txt");
            if (string.startsWith(this.getBaseUrlWiki()) && !bl) {
                String string2 = this.readFromTrac(bufferedReader, uRL);
                return string2;
            }
            String string3 = WikiReader.readNormal(bufferedReader, !bl);
            return string3;
        }
    }

    public String readLang(String string) throws IOException {
        String string2 = "";
        String string3 = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.DEFAULTNOTENGLISH);
        if (string3 != null) {
            string2 = this.readLang(new URL(this.getBaseUrlWiki() + string3 + string));
        }
        if (string2.isEmpty() && (string3 = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.BASELANGUAGE)) != null) {
            string2 = this.readLang(new URL(this.getBaseUrlWiki() + string3 + string));
        }
        if (string2.isEmpty() && (string3 = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.ENGLISH)) != null) {
            string2 = this.readLang(new URL(this.getBaseUrlWiki() + string3 + string));
        }
        if (string2.isEmpty()) {
            throw new IOException(string + " does not exist");
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLang(URL uRL) throws IOException {
        try (BufferedReader bufferedReader = Utils.openURLReader(uRL);){
            String string = this.readFromTrac(bufferedReader, uRL);
            return string;
        }
        catch (IOException iOException) {
            Main.addNetworkError(uRL, Utils.getRootCause(iOException));
            throw iOException;
        }
    }

    private static String readNormal(BufferedReader bufferedReader, boolean bl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = bufferedReader.readLine();
        while (string != null) {
            if (!string.contains("[[TranslatedPages]]")) {
                stringBuilder.append(string.replaceAll(" />", ">")).append('\n');
            }
            string = bufferedReader.readLine();
        }
        return bl ? "<html>" + stringBuilder + "</html>" : stringBuilder.toString();
    }

    protected String readFromTrac(BufferedReader bufferedReader, URL uRL) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuilder2.append(string);
            if (string.contains("<div id=\"searchable\">")) {
                bl = true;
            } else if (string.contains("<div class=\"wiki-toc trac-nav\"")) {
                bl2 = true;
            } else if (string.contains("<div class=\"wikipage searchable\">")) {
                bl = true;
            } else if (string.contains("<div class=\"buttons\">")) {
                bl = false;
            } else if (string.contains("<h3>Attachments</h3>")) {
                bl = false;
            } else if (string.contains("<div id=\"attachments\">")) {
                bl = false;
            } else if (string.contains("<div class=\"trac-modifiedby\">")) {
                bl3 = true;
            }
            if (bl && !bl2 && !bl3) {
                stringBuilder.append(string.replaceAll("<img ", "<img border=\"0\" ").replaceAll("width=\"(\\d+)\"", "").replaceAll("<span class=\"icon\">.</span>", "").replaceAll("href=\"/", "href=\"" + this.baseurl + '/').replaceAll(" />", ">")).append('\n');
            } else if (bl2 && string.contains("</div>")) {
                bl2 = false;
            }
            if (string.contains("</div>")) {
                bl3 = false;
            }
            string = bufferedReader.readLine();
        }
        if (stringBuilder.indexOf("      Describe ") >= 0 || stringBuilder.indexOf(" does not exist. You can create it here.</p>") >= 0) {
            return "";
        }
        if (stringBuilder.length() == 0) {
            stringBuilder = stringBuilder2;
        }
        return "<html><base href=\"" + uRL.toExternalForm() + "\"> " + stringBuilder + "</html>";
    }
}

