/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes.serial;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.nodes.serial.SerializerConstantPool;
import com.oracle.truffle.api.nodes.serial.UnsupportedConstantPoolTypeException;
import com.oracle.truffle.api.nodes.serial.VariableLengthIntBuffer;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import sun.misc.Unsafe;

public final class PostOrderDeserializer {
    private static final Unsafe unsafe = PostOrderDeserializer.loadUnsafe();
    private final SerializerConstantPool cp;
    private final HierarchicalStack stack = new HierarchicalStack();

    public PostOrderDeserializer(SerializerConstantPool cp) {
        this.cp = cp;
    }

    public <T extends Node> T deserialize(byte[] bytes, Class<T> expectedType) throws UnsupportedConstantPoolTypeException {
        VariableLengthIntBuffer buffer = new VariableLengthIntBuffer(bytes);
        while (buffer.hasRemaining()) {
            int classCPI = buffer.get();
            if (classCPI == -1) {
                this.pushNode(null);
                continue;
            }
            Class<?> clazz = this.cp.getClass(classCPI);
            if (clazz.isArray()) {
                int lengthCPI = buffer.get();
                if (lengthCPI == -1) {
                    this.pushArray(null);
                    continue;
                }
                this.pushArray((Node[])Array.newInstance(clazz.getComponentType(), this.cp.getInt(lengthCPI)));
                continue;
            }
            this.pushNode(this.invokeDeserialize(buffer, clazz.asSubclass(Node.class)));
        }
        Node returnNode = this.popNode(null, expectedType);
        assert (this.stack.dynamicStack.isEmpty());
        return (T)returnNode;
    }

    private void pushNode(Node node) {
        this.stack.push(node);
    }

    private void pushArray(Node[] array) {
        this.stack.pushStack(array);
    }

    private Node[] popArray(Node parent, Class<?> expectedType) {
        Node[] array = (Node[])this.stack.popStack();
        if (array != null) {
            PostOrderDeserializer.assertType(array, expectedType);
            int i = 0;
            while (i < array.length) {
                PostOrderDeserializer.updateParent(parent, array[i]);
                ++i;
            }
        }
        return array;
    }

    private Node popNode(Node parent, Class<?> expectedType) {
        Object o = this.stack.pop();
        PostOrderDeserializer.assertType(o, expectedType);
        PostOrderDeserializer.updateParent(parent, (Node)o);
        return (Node)o;
    }

    private static void assertType(Object o, Class<?> expectedType) {
        if (o != null && !expectedType.isAssignableFrom(o.getClass())) {
            throw new AssertionError((Object)("Expected element type '" + expectedType.getName() + "' but was '" + o.getClass().getName() + "'."));
        }
    }

    private Node invokeDeserialize(VariableLengthIntBuffer buffer, Class<? extends Node> nodeClass) throws UnsupportedConstantPoolTypeException {
        Object object;
        if (nodeClass == null) {
            return null;
        }
        try {
            object = unsafe.allocateInstance(nodeClass);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to allocate truffle node " + nodeClass, e);
        }
        if (!(object instanceof Node)) {
            throw new RuntimeException("Class is not a truffle node " + nodeClass);
        }
        Node node = (Node)object;
        NodeFieldAccessor[] nodeFields = NodeClass.get(nodeClass).getFields();
        this.deserializeChildrenFields(node, nodeFields);
        this.deserializeChildFields(node, nodeFields);
        this.deserializeDataFields(buffer, node, nodeFields);
        return node;
    }

    private void deserializeDataFields(VariableLengthIntBuffer buffer, Node nodeInstance, NodeFieldAccessor[] nodeFields) throws UnsupportedConstantPoolTypeException {
        int i = 0;
        while (i < nodeFields.length) {
            NodeFieldAccessor field = nodeFields[i];
            if (field.getKind() == NodeFieldAccessor.NodeFieldKind.DATA) {
                Class<?> fieldClass = field.getType();
                long offset = field.getOffset();
                if (!field.getType().isAssignableFrom(SourceSection.class)) {
                    int cpi = buffer.get();
                    if (cpi == -1) {
                        PostOrderDeserializer.deserializeDataFieldsLengthNull(nodeInstance, fieldClass, offset);
                    } else {
                        this.deserializeDataFieldsDefault(nodeInstance, fieldClass, offset, cpi);
                    }
                }
            }
            ++i;
        }
    }

    private void deserializeDataFieldsDefault(Node nodeInstance, Class<?> fieldClass, long offset, int cpi) {
        if (fieldClass == Integer.TYPE) {
            unsafe.putInt(nodeInstance, offset, this.cp.getInt(cpi));
        } else if (fieldClass == Long.TYPE) {
            unsafe.putLong(nodeInstance, offset, this.cp.getLong(cpi));
        } else if (fieldClass == Float.TYPE) {
            unsafe.putFloat(nodeInstance, offset, this.cp.getFloat(cpi));
        } else if (fieldClass == Double.TYPE) {
            unsafe.putDouble(nodeInstance, offset, this.cp.getDouble(cpi));
        } else if (fieldClass == Byte.TYPE) {
            unsafe.putByte(nodeInstance, offset, (byte)this.cp.getInt(cpi));
        } else if (fieldClass == Short.TYPE) {
            unsafe.putShort(nodeInstance, offset, (short)this.cp.getInt(cpi));
        } else if (fieldClass == Character.TYPE) {
            unsafe.putChar(nodeInstance, offset, (char)this.cp.getInt(cpi));
        } else if (fieldClass == Boolean.TYPE) {
            unsafe.putBoolean(nodeInstance, offset, this.cp.getInt(cpi) == 1);
        } else if (fieldClass == Integer.class) {
            unsafe.putObject(nodeInstance, offset, this.cp.getInt(cpi));
        } else if (fieldClass == Long.class) {
            unsafe.putObject(nodeInstance, offset, this.cp.getLong(cpi));
        } else if (fieldClass == Float.class) {
            unsafe.putObject(nodeInstance, offset, Float.valueOf(this.cp.getFloat(cpi)));
        } else if (fieldClass == Double.class) {
            unsafe.putObject(nodeInstance, offset, this.cp.getDouble(cpi));
        } else if (fieldClass == Byte.class) {
            unsafe.putObject(nodeInstance, offset, (byte)this.cp.getInt(cpi));
        } else if (fieldClass == Short.class) {
            unsafe.putObject(nodeInstance, offset, (short)this.cp.getInt(cpi));
        } else if (fieldClass == Character.class) {
            unsafe.putObject(nodeInstance, offset, Character.valueOf((char)this.cp.getInt(cpi)));
        } else if (fieldClass == Boolean.class) {
            unsafe.putObject(nodeInstance, offset, this.cp.getInt(cpi) == 1 ? Boolean.TRUE : Boolean.FALSE);
        } else {
            unsafe.putObject(nodeInstance, offset, this.cp.getObject(fieldClass, cpi));
        }
    }

    private static void deserializeDataFieldsLengthNull(Node nodeInstance, Class<?> fieldClass, long offset) {
        if (fieldClass == Integer.TYPE) {
            unsafe.putInt(nodeInstance, offset, 0);
        } else if (fieldClass == Long.TYPE) {
            unsafe.putLong(nodeInstance, offset, 0L);
        } else if (fieldClass == Float.TYPE) {
            unsafe.putFloat(nodeInstance, offset, 0.0f);
        } else if (fieldClass == Double.TYPE) {
            unsafe.putDouble(nodeInstance, offset, 0.0);
        } else if (fieldClass == Byte.TYPE) {
            unsafe.putByte(nodeInstance, offset, (byte)0);
        } else if (fieldClass == Short.TYPE) {
            unsafe.putShort(nodeInstance, offset, (short)0);
        } else if (fieldClass == Character.TYPE) {
            unsafe.putChar(nodeInstance, offset, '\u0000');
        } else if (fieldClass == Boolean.TYPE) {
            unsafe.putBoolean(nodeInstance, offset, false);
        } else {
            unsafe.putObject(nodeInstance, offset, null);
        }
    }

    private void deserializeChildFields(Node parent, NodeFieldAccessor[] nodeFields) {
        int i = nodeFields.length - 1;
        while (i >= 0) {
            NodeFieldAccessor field = nodeFields[i];
            if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD) {
                unsafe.putObject(parent, field.getOffset(), this.popNode(parent, field.getType()));
            }
            --i;
        }
    }

    private void deserializeChildrenFields(Node parent, NodeFieldAccessor[] nodeFields) {
        int i = nodeFields.length - 1;
        while (i >= 0) {
            NodeFieldAccessor field = nodeFields[i];
            if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN) {
                unsafe.putObject(parent, field.getOffset(), this.popArray(parent, field.getType()));
            }
            --i;
        }
    }

    private static Node updateParent(Node parent, Node child) {
        if (child != null) {
            NodeClass nodeClass = NodeClass.get(child.getClass());
            nodeClass.getNodeClassField().putObject(child, nodeClass);
            nodeClass.getParentField().putObject(child, parent);
        }
        return child;
    }

    private static Unsafe loadUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    private static class FixedSizeNodeStack {
        private final Object[] array;
        private int tos;

        FixedSizeNodeStack(Object[] array) {
            this.array = array;
        }

        boolean isFull() {
            return this.tos == this.array.length;
        }

        boolean isEmpty() {
            return this.tos == 0;
        }

        private void push(Object node) {
            if (this.tos >= this.array.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            unsafe.putObject(this.array, (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE * (long)this.tos++, node);
        }

        private Object pop() {
            if (this.tos <= 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return unsafe.getObject(this.array, (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE * (long)(--this.tos));
        }

        private Object[] getArray() {
            return this.array;
        }
    }

    private static class HierarchicalStack {
        private static final Object NULL_STACK = new Object();
        private final List<Object> dynamicStack = new ArrayList<Object>();

        private HierarchicalStack() {
        }

        void pushStack(Object[] array) {
            if (array == null) {
                this.dynamicStack.add(NULL_STACK);
            } else {
                this.dynamicStack.add(new FixedSizeNodeStack(array));
            }
        }

        private FixedSizeNodeStack getTosStack() {
            if (this.dynamicStack.isEmpty()) {
                return null;
            }
            Object peekTos = this.dynamicStack.get(this.dynamicStack.size() - 1);
            if (peekTos != null && peekTos.getClass() == FixedSizeNodeStack.class) {
                return (FixedSizeNodeStack)peekTos;
            }
            return null;
        }

        Object[] popStack() {
            Object tos = this.dynamicStack.remove(this.dynamicStack.size() - 1);
            if (tos == NULL_STACK) {
                return null;
            }
            return ((FixedSizeNodeStack)tos).getArray();
        }

        void push(Object o) {
            FixedSizeNodeStack tosStack = this.getTosStack();
            if (tosStack != null && !tosStack.isFull()) {
                tosStack.push(o);
            } else {
                this.dynamicStack.add(o);
            }
        }

        Object pop() {
            Object value;
            FixedSizeNodeStack tosStack = this.getTosStack();
            if (tosStack != null) {
                assert (!tosStack.isEmpty());
                value = tosStack.pop();
            } else {
                value = this.dynamicStack.remove(this.dynamicStack.size() - 1);
            }
            assert (value != NULL_STACK);
            return value;
        }
    }
}

