/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.basic;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.ObjectLocation;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LayoutStrategy;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.Locations;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.basic.BasicLocations;
import com.oracle.truffle.object.basic.DynamicObjectBasic;
import com.oracle.truffle.object.basic.ShapeBasic;
import java.util.EnumSet;

public class BasicLayout
extends LayoutImpl {
    private final ObjectLocation[] objectFields = DynamicObjectBasic.OBJECT_FIELD_LOCATIONS;
    private final LocationImpl.InternalLongLocation[] primitiveFields = DynamicObjectBasic.PRIMITIVE_FIELD_LOCATIONS;
    private final Location objectArrayLocation;
    private final Location primitiveArrayLocation = DynamicObjectBasic.PRIMITIVE_ARRAY_LOCATION;

    BasicLayout(EnumSet<Layout.ImplicitCast> allowedImplicitCasts, LayoutStrategy strategy) {
        super(allowedImplicitCasts, DynamicObjectBasic.class, strategy);
        this.objectArrayLocation = DynamicObjectBasic.OBJECT_ARRAY_LOCATION;
    }

    static LayoutImpl createLayoutImpl(EnumSet<Layout.ImplicitCast> allowedImplicitCasts, LayoutStrategy strategy) {
        return new BasicLayout(allowedImplicitCasts, strategy);
    }

    @Override
    public DynamicObject newInstance(Shape shape) {
        return new DynamicObjectBasic(shape);
    }

    @Override
    public Shape createShape(ObjectType operations, Object sharedData, int id) {
        return new ShapeBasic((Layout)this, sharedData, operations, id);
    }

    @Override
    protected boolean hasObjectExtensionArray() {
        return true;
    }

    @Override
    protected boolean hasPrimitiveExtensionArray() {
        return true;
    }

    @Override
    protected int getObjectFieldCount() {
        return this.objectFields.length;
    }

    @Override
    protected int getPrimitiveFieldCount() {
        return this.primitiveFields.length;
    }

    @Override
    protected Location getObjectArrayLocation() {
        return this.objectArrayLocation;
    }

    @Override
    protected Location getPrimitiveArrayLocation() {
        return this.primitiveArrayLocation;
    }

    protected ObjectLocation getObjectFieldLocation(int index) {
        return this.objectFields[index];
    }

    protected LocationImpl.InternalLongLocation getPrimitiveFieldLocation(int index) {
        return this.primitiveFields[index];
    }

    @Override
    public Shape.Allocator createAllocator() {
        BasicLayout layout = this;
        ShapeImpl.BaseAllocator allocator = this.getStrategy().createAllocator(layout);
        return allocator;
    }

    @Override
    protected int objectFieldIndex(Location location) {
        if (location instanceof Locations.DualLocation) {
            return this.objectFieldIndex((Location)((Object)((Locations.DualLocation)location).getObjectLocation()));
        }
        if (location instanceof BasicLocations.ObjectFieldLocation) {
            return ((BasicLocations.ObjectFieldLocation)location).getIndex();
        }
        if (location instanceof BasicLocations.SimpleObjectFieldLocation) {
            return ((BasicLocations.SimpleObjectFieldLocation)location).getIndex();
        }
        return 0;
    }
}

