/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.exceptions.RaiseException;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.CmpIntNode;
import org.jruby.truffle.nodes.cast.CmpIntNodeGen;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.coerce.ToIntNodeGen;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.EncodingNodes;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.StringGuards;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayCoreMethodNode;
import org.jruby.truffle.nodes.core.fixnum.FixnumLowerNodeGen;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.nodes.rubinius.ByteArrayNodes;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodes;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.EncodingOperations;
import org.jruby.truffle.runtime.core.StringCodeRangeableWrapper;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.CodeRangeable;
import org.jruby.util.ConvertDouble;
import org.jruby.util.Pack;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

@CoreClass(name="String")
public abstract class StringNodes {

    public static class StringNodesHelper {
        public static int checkIndex(int length, int index, RubyNode node) {
            if (index > length) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
            }
            if (index < 0) {
                if (-index > length) {
                    CompilerDirectives.transferToInterpreter();
                    throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
                }
                index += length;
            }
            return index;
        }

        public static int checkIndexForRef(DynamicObject string, int index, RubyNode node) {
            assert (RubyGuards.isRubyString(string));
            int length = StringOperations.getByteList(string).getRealSize();
            if (index >= length) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
            }
            if (index < 0) {
                if (-index > length) {
                    CompilerDirectives.transferToInterpreter();
                    throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
                }
                index += length;
            }
            return index;
        }

        @CompilerDirectives.TruffleBoundary
        public static void replaceInternal(DynamicObject string, int start, int length, DynamicObject replacement) {
            assert (RubyGuards.isRubyString(string));
            assert (RubyGuards.isRubyString(replacement));
            StringSupport.replaceInternal19((int)start, (int)length, (CodeRangeable)StringOperations.getCodeRangeable(string), (CodeRangeable)StringOperations.getCodeRangeable(replacement));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object trTransHelper(RubyContext context, DynamicObject self, DynamicObject fromStr, DynamicObject toStr, boolean sFlag) {
            assert (RubyGuards.isRubyString(self));
            assert (RubyGuards.isRubyString(fromStr));
            assert (RubyGuards.isRubyString(toStr));
            CodeRangeable ret = StringSupport.trTransHelper((Ruby)context.getRuntime(), (CodeRangeable)StringOperations.getCodeRangeable(self), (CodeRangeable)StringOperations.getCodeRangeable(fromStr), (CodeRangeable)StringOperations.getCodeRangeable(toStr), (boolean)sFlag);
            if (ret == null) {
                return context.getCoreLibrary().getNilObject();
            }
            return self;
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject clear(DynamicObject string) {
            ByteList empty = new ByteList(0);
            empty.setEncoding(StringOperations.getByteList(string).getEncoding());
            Layouts.STRING.setByteList(string, empty);
            return string;
        }
    }

    @CoreMethod(names={"capitalize"}, taintFromSelf=true)
    public static abstract class CapitalizeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        CallDispatchHeadNode capitalizeBangNode;
        @Node.Child
        CallDispatchHeadNode dupNode;

        public CapitalizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.capitalizeBangNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.dupNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object capitalize(VirtualFrame frame, DynamicObject string) {
            Object duped = this.dupNode.call(frame, string, "dup", null, new Object[0]);
            this.capitalizeBangNode.call(frame, duped, "capitalize!", null, new Object[0]);
            return duped;
        }
    }

    @CoreMethod(names={"capitalize!"}, raiseIfFrozenSelf=true)
    public static abstract class CapitalizeBangNode
    extends CoreMethodArrayArgumentsNode {
        public CapitalizeBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public DynamicObject capitalizeBang(DynamicObject string) {
            ByteList value = StringOperations.getByteList(string);
            Encoding enc = value.getEncoding();
            if (enc.isDummy()) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", enc), this));
            }
            if (value.getRealSize() == 0) {
                return this.nil();
            }
            StringOperations.modifyAndKeepCodeRange(string);
            int s = value.getBegin();
            int end = s + value.getRealSize();
            byte[] bytes = value.getUnsafeBytes();
            boolean modify = false;
            int c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)s, (int)end);
            if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper((Encoding)enc, (int)c), bytes, s);
                modify = true;
            }
            s += StringSupport.codeLength((Encoding)enc, (int)c);
            while (s < end) {
                c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)s, (int)end);
                if (enc.isUpper(c)) {
                    enc.codeToMbc(StringSupport.toLower((Encoding)enc, (int)c), bytes, s);
                    modify = true;
                }
                s += StringSupport.codeLength((Encoding)enc, (int)c);
            }
            return modify ? string : this.nil();
        }
    }

    @CoreMethod(names={"valid_encoding?"})
    public static abstract class ValidEncodingQueryNode
    extends CoreMethodArrayArgumentsNode {
        public ValidEncodingQueryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean validEncodingQuery(DynamicObject string) {
            return StringOperations.scanForCodeRange(string) != 48;
        }
    }

    @CoreMethod(names={"upcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class UpcaseBangNode
    extends CoreMethodArrayArgumentsNode {
        public UpcaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public DynamicObject upcaseSingleByte(DynamicObject string) {
            StringCodeRangeableWrapper codeRangeable = StringOperations.getCodeRangeable(string);
            ByteList bytes = codeRangeable.getByteList();
            if (bytes.realSize() == 0) {
                return this.nil();
            }
            codeRangeable.modifyAndKeepCodeRange();
            boolean modified = this.singleByteUpcase(bytes.unsafeBytes(), bytes.begin(), bytes.realSize());
            if (modified) {
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public DynamicObject upcase(DynamicObject string) {
            StringCodeRangeableWrapper codeRangeable = StringOperations.getCodeRangeable(string);
            ByteList bytes = codeRangeable.getByteList();
            Encoding encoding = bytes.getEncoding();
            if (encoding.isDummy()) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", encoding), this));
            }
            if (bytes.realSize() == 0) {
                return this.nil();
            }
            codeRangeable.modifyAndKeepCodeRange();
            try {
                boolean modified = this.multiByteUpcase(encoding, bytes.unsafeBytes(), bytes.begin(), bytes.realSize());
                if (modified) {
                    return string;
                }
                return this.nil();
            }
            catch (IllegalArgumentException e) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError(e.getMessage(), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean singleByteUpcase(byte[] bytes, int s, int end) {
            return StringSupport.singleByteUpcase((byte[])bytes, (int)s, (int)end);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean multiByteUpcase(Encoding encoding, byte[] bytes, int s, int end) {
            return StringSupport.multiByteUpcase((Encoding)encoding, (byte[])bytes, (int)s, (int)end);
        }
    }

    @CoreMethod(names={"upcase"}, taintFromSelf=true)
    public static abstract class UpcaseNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        CallDispatchHeadNode dupNode;
        @Node.Child
        CallDispatchHeadNode upcaseBangNode;

        public UpcaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dupNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.upcaseBangNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object upcase(VirtualFrame frame, DynamicObject string) {
            Object duped = this.dupNode.call(frame, string, "dup", null, new Object[0]);
            this.upcaseBangNode.call(frame, duped, "upcase!", null, new Object[0]);
            return duped;
        }
    }

    @CoreMethod(names={"unpack"}, required=1)
    public static abstract class UnpackNode
    extends ArrayCoreMethodNode {
        public UnpackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(format)"})
        public DynamicObject unpack(DynamicObject string, DynamicObject format) {
            RubyArray jrubyArray = Pack.unpack((Ruby)this.getContext().getRuntime(), (ByteList)StringOperations.getByteList(string), (ByteList)StringOperations.getByteList(format));
            return this.getContext().toTruffle(jrubyArray);
        }
    }

    @CoreMethod(names={"tr_s!"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="fromStr"), @NodeChild(type=RubyNode.class, value="toStrNode")})
    public static abstract class TrSBangNode
    extends CoreMethodNode {
        @Node.Child
        private DeleteBangNode deleteBangNode;

        public TrSBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), toStr);
        }

        @Specialization(guards={"isRubyString(fromStr)", "isRubyString(toStr)"})
        public Object trSBang(VirtualFrame frame, DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            if (StringOperations.getByteList(self).getRealSize() == 0) {
                return this.nil();
            }
            if (StringOperations.getByteList(toStr).getRealSize() == 0) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.deleteBangNode = this.insert(StringNodesFactory.DeleteBangNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
                }
                return this.deleteBangNode.deleteBang(frame, self, fromStr);
            }
            return StringNodesHelper.trTransHelper(this.getContext(), self, fromStr, toStr, true);
        }
    }

    @CoreMethod(names={"tr!"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="fromStr"), @NodeChild(type=RubyNode.class, value="toStrNode")})
    public static abstract class TrBangNode
    extends CoreMethodNode {
        @Node.Child
        private DeleteBangNode deleteBangNode;

        public TrBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), toStr);
        }

        @Specialization(guards={"isRubyString(fromStr)", "isRubyString(toStr)"})
        public Object trBang(VirtualFrame frame, DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            if (StringOperations.getByteList(self).getRealSize() == 0) {
                return this.nil();
            }
            if (StringOperations.getByteList(toStr).getRealSize() == 0) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.deleteBangNode = this.insert(StringNodesFactory.DeleteBangNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
                }
                return this.deleteBangNode.deleteBang(frame, self, fromStr);
            }
            return StringNodesHelper.trTransHelper(this.getContext(), self, fromStr, toStr, false);
        }
    }

    @CoreMethod(names={"reverse!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class ReverseBangNode
    extends CoreMethodArrayArgumentsNode {
        public ReverseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"reverseIsEqualToSelf(string)"})
        public DynamicObject reverseNoOp(DynamicObject string) {
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject reverseSingleByteOptimizable(DynamicObject string) {
            StringOperations.modify(string);
            byte[] bytes = StringOperations.getByteList(string).getUnsafeBytes();
            int p = StringOperations.getByteList(string).getBegin();
            int len = StringOperations.getByteList(string).getRealSize();
            for (int i = 0; i < len >> 1; ++i) {
                byte b = bytes[p + i];
                bytes[p + i] = bytes[p + len - i - 1];
                bytes[p + len - i - 1] = b;
            }
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(string)", "!isSingleByteOptimizable(string)"})
        public DynamicObject reverse(DynamicObject string) {
            StringOperations.modify(string);
            byte[] bytes = StringOperations.getByteList(string).getUnsafeBytes();
            int p = StringOperations.getByteList(string).getBegin();
            int len = StringOperations.getByteList(string).getRealSize();
            Encoding enc = StringOperations.getByteList(string).getEncoding();
            int end = p + len;
            int op = len;
            byte[] obytes = new byte[len];
            boolean single = true;
            while (p < end) {
                int cl = StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
                if (cl > 1 || (bytes[p] & 0x80) != 0) {
                    single = false;
                    System.arraycopy(bytes, p, obytes, op -= cl, cl);
                    p += cl;
                    continue;
                }
                obytes[--op] = bytes[p++];
            }
            StringOperations.getByteList(string).setUnsafeBytes(obytes);
            if (Layouts.STRING.getCodeRange(string) == 0) {
                int codeRange = single ? 16 : 32;
                Layouts.STRING.setCodeRange(string, codeRange);
            }
            return string;
        }

        public static boolean reverseIsEqualToSelf(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringOperations.getByteList(string).getRealSize() <= 1;
        }
    }

    @CoreMethod(names={"to_sym", "intern"})
    public static abstract class ToSymNode
    extends CoreMethodArrayArgumentsNode {
        public ToSymNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject toSym(DynamicObject string) {
            return this.getSymbol(StringOperations.getByteList(string));
        }
    }

    @CoreMethod(names={"to_s", "to_str"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isStringSubclass(string)"})
        public DynamicObject toS(DynamicObject string) {
            return string;
        }

        @Specialization(guards={"isStringSubclass(string)"})
        public Object toSOnSubclass(VirtualFrame frame, DynamicObject string) {
            return this.ruby(frame, "''.replace(self)", "self", string);
        }

        public boolean isStringSubclass(DynamicObject string) {
            return Layouts.BASIC_OBJECT.getLogicalClass(string) != this.getContext().getCoreLibrary().getStringClass();
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double toF(DynamicObject string) {
            try {
                return this.convertToDouble(string);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private double convertToDouble(DynamicObject string) {
            return ConvertDouble.byteListToDouble19((ByteList)StringOperations.getByteList(string), (boolean)false);
        }
    }

    @CoreMethod(names={"sum"}, optional=1)
    public static abstract class SumNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode addNode;
        @Node.Child
        private CallDispatchHeadNode subNode;
        @Node.Child
        private CallDispatchHeadNode shiftNode;
        @Node.Child
        private CallDispatchHeadNode andNode;

        public SumNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.addNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.subNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.shiftNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.andNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, int bits) {
            return this.sum(frame, string, (long)bits);
        }

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, long bits) {
            byte[] bytes = StringOperations.getByteList(string).getUnsafeBytes();
            int p = StringOperations.getByteList(string).getBegin();
            int len = StringOperations.getByteList(string).getRealSize();
            int end = p + len;
            if (bits >= 64L) {
                Object sum = 0;
                while (p < end) {
                    sum = this.addNode.call(frame, sum, "+", null, bytes[p++] & 0xFF);
                }
                if (bits != 0L) {
                    Object mod = this.shiftNode.call(frame, 1, "<<", null, bits);
                    sum = this.andNode.call(frame, sum, "&", null, this.subNode.call(frame, mod, "-", null, 1));
                }
                return sum;
            }
            long sum = 0L;
            while (p < end) {
                sum += (long)(bytes[p++] & 0xFF);
            }
            return bits == 0L ? sum : sum & (1L << (int)bits) - 1L;
        }

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, NotProvided bits) {
            return this.sum(frame, string, 16);
        }

        @Specialization(guards={"!isInteger(bits)", "!isLong(bits)", "wasProvided(bits)"})
        public Object sum(VirtualFrame frame, DynamicObject string, Object bits) {
            return this.ruby(frame, "sum Rubinius::Type.coerce_to(bits, Fixnum, :to_int)", "bits", bits);
        }
    }

    @CoreMethod(names={"succ!"}, raiseIfFrozenSelf=true)
    public static abstract class SuccBangNode
    extends CoreMethodArrayArgumentsNode {
        public SuccBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject succBang(DynamicObject string) {
            if (StringOperations.getByteList(string).getRealSize() > 0) {
                Layouts.STRING.setByteList(string, StringSupport.succCommon((Ruby)this.getContext().getRuntime(), (ByteList)StringOperations.getByteList(string)));
            }
            return string;
        }
    }

    @CoreMethod(names={"succ"}, taintFromSelf=true)
    public static abstract class SuccNode
    extends CoreMethodArrayArgumentsNode {
        public SuccNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject succ(DynamicObject string) {
            if (Layouts.STRING.getByteList(string).realSize() > 0) {
                return Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(string)), StringSupport.succCommon((Ruby)this.getContext().getRuntime(), (ByteList)StringOperations.getByteList(string)), 0, null);
            }
            return Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(string)), new ByteList(), 0, null);
        }
    }

    @CoreMethod(names={"squeeze!"}, rest=true, raiseIfFrozenSelf=true)
    public static abstract class SqueezeBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        public SqueezeBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"zeroArgs(args)"})
        public Object squeezeBangZeroArgs(DynamicObject string, Object[] args, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            if (StringOperations.getByteList(string).length() == 0) {
                return this.nil();
            }
            boolean[] squeeze = new boolean[256];
            for (int i = 0; i < 256; ++i) {
                squeeze[i] = true;
            }
            StringOperations.modifyAndKeepCodeRange(string);
            if (singleByteOptimizableProfile.profile(StringOperations.singleByteOptimizable(string)) ? !StringSupport.singleByteSqueeze((ByteList)StringOperations.getByteList(string), (boolean[])squeeze) : !this.squeezeCommonMultiByte(StringOperations.getByteList(string), squeeze, null, StringOperations.getByteList(string).getEncoding(), false)) {
                return this.nil();
            }
            return string;
        }

        @Specialization(guards={"!zeroArgs(args)"})
        public Object squeezeBang(VirtualFrame frame, DynamicObject string, Object[] args, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            if (StringOperations.getByteList(string).length() == 0) {
                return this.nil();
            }
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStrNode.executeToStr(frame, args[i]);
            }
            return this.performSqueezeBang(string, otherStrings, singleByteOptimizableProfile);
        }

        @CompilerDirectives.TruffleBoundary
        private Object performSqueezeBang(DynamicObject string, DynamicObject[] otherStrings, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            DynamicObject otherStr = otherStrings[0];
            Encoding enc = StringOperations.checkEncoding(this.getContext(), string, StringOperations.getCodeRangeable(otherStr), this);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteList(otherStr), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, null, (boolean)true, (Encoding)enc);
            boolean singlebyte = StringOperations.singleByteOptimizable(string) && StringOperations.singleByteOptimizable(otherStr);
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                enc = StringOperations.checkEncoding(this.getContext(), string, StringOperations.getCodeRangeable(otherStr), this);
                singlebyte = singlebyte && StringOperations.singleByteOptimizable(otherStr);
                tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteList(otherStr), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            StringOperations.modifyAndKeepCodeRange(string);
            if (singleByteOptimizableProfile.profile(singlebyte) ? !StringSupport.singleByteSqueeze((ByteList)StringOperations.getByteList(string), (boolean[])squeeze) : !StringSupport.multiByteSqueeze((Ruby)this.getContext().getRuntime(), (ByteList)StringOperations.getByteList(string), (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc, (boolean)true)) {
                return this.nil();
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean squeezeCommonMultiByte(ByteList value, boolean[] squeeze, StringSupport.TrTables tables, Encoding enc, boolean isArg) {
            return StringSupport.multiByteSqueeze((Ruby)this.getContext().getRuntime(), (ByteList)value, (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc, (boolean)isArg);
        }

        public static boolean zeroArgs(Object[] args) {
            return args.length == 0;
        }
    }

    @CoreMethod(names={"size", "length"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract int executeInteger(VirtualFrame var1, DynamicObject var2);

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public int sizeSingleByte(DynamicObject string) {
            return StringOperations.getByteList(string).getRealSize();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public int size(DynamicObject string) {
            return StringSupport.strLengthFromRubyString((CodeRangeable)StringOperations.getCodeRangeable(string));
        }
    }

    @CoreMethod(names={"setbyte"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class SetByteNode
    extends CoreMethodNode {
        public SetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return FixnumLowerNodeGen.create(this.getContext(), this.getSourceSection(), ToIntNodeGen.create(this.getContext(), this.getSourceSection(), index));
        }

        @CreateCast(value={"value"})
        public RubyNode coerceValueToInt(RubyNode value) {
            return FixnumLowerNodeGen.create(this.getContext(), this.getSourceSection(), ToIntNodeGen.create(this.getContext(), this.getSourceSection(), value));
        }

        @Specialization
        public int setByte(DynamicObject string, int index, int value) {
            int normalizedIndex = StringNodesHelper.checkIndexForRef(string, index, this);
            StringOperations.modify(string);
            StringOperations.clearCodeRange(string);
            StringOperations.getByteList((DynamicObject)string).getUnsafeBytes()[normalizedIndex] = (byte)value;
            return value;
        }
    }

    @CoreMethod(names={"dump"}, taintFromSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DumpNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public DumpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization(guards={"isAsciiCompatible(string)"})
        public DynamicObject dumpAsciiCompatible(DynamicObject string) {
            ByteList outputBytes = this.dumpCommon(string);
            DynamicObject result = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), outputBytes, 0, null);
            StringOperations.getByteList(result).setEncoding(StringOperations.getByteList(string).getEncoding());
            Layouts.STRING.setCodeRange(result, 16);
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isAsciiCompatible(string)"})
        public DynamicObject dump(DynamicObject string) {
            ByteList outputBytes = this.dumpCommon(string);
            try {
                outputBytes.append(".force_encoding(\"".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException(e);
            }
            outputBytes.append(StringOperations.getByteList(string).getEncoding().getName());
            outputBytes.append((byte)34);
            outputBytes.append((byte)41);
            DynamicObject result = Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(string)), outputBytes, 0, null);
            StringOperations.getByteList(result).setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            Layouts.STRING.setCodeRange(result, 16);
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private ByteList dumpCommon(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringSupport.dumpCommon((Ruby)this.getContext().getRuntime(), (ByteList)StringOperations.getByteList(string));
        }
    }

    @CoreMethod(names={"swapcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class SwapcaseBangNode
    extends CoreMethodArrayArgumentsNode {
        public SwapcaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject swapcaseSingleByte(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            ByteList value = StringOperations.getByteList(string);
            Encoding enc = value.getEncoding();
            if (enc.isDummy()) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", enc), this));
            }
            if (value.getRealSize() == 0) {
                return this.nil();
            }
            StringOperations.modifyAndKeepCodeRange(string);
            int s = value.getBegin();
            int end = s + value.getRealSize();
            byte[] bytes = value.getUnsafeBytes();
            if (singleByteOptimizableProfile.profile(StringSupport.isSingleByteOptimizable((CodeRangeable)StringOperations.getCodeRangeable(string), (Encoding)enc)) ? StringSupport.singleByteSwapcase((byte[])bytes, (int)s, (int)end) : StringSupport.multiByteSwapcase((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)s, (int)end)) {
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"rstrip!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class RstripBangNode
    extends CoreMethodArrayArgumentsNode {
        public RstripBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public Object rstripBangSingleByte(DynamicObject string) {
            int endp;
            if (StringOperations.getByteList(string).getRealSize() == 0) {
                return this.nil();
            }
            byte[] bytes = StringOperations.getByteList(string).getUnsafeBytes();
            int start = StringOperations.getByteList(string).getBegin();
            int end = start + StringOperations.getByteList(string).getRealSize();
            for (endp = end - 1; endp >= start && (bytes[endp] == 0 || ASCIIEncoding.INSTANCE.isSpace(bytes[endp] & 0xFF)); --endp) {
            }
            if (endp < end - 1) {
                StringOperations.getByteList(string).view(0, endp - start + 1);
                StringOperations.keepCodeRange(string);
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public Object rstripBang(DynamicObject string) {
            int point;
            int prev;
            int end;
            if (StringOperations.getByteList(string).getRealSize() == 0) {
                return this.nil();
            }
            Encoding enc = EncodingUtils.STR_ENC_GET((ByteListHolder)StringOperations.getCodeRangeable(string));
            byte[] bytes = StringOperations.getByteList(string).getUnsafeBytes();
            int start = StringOperations.getByteList(string).getBegin();
            int endp = end = start + StringOperations.getByteList(string).getRealSize();
            while ((prev = this.prevCharHead(enc, bytes, start, endp, end)) != -1 && ((point = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)prev, (int)end)) == 0 || ASCIIEncoding.INSTANCE.isSpace(point))) {
                endp = prev;
            }
            if (endp < end) {
                StringOperations.getByteList(string).view(0, endp - start);
                StringOperations.keepCodeRange(string);
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        private int prevCharHead(Encoding enc, byte[] bytes, int p, int s, int end) {
            return enc.prevCharHead(bytes, p, s, end);
        }
    }

    @CoreMethod(names={"replace"}, required=1, raiseIfFrozenSelf=true, taintFromParameter=0)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ReplaceNode
    extends CoreMethodNode {
        public ReplaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isRubyString(other)"})
        public DynamicObject replace(DynamicObject string, DynamicObject other) {
            if (string == other) {
                return string;
            }
            StringOperations.getByteList(string).replace(StringOperations.getByteList(other).bytes());
            StringOperations.getByteList(string).setEncoding(StringOperations.getByteList(other).getEncoding());
            Layouts.STRING.setCodeRange(string, Layouts.STRING.getCodeRange(other));
            return string;
        }
    }

    @CoreMethod(names={"ord"})
    public static abstract class OrdNode
    extends CoreMethodArrayArgumentsNode {
        public OrdNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int ord(DynamicObject string) {
            StringCodeRangeableWrapper codeRangeable = StringOperations.getCodeRangeable(string);
            ByteList bytes = codeRangeable.getByteList();
            try {
                return this.codePoint(EncodingUtils.STR_ENC_GET((ByteListHolder)codeRangeable), bytes.getUnsafeBytes(), bytes.begin(), bytes.begin() + bytes.realSize());
            }
            catch (IllegalArgumentException e) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError(e.getMessage(), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private int codePoint(Encoding encoding, byte[] bytes, int p, int end) {
            return StringSupport.codePoint((Encoding)encoding, (byte[])bytes, (int)p, (int)end);
        }
    }

    @CoreMethod(names={"num_bytes="}, lowerFixnumParameters={0}, required=1)
    public static abstract class SetNumBytesNode
    extends CoreMethodArrayArgumentsNode {
        public SetNumBytesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject setNumBytes(DynamicObject string, int count) {
            StringOperations.getByteList(string).view(0, count);
            return string;
        }
    }

    @CoreMethod(names={"modify!"}, raiseIfFrozenSelf=true)
    public static abstract class ModifyBangNode
    extends CoreMethodArrayArgumentsNode {
        public ModifyBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject modifyBang(DynamicObject string) {
            StringOperations.modify(string);
            return string;
        }
    }

    @CoreMethod(names={"lstrip!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class LstripBangNode
    extends CoreMethodArrayArgumentsNode {
        public LstripBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public Object lstripBangSingleByte(DynamicObject string) {
            int p;
            if (StringOperations.getByteList(string).getRealSize() == 0) {
                return this.nil();
            }
            int s = StringOperations.getByteList(string).getBegin();
            int end = s + StringOperations.getByteList(string).getRealSize();
            byte[] bytes = StringOperations.getByteList(string).getUnsafeBytes();
            for (p = s; p < end && ASCIIEncoding.INSTANCE.isSpace(bytes[p] & 0xFF); ++p) {
            }
            if (p > s) {
                StringOperations.getByteList(string).view(p - s, end - p);
                StringOperations.keepCodeRange(string);
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public Object lstripBang(DynamicObject string) {
            int p;
            int c;
            if (StringOperations.getByteList(string).getRealSize() == 0) {
                return this.nil();
            }
            Encoding enc = EncodingUtils.STR_ENC_GET((ByteListHolder)StringOperations.getCodeRangeable(string));
            int s = StringOperations.getByteList(string).getBegin();
            int end = s + StringOperations.getByteList(string).getRealSize();
            byte[] bytes = StringOperations.getByteList(string).getUnsafeBytes();
            for (p = s; p < end && ASCIIEncoding.INSTANCE.isSpace(c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)p, (int)end)); p += StringSupport.codeLength((Encoding)enc, (int)c)) {
            }
            if (p > s) {
                StringOperations.getByteList(string).view(p - s, end - p);
                StringOperations.keepCodeRange(string);
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"insert"}, required=2, lowerFixnumParameters={0}, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="otherString")})
    public static abstract class InsertNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode concatNode;
        @Node.Child
        private SizeNode sizeNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public InsertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.concatNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.sizeNode = StringNodesFactory.SizeNodeFactory.create(context, sourceSection, new RubyNode[0]);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return ToIntNodeGen.create(this.getContext(), this.getSourceSection(), index);
        }

        @CreateCast(value={"otherString"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isRubyString(otherString)"})
        public Object insert(VirtualFrame frame, DynamicObject string, int index, DynamicObject otherString) {
            if (index == -1) {
                return this.concatNode.call(frame, string, "<<", null, otherString);
            }
            if (index < 0) {
                ++index;
            }
            int stringLength = this.sizeNode.executeInteger(frame, string);
            StringNodesHelper.replaceInternal(string, StringNodesHelper.checkIndex(stringLength, index, this), 0, otherString);
            return this.taintResultNode.maybeTaint(otherString, string);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(from)"})
        public Object initializeCopy(DynamicObject self, DynamicObject from) {
            if (self == from) {
                return self;
            }
            StringOperations.getByteList(self).replace(StringOperations.getByteList(from).bytes());
            StringOperations.getByteList(self).setEncoding(StringOperations.getByteList(from).getEncoding());
            Layouts.STRING.setCodeRange(self, Layouts.STRING.getCodeRange(from));
            return self;
        }
    }

    @CoreMethod(names={"initialize"}, optional=1, taintFromParameter=0)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private ToStrNode toStrNode;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject initialize(DynamicObject self, NotProvided from) {
            return self;
        }

        @Specialization(guards={"isRubyString(from)"})
        public DynamicObject initialize(DynamicObject self, DynamicObject from) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isFrozenNode = this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if (this.isFrozenNode.executeIsFrozen(self)) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().frozenError(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(self)).getName(), this));
            }
            Layouts.STRING.setByteList(self, StringOperations.getByteList(from).dup());
            Layouts.STRING.setCodeRange(self, Layouts.STRING.getCodeRange(from));
            return self;
        }

        @Specialization(guards={"!isRubyString(from)", "wasProvided(from)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject self, Object from) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.initialize(self, this.toStrNode.executeToStr(frame, from));
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(DynamicObject string) {
            return StringOperations.getByteList(string).hashCode();
        }
    }

    @CoreMethod(names={"getbyte"}, required=1, lowerFixnumParameters={0})
    public static abstract class GetByteNode
    extends CoreMethodArrayArgumentsNode {
        public GetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object getByte(DynamicObject string, int index, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile) {
            ByteList bytes = StringOperations.getByteList(string);
            if (negativeIndexProfile.profile(index < 0)) {
                index += bytes.getRealSize();
            }
            if (indexOutOfBoundsProfile.profile(index < 0 || index >= bytes.getRealSize())) {
                return this.nil();
            }
            return bytes.get(index) & 0xFF;
        }
    }

    @CoreMethod(names={"force_encoding"}, required=1, raiseIfFrozenSelf=true)
    public static abstract class ForceEncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        public ForceEncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(encodingName)"})
        public DynamicObject forceEncodingString(DynamicObject string, DynamicObject encodingName, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile) {
            DynamicObject encoding = EncodingNodes.getEncoding(encodingName.toString());
            return this.forceEncodingEncoding(string, encoding, differentEncodingProfile);
        }

        @Specialization(guards={"isRubyEncoding(rubyEncoding)"})
        public DynamicObject forceEncodingEncoding(DynamicObject string, DynamicObject rubyEncoding, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile) {
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            if (differentEncodingProfile.profile(StringOperations.getByteList(string).getEncoding() != encoding)) {
                StringOperations.forceEncoding(string, encoding);
            }
            return string;
        }

        @Specialization(guards={"!isRubyString(encoding)", "!isRubyEncoding(encoding)"})
        public DynamicObject forceEncoding(VirtualFrame frame, DynamicObject string, Object encoding, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.forceEncodingString(string, this.toStrNode.executeToStr(frame, encoding), differentEncodingProfile);
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodArrayArgumentsNode {
        public EncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject encoding(DynamicObject string) {
            return EncodingNodes.getEncoding(StringOperations.getByteList(string).getEncoding());
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean empty(DynamicObject string) {
            return StringOperations.getByteList(string).length() == 0;
        }
    }

    @CoreMethod(names={"each_char"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class EachCharNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public EachCharNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isValidOr7BitEncoding(string)"})
        public DynamicObject eachChar(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            int n;
            ByteList strByteList = StringOperations.getByteList(string);
            byte[] ptrBytes = strByteList.unsafeBytes();
            int ptr = strByteList.begin();
            int len = strByteList.getRealSize();
            Encoding enc = StringOperations.getByteList(string).getEncoding();
            for (int i = 0; i < len; i += n) {
                n = StringSupport.encFastMBCLen((byte[])ptrBytes, (int)(ptr + i), (int)(ptr + len), (Encoding)enc);
                this.yield(frame, block, this.substr(string, i, n));
            }
            return string;
        }

        @Specialization(guards={"!isValidOr7BitEncoding(string)"})
        public DynamicObject eachCharMultiByteEncoding(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            int n;
            ByteList strByteList = StringOperations.getByteList(string);
            byte[] ptrBytes = strByteList.unsafeBytes();
            int ptr = strByteList.begin();
            int len = strByteList.getRealSize();
            Encoding enc = StringOperations.getByteList(string).getEncoding();
            for (int i = 0; i < len; i += n) {
                n = this.multiByteStringLength(enc, ptrBytes, ptr + i, ptr + len);
                this.yield(frame, block, this.substr(string, i, n));
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private int multiByteStringLength(Encoding enc, byte[] bytes, int p, int end) {
            return StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
        }

        private Object substr(DynamicObject string, int beg, int len) {
            ByteList bytes = StringOperations.getByteList(string);
            int length = bytes.length();
            if (len < 0 || beg > length) {
                return this.nil();
            }
            if (beg < 0 && (beg += length) < 0) {
                return this.nil();
            }
            int end = Math.min(length, beg + len);
            ByteList substringBytes = new ByteList(bytes, beg, end - beg);
            substringBytes.setEncoding(bytes.getEncoding());
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            DynamicObject ret = Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(string)), substringBytes, 0, null);
            return this.taintResultNode.maybeTaint(string, ret);
        }
    }

    @CoreMethod(names={"each_byte"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachByteNode
    extends YieldingCoreMethodNode {
        public EachByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject eachByte(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            ByteList bytes = StringOperations.getByteList(string);
            for (int i = 0; i < bytes.getRealSize(); ++i) {
                this.yield(frame, block, bytes.get(i) & 0xFF);
            }
            return string;
        }
    }

    @CoreMethod(names={"downcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DowncaseBangNode
    extends CoreMethodArrayArgumentsNode {
        public DowncaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public DynamicObject downcaseSingleByte(DynamicObject string) {
            StringCodeRangeableWrapper codeRangeable = StringOperations.getCodeRangeable(string);
            ByteList bytes = codeRangeable.getByteList();
            if (bytes.realSize() == 0) {
                return this.nil();
            }
            codeRangeable.modifyAndKeepCodeRange();
            boolean modified = this.singleByteDowncase(bytes.unsafeBytes(), bytes.begin(), bytes.realSize());
            if (modified) {
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public DynamicObject downcase(DynamicObject string) {
            StringCodeRangeableWrapper codeRangeable = StringOperations.getCodeRangeable(string);
            ByteList bytes = codeRangeable.getByteList();
            Encoding encoding = bytes.getEncoding();
            if (encoding.isDummy()) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", encoding), this));
            }
            if (bytes.realSize() == 0) {
                return this.nil();
            }
            codeRangeable.modifyAndKeepCodeRange();
            try {
                boolean modified = this.multiByteDowncase(encoding, bytes.unsafeBytes(), bytes.begin(), bytes.realSize());
                if (modified) {
                    return string;
                }
                return this.nil();
            }
            catch (IllegalArgumentException e) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError(e.getMessage(), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean singleByteDowncase(byte[] bytes, int s, int end) {
            return StringSupport.singleByteDowncase((byte[])bytes, (int)s, (int)end);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean multiByteDowncase(Encoding encoding, byte[] bytes, int s, int end) {
            return StringSupport.multiByteDowncase((Encoding)encoding, (byte[])bytes, (int)s, (int)end);
        }
    }

    @CoreMethod(names={"delete!"}, rest=true, raiseIfFrozenSelf=true)
    public static abstract class DeleteBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStr;

        public DeleteBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toStr = ToStrNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public Object deleteBang(VirtualFrame frame, DynamicObject string, Object ... args) {
            if (StringOperations.getByteList(string).length() == 0) {
                return this.nil();
            }
            if (args.length == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentErrorEmptyVarargs(this));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeToStr(frame, args[i]);
            }
            return this.deleteBangSlow(string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private Object deleteBangSlow(DynamicObject string, DynamicObject ... otherStrings) {
            assert (RubyGuards.isRubyString(string));
            DynamicObject otherString = otherStrings[0];
            Encoding enc = StringOperations.checkEncoding(this.getContext(), string, StringOperations.getCodeRangeable(otherString), this);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteList(otherString), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, null, (boolean)true, (Encoding)enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                assert (RubyGuards.isRubyString(otherStrings[i]));
                enc = StringOperations.checkEncoding(this.getContext(), string, StringOperations.getCodeRangeable(otherStrings[i]), this);
                tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteList(otherStrings[i]), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            if (StringSupport.delete_bangCommon19((CodeRangeable)StringOperations.getCodeRangeable(string), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc) == null) {
                return this.nil();
            }
            return string;
        }
    }

    @CoreMethod(names={"data"})
    public static abstract class DataNode
    extends CoreMethodArrayArgumentsNode {
        public DataNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject data(DynamicObject string) {
            return ByteArrayNodes.createByteArray(this.getContext().getCoreLibrary().getByteArrayFactory(), StringOperations.getByteList(string));
        }
    }

    @CoreMethod(names={"crypt"}, required=1, taintFromSelf=true, taintFromParameter=0)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="salt")})
    public static abstract class CryptNode
    extends CoreMethodNode {
        public CryptNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"salt"})
        public RubyNode coerceSaltToString(RubyNode other) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isRubyString(salt)"})
        public Object crypt(DynamicObject string, DynamicObject salt) {
            ByteList value = StringOperations.getByteList(string);
            Encoding ascii8bit = this.getContext().getRuntime().getEncodingService().getAscii8bitEncoding();
            ByteList otherBL = StringOperations.getByteList(salt).dup();
            DynamicObject otherStr = this.createString(otherBL);
            StringOperations.modify(otherStr);
            StringSupport.associateEncoding((CodeRangeable)StringOperations.getCodeRangeable(otherStr), (Encoding)ascii8bit);
            if (otherBL.length() < 2) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("salt too short (need >= 2 bytes)", this));
            }
            POSIX posix = this.posix();
            byte[] keyBytes = Arrays.copyOfRange(value.unsafeBytes(), value.begin(), value.realSize());
            byte[] saltBytes = Arrays.copyOfRange(otherBL.unsafeBytes(), otherBL.begin(), otherBL.realSize());
            if (saltBytes[0] == 0 || saltBytes[1] == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("salt too short (need >= 2 bytes)", this));
            }
            byte[] cryptedString = posix.crypt(keyBytes, saltBytes);
            if (cryptedString == null) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().errnoError(posix.errno(), this));
            }
            DynamicObject result = this.createString(new ByteList(cryptedString, 0, cryptedString.length - 1));
            StringSupport.associateEncoding((CodeRangeable)StringOperations.getCodeRangeable(result), (Encoding)ascii8bit);
            return result;
        }
    }

    @CoreMethod(names={"count"}, rest=true)
    public static abstract class CountNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStr;

        public CountNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toStr = ToStrNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public int count(VirtualFrame frame, DynamicObject string, Object[] args) {
            if (StringOperations.getByteList(string).getRealSize() == 0) {
                return 0;
            }
            if (args.length == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentErrorEmptyVarargs(this));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeToStr(frame, args[i]);
            }
            return this.countSlow(string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private int countSlow(DynamicObject string, DynamicObject ... otherStrings) {
            assert (RubyGuards.isRubyString(string));
            DynamicObject otherStr = otherStrings[0];
            Encoding enc = StringOperations.getByteList(otherStr).getEncoding();
            boolean[] table = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteList(otherStr), (Ruby)this.getContext().getRuntime(), (boolean[])table, null, (boolean)true, (Encoding)enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                assert (RubyGuards.isRubyString(otherStr));
                enc = StringOperations.checkEncoding(this.getContext(), string, StringOperations.getCodeRangeable(otherStr), this);
                tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteList(otherStr), (Ruby)this.getContext().getRuntime(), (boolean[])table, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            return StringSupport.countCommon19((ByteList)StringOperations.getByteList(string), (Ruby)this.getContext().getRuntime(), (boolean[])table, (StringSupport.TrTables)tables, (Encoding)enc);
        }
    }

    @CoreMethod(names={"chop!"}, raiseIfFrozenSelf=true)
    public static abstract class ChopBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SizeNode sizeNode;

        public ChopBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.sizeNode = StringNodesFactory.SizeNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        @Specialization
        public Object chopBang(VirtualFrame frame, DynamicObject string) {
            if (this.sizeNode.executeInteger(frame, string) == 0) {
                return this.nil();
            }
            int newLength = this.choppedLength(string);
            StringOperations.getByteList(string).view(0, newLength);
            if (Layouts.STRING.getCodeRange(string) != 16) {
                StringOperations.clearCodeRange(string);
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private int choppedLength(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringSupport.choppedLength19((CodeRangeable)StringOperations.getCodeRangeable(string), (Ruby)this.getContext().getRuntime());
        }
    }

    @CoreMethod(names={"casecmp"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class CaseCmpNode
    extends CoreMethodNode {
        public CaseCmpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isRubyString(other)", "bothSingleByteOptimizable(string, other)"})
        public Object caseCmpSingleByte(DynamicObject string, DynamicObject other) {
            if (StringSupport.areCompatible((CodeRangeable)StringOperations.getCodeRangeable(string), (CodeRangeable)StringOperations.getCodeRangeable(other)) == null) {
                return this.nil();
            }
            return StringOperations.getByteList(string).caseInsensitiveCmp(StringOperations.getByteList(other));
        }

        @Specialization(guards={"isRubyString(other)", "!bothSingleByteOptimizable(string, other)"})
        public Object caseCmp(DynamicObject string, DynamicObject other) {
            Encoding encoding = StringSupport.areCompatible((CodeRangeable)StringOperations.getCodeRangeable(string), (CodeRangeable)StringOperations.getCodeRangeable(other));
            if (encoding == null) {
                return this.nil();
            }
            return this.multiByteCasecmp(encoding, StringOperations.getByteList(string), StringOperations.getByteList(other));
        }

        @CompilerDirectives.TruffleBoundary
        private int multiByteCasecmp(Encoding enc, ByteList value, ByteList otherValue) {
            return StringSupport.multiByteCasecmp((Encoding)enc, (ByteList)value, (ByteList)otherValue);
        }

        public static boolean bothSingleByteOptimizable(DynamicObject string, DynamicObject other) {
            assert (RubyGuards.isRubyString(string));
            assert (RubyGuards.isRubyString(other));
            boolean stringSingleByteOptimizable = StringSupport.isSingleByteOptimizable((CodeRangeable)StringOperations.getCodeRangeable(string), (Encoding)StringOperations.getByteList(string).getEncoding());
            boolean otherSingleByteOptimizable = StringSupport.isSingleByteOptimizable((CodeRangeable)StringOperations.getCodeRangeable(other), (Encoding)StringOperations.getByteList(other).getEncoding());
            return stringSingleByteOptimizable && otherSingleByteOptimizable;
        }
    }

    @CoreMethod(names={"bytesize"})
    public static abstract class ByteSizeNode
    extends CoreMethodArrayArgumentsNode {
        public ByteSizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int byteSize(DynamicObject string) {
            return StringOperations.getByteList(string).length();
        }
    }

    @CoreMethod(names={"bytes"})
    public static abstract class BytesNode
    extends CoreMethodArrayArgumentsNode {
        public BytesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject bytes(VirtualFrame frame, DynamicObject string) {
            ByteList byteList = StringOperations.getByteList(string);
            byte[] bytes = byteList.unsafeBytes();
            int[] store = new int[byteList.realSize()];
            for (int n = 0; n < store.length; ++n) {
                store[n] = bytes[n + byteList.begin()] & 0xFF;
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), store, store.length);
        }
    }

    @CoreMethod(names={"b"}, taintFromSelf=true)
    public static abstract class BNode
    extends CoreMethodArrayArgumentsNode {
        public BNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject b(DynamicObject string) {
            ByteList bytes = StringOperations.getByteList(string).dup();
            bytes.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            return this.createString(bytes);
        }
    }

    @CoreMethod(names={"ascii_only?"})
    public static abstract class ASCIIOnlyNode
    extends CoreMethodArrayArgumentsNode {
        public ASCIIOnlyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean asciiOnly(DynamicObject string) {
            ByteList byteList = StringOperations.getByteList(string);
            if (!byteList.getEncoding().isAsciiCompatible()) {
                return false;
            }
            for (int i = 0; i < byteList.length(); ++i) {
                if ((byteList.get(i) & 0x80) == 0) continue;
                return false;
            }
            return true;
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnumParameters={0, 1}, taintFromSelf=true)
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private CallDispatchHeadNode includeNode;
        @Node.Child
        private CallDispatchHeadNode dupNode;
        @Node.Child
        private SizeNode sizeNode;
        @Node.Child
        private StringPrimitiveNodes.StringSubstringPrimitiveNode substringNode;
        private final BranchProfile outOfBounds = BranchProfile.create();

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object getIndex(VirtualFrame frame, DynamicObject string, int index, Object length) {
            int stringLength = this.getSizeNode().executeInteger(frame, string);
            int normalizedIndex = StringOperations.normalizeIndex(stringLength, index);
            ByteList bytes = StringOperations.getByteList(string);
            if (normalizedIndex < 0 || normalizedIndex >= bytes.length()) {
                this.outOfBounds.enter();
                return this.nil();
            }
            return this.getSubstringNode().execute(frame, string, index, 1);
        }

        @Specialization(guards={"!isRubyRange(index)", "!isRubyRegexp(index)", "!isRubyString(index)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object getIndex(VirtualFrame frame, DynamicObject string, Object index, Object length) {
            return this.getIndex(frame, string, this.getToIntNode().doInt(frame, index), length);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceIntegerRange(VirtualFrame frame, DynamicObject string, DynamicObject range, Object length) {
            return this.sliceRange(frame, string, Layouts.INTEGER_FIXNUM_RANGE.getBegin(range), Layouts.INTEGER_FIXNUM_RANGE.getEnd(range), Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range));
        }

        @Specialization(guards={"isLongFixnumRange(range)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceLongRange(VirtualFrame frame, DynamicObject string, DynamicObject range, Object length) {
            return this.sliceRange(frame, string, (int)Layouts.LONG_FIXNUM_RANGE.getBegin(range), (int)Layouts.LONG_FIXNUM_RANGE.getEnd(range), Layouts.LONG_FIXNUM_RANGE.getExcludedEnd(range));
        }

        @Specialization(guards={"isObjectRange(range)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceObjectRange(VirtualFrame frame, DynamicObject string, DynamicObject range, Object length) {
            int coercedBegin = this.getToIntNode().doInt(frame, Layouts.OBJECT_RANGE.getBegin(range));
            int coercedEnd = this.getToIntNode().doInt(frame, Layouts.OBJECT_RANGE.getEnd(range));
            return this.sliceRange(frame, string, coercedBegin, coercedEnd, Layouts.OBJECT_RANGE.getExcludedEnd(range));
        }

        private Object sliceRange(VirtualFrame frame, DynamicObject string, int begin, int end, boolean doesExcludeEnd) {
            assert (RubyGuards.isRubyString(string));
            int stringLength = this.getSizeNode().executeInteger(frame, string);
            begin = StringOperations.normalizeIndex(stringLength, begin);
            if (begin < 0 || begin > stringLength) {
                this.outOfBounds.enter();
                return this.nil();
            }
            if (begin == stringLength) {
                ByteList byteList = new ByteList();
                byteList.setEncoding(StringOperations.getByteList(string).getEncoding());
                return Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(string)), byteList, 0, null);
            }
            end = StringOperations.normalizeIndex(stringLength, end);
            int length = StringOperations.clampExclusiveIndex(string, doesExcludeEnd ? end : end + 1);
            if (length > stringLength) {
                length = stringLength;
            }
            if ((length -= begin) < 0) {
                length = 0;
            }
            return this.getSubstringNode().execute(frame, string, begin, length);
        }

        @Specialization
        public Object slice(VirtualFrame frame, DynamicObject string, int start, int length) {
            return this.getSubstringNode().execute(frame, string, start, length);
        }

        @Specialization(guards={"wasProvided(length)"})
        public Object slice(VirtualFrame frame, DynamicObject string, int start, Object length) {
            return this.slice(frame, string, start, this.getToIntNode().doInt(frame, length));
        }

        @Specialization(guards={"!isRubyRange(start)", "!isRubyRegexp(start)", "!isRubyString(start)", "wasProvided(length)"})
        public Object slice(VirtualFrame frame, DynamicObject string, Object start, Object length) {
            return this.slice(frame, string, this.getToIntNode().doInt(frame, start), this.getToIntNode().doInt(frame, length));
        }

        @Specialization(guards={"isRubyRegexp(regexp)", "wasNotProvided(capture) || isRubiniusUndefined(capture)"})
        public Object slice1(VirtualFrame frame, DynamicObject string, DynamicObject regexp, Object capture) {
            return this.sliceCapture(frame, string, regexp, 0);
        }

        @Specialization(guards={"isRubyRegexp(regexp)", "wasProvided(capture)"})
        public Object sliceCapture(VirtualFrame frame, DynamicObject string, DynamicObject regexp, Object capture) {
            return this.ruby(frame, "match, str = subpattern(index, other); Regexp.last_match = match; str", "index", regexp, "other", capture);
        }

        @Specialization(guards={"wasNotProvided(length) || isRubiniusUndefined(length)", "isRubyString(matchStr)"})
        public Object slice2(VirtualFrame frame, DynamicObject string, DynamicObject matchStr, Object length) {
            boolean result;
            if (this.includeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.includeNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (result = this.includeNode.callBoolean(frame, string, "include?", null, matchStr)) {
                if (this.dupNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.dupNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                throw new TaintResultNode.DoNotTaint(this.dupNode.call(frame, matchStr, "dup", null, new Object[0]));
            }
            return this.nil();
        }

        private ToIntNode getToIntNode() {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.toIntNode;
        }

        private StringPrimitiveNodes.StringSubstringPrimitiveNode getSubstringNode() {
            if (this.substringNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.substringNode = this.insert(StringPrimitiveNodesFactory.StringSubstringPrimitiveNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            return this.substringNode;
        }

        @Override
        protected boolean isRubiniusUndefined(Object object) {
            return object == this.getContext().getCoreLibrary().getRubiniusUndefined();
        }

        private SizeNode getSizeNode() {
            if (this.sizeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.sizeNode = this.insert(StringNodesFactory.SizeNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
            }
            return this.sizeNode;
        }
    }

    @CoreMethod(names={"<<", "concat"}, required=1, taintFromParameter=0, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ConcatNode
    extends CoreMethodNode {
        public ConcatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject concat(DynamicObject string, int other) {
            if (other < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(other));
            }
            return this.concatNumeric(string, other);
        }

        @Specialization
        public DynamicObject concat(DynamicObject string, long other) {
            if (other < 0L) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(other));
            }
            return this.concatNumeric(string, (int)other);
        }

        @Specialization(guards={"isRubyBignum(other)"})
        public DynamicObject concatBignum(DynamicObject string, DynamicObject other) {
            if (Layouts.BIGNUM.getValue(other).signum() < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError("bignum out of char range", (Node)this));
            }
            return this.concatNumeric(string, Layouts.BIGNUM.getValue(other).intValue());
        }

        @Specialization(guards={"isRubyString(other)", "is7Bit(string)", "is7Bit(other)"})
        public DynamicObject concatStringSingleByte(DynamicObject string, DynamicObject other) {
            ByteList stringByteList = StringOperations.getByteList(string);
            ByteList otherByteList = StringOperations.getByteList(other);
            stringByteList.append(otherByteList);
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(other)", "!is7Bit(string) || !is7Bit(other)"})
        public DynamicObject concatString(DynamicObject string, DynamicObject other) {
            int codeRange = Layouts.STRING.getCodeRange(other);
            int[] ptr_cr_ret = new int[]{codeRange};
            try {
                EncodingUtils.encCrStrBufCat((Ruby)this.getContext().getRuntime(), (CodeRangeable)StringOperations.getCodeRangeable(string), (ByteList)StringOperations.getByteList(other), (Encoding)StringOperations.getByteList(other).getEncoding(), (int)codeRange, (int[])ptr_cr_ret);
            }
            catch (RaiseException e) {
                if (e.getException().getMetaClass() == this.getContext().getRuntime().getEncodingCompatibilityError()) {
                    CompilerDirectives.transferToInterpreter();
                    throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityError(e.getException().message.asJavaString(), this));
                }
                throw e;
            }
            Layouts.STRING.setCodeRange(other, ptr_cr_ret[0]);
            return string;
        }

        @Specialization(guards={"!isInteger(other)", "!isLong(other)", "!isRubyBignum(other)", "!isRubyString(other)"})
        public Object concat(VirtualFrame frame, DynamicObject string, Object other) {
            return this.ruby(frame, "concat StringValue(other)", "other", other);
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject concatNumeric(DynamicObject string, int c) {
            int cl;
            ByteList value = StringOperations.getByteList(string);
            Encoding enc = value.getEncoding();
            try {
                cl = StringSupport.codeLength((Encoding)enc, (int)c);
                StringOperations.modify(string, value.getRealSize() + cl);
                StringOperations.clearCodeRange(string);
                if (enc == USASCIIEncoding.INSTANCE) {
                    if (c > 255) {
                        CompilerDirectives.transferToInterpreter();
                        throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(c));
                    }
                    if (c > 121) {
                        value.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
                        enc = value.getEncoding();
                    }
                }
                enc.codeToMbc(c, value.getUnsafeBytes(), value.getBegin() + value.getRealSize());
            }
            catch (EncodingException e) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(c));
            }
            value.setRealSize(value.getRealSize() + cl);
            return string;
        }

        private DynamicObject charRangeException(Number value) {
            return this.getContext().getCoreLibrary().rangeError(String.format("%d out of char range", value), (Node)this);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode cmpNode;
        @Node.Child
        private CmpIntNode cmpIntNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToCmpNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToToStrNode;
        @Node.Child
        private ToStrNode toStrNode;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(b)"})
        public int compare(DynamicObject a, DynamicObject b) {
            int ret = StringOperations.getByteList(a).cmp(StringOperations.getByteList(b));
            if (ret == 0 && !StringSupport.areComparable((CodeRangeable)StringOperations.getCodeRangeable(a), (CodeRangeable)StringOperations.getCodeRangeable(b))) {
                return StringOperations.getByteList(a).getEncoding().getIndex() > StringOperations.getByteList(b).getEncoding().getIndex() ? 1 : -1;
            }
            return ret;
        }

        @Specialization(guards={"!isRubyString(b)"})
        public Object compare(VirtualFrame frame, DynamicObject a, Object b) {
            CompilerDirectives.transferToInterpreter();
            if (this.respondToToStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToStrNode = this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToToStrNode.doesRespondToString(frame, b, this.create7BitString(StringOperations.encodeByteList("to_str", (Encoding)UTF8Encoding.INSTANCE)), false)) {
                if (this.toStrNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
                }
                try {
                    DynamicObject coerced = this.toStrNode.executeToStr(frame, b);
                    return this.compare(a, coerced);
                }
                catch (org.jruby.truffle.runtime.control.RaiseException e) {
                    if (Layouts.BASIC_OBJECT.getLogicalClass(e.getRubyException()) == this.getContext().getCoreLibrary().getTypeErrorClass()) {
                        return this.nil();
                    }
                    throw e;
                }
            }
            if (this.respondToCmpNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToCmpNode = this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToCmpNode.doesRespondToString(frame, b, this.create7BitString(StringOperations.encodeByteList("<=>", (Encoding)UTF8Encoding.INSTANCE)), false)) {
                Object cmpResult;
                if (this.cmpNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.cmpNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                if ((cmpResult = this.cmpNode.call(frame, b, "<=>", null, a)) == this.nil()) {
                    return this.nil();
                }
                if (this.cmpIntNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.cmpIntNode = this.insert(CmpIntNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                return -this.cmpIntNode.executeCmpInt(frame, cmpResult, a, b);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"==", "===", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private StringPrimitiveNodes.StringEqualPrimitiveNode stringEqualNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToNode;
        @Node.Child
        private CallDispatchHeadNode objectEqualNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.stringEqualNode = StringPrimitiveNodesFactory.StringEqualPrimitiveNodeFactory.create(context, sourceSection, new RubyNode[0]);
        }

        @Specialization(guards={"isRubyString(b)"})
        public boolean equal(DynamicObject a, DynamicObject b) {
            return this.stringEqualNode.executeStringEqual(a, b);
        }

        @Specialization(guards={"!isRubyString(b)"})
        public boolean equal(VirtualFrame frame, DynamicObject a, Object b) {
            if (this.respondToNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToNode = this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToNode.doesRespondToString(frame, b, this.create7BitString(StringOperations.encodeByteList("to_str", (Encoding)UTF8Encoding.INSTANCE)), false)) {
                if (this.objectEqualNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.objectEqualNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                return this.objectEqualNode.callBoolean(frame, b, "==", null, a);
            }
            return false;
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnumParameters={0}, taintFromSelf=true)
    public static abstract class MulNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject multiply(DynamicObject string, int times) {
            if (times < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            ByteList inputBytes = StringOperations.getByteList(string);
            ByteList outputBytes = new ByteList(StringOperations.getByteList(string).length() * times);
            for (int n = 0; n < times; ++n) {
                outputBytes.append(inputBytes);
            }
            outputBytes.setEncoding(inputBytes.getEncoding());
            DynamicObject ret = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), outputBytes, Layouts.STRING.getCodeRange(string), null);
            return ret;
        }

        @Specialization(guards={"isRubyBignum(times)"})
        public DynamicObject multiply(DynamicObject string, DynamicObject times) {
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError("bignum too big to convert into `long'", (Node)this));
        }

        @Specialization(guards={"!isRubyBignum(times)", "!isInteger(times)"})
        public DynamicObject multiply(VirtualFrame frame, DynamicObject string, Object times) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.multiply(string, this.toIntNode.doInt(frame, times));
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class AddNode
    extends CoreMethodNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isRubyString(other)"})
        public DynamicObject add(DynamicObject string, DynamicObject other) {
            Encoding enc = StringOperations.checkEncoding(this.getContext(), string, StringOperations.getCodeRangeable(other), this);
            int codeRange = StringOperations.commonCodeRange(Layouts.STRING.getCodeRange(string), Layouts.STRING.getCodeRange(other));
            DynamicObject ret = Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), StringSupport.addByteLists((ByteList)StringOperations.getByteList(string), (ByteList)StringOperations.getByteList(other)), codeRange, null);
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            StringOperations.getByteList(ret).setEncoding(enc);
            this.taintResultNode.maybeTaint(string, ret);
            this.taintResultNode.maybeTaint(other, ret);
            return ret;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, new ByteList(), 0, null);
        }
    }
}

