/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceNormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceNormalizedNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class), @NodeChild(value="length", type=RubyNode.class)})
public abstract class ArrayReadSliceDenormalizedNode
extends RubyNode {
    @Node.Child
    private ArrayReadSliceNormalizedNode readNode = ArrayReadSliceNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null);

    public ArrayReadSliceDenormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract DynamicObject executeReadSlice(DynamicObject var1, int var2, int var3);

    @Specialization(guards={"isRubyArray(array)"})
    public DynamicObject read(DynamicObject array, int index, int length, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile) {
        int normalizedIndex = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), index, negativeIndexProfile);
        return this.readNode.executeReadSlice(array, normalizedIndex, length);
    }
}

