/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.GeneralizeArrayNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=GeneralizeArrayNode.class)
public final class GeneralizeArrayNodeGen
extends GeneralizeArrayNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode requiredCapacity_;
    @CompilerDirectives.CompilationFinal
    private Class<?> requiredCapacityType_;
    @Node.Child
    private BaseNode_ specialization_;

    private GeneralizeArrayNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        super(context, sourceSection);
        this.array_ = array;
        this.requiredCapacity_ = requiredCapacity;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeGeneralize(DynamicObject arrayValue, int requiredCapacityValue) {
        return this.specialization_.execute1(arrayValue, requiredCapacityValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
        return this.specialization_.executeDynamicObject(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static GeneralizeArrayNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        return new GeneralizeArrayNodeGen(context, sourceSection, array, requiredCapacity);
    }

    @GeneratedBy(methodName="generalizeDouble(DynamicObject, int)", value=GeneralizeArrayNode.class)
    private static final class GeneralizeDoubleNode_
    extends BaseNode_ {
        GeneralizeDoubleNode_(GeneralizeArrayNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeDynamicObject(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), requiredCapacityValue);
            }
            try {
                requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.generalizeDouble(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return this.root.generalizeDouble(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && requiredCapacityValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = (Integer)requiredCapacityValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.generalizeDouble(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(GeneralizeArrayNodeGen root) {
            return new GeneralizeDoubleNode_(root);
        }
    }

    @GeneratedBy(methodName="generalizeLong(DynamicObject, int)", value=GeneralizeArrayNode.class)
    private static final class GeneralizeLongNode_
    extends BaseNode_ {
        GeneralizeLongNode_(GeneralizeArrayNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeDynamicObject(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), requiredCapacityValue);
            }
            try {
                requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.generalizeLong(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isLongArray(arrayValue)) {
                return this.root.generalizeLong(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && requiredCapacityValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = (Integer)requiredCapacityValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.generalizeLong(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(GeneralizeArrayNodeGen root) {
            return new GeneralizeLongNode_(root);
        }
    }

    @GeneratedBy(methodName="generalizeInt(DynamicObject, int)", value=GeneralizeArrayNode.class)
    private static final class GeneralizeIntNode_
    extends BaseNode_ {
        GeneralizeIntNode_(GeneralizeArrayNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeDynamicObject(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), requiredCapacityValue);
            }
            try {
                requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.generalizeInt(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isIntArray(arrayValue)) {
                return this.root.generalizeInt(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && requiredCapacityValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = (Integer)requiredCapacityValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.generalizeInt(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(GeneralizeArrayNodeGen root) {
            return new GeneralizeIntNode_(root);
        }
    }

    @GeneratedBy(methodName="generalizeNull(DynamicObject, int)", value=GeneralizeArrayNode.class)
    private static final class GeneralizeNullNode_
    extends BaseNode_ {
        GeneralizeNullNode_(GeneralizeArrayNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeDynamicObject(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), requiredCapacityValue);
            }
            try {
                requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_)) {
                return this.root.generalizeNull(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isNullArray(arrayValue)) {
                return this.root.generalizeNull(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && requiredCapacityValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = (Integer)requiredCapacityValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_)) {
                    return this.root.generalizeNull(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(GeneralizeArrayNodeGen root) {
            return new GeneralizeNullNode_(root);
        }
    }

    @GeneratedBy(value=GeneralizeArrayNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(GeneralizeArrayNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, requiredCapacityValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            return this.getNext().executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(GeneralizeArrayNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=GeneralizeArrayNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(GeneralizeArrayNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            return (DynamicObject)this.uninitialized((Frame)null, arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(GeneralizeArrayNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=GeneralizeArrayNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final GeneralizeArrayNodeGen root;

        BaseNode_(GeneralizeArrayNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.requiredCapacity_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        public abstract DynamicObject executeDynamicObject_(Object var1, Object var2);

        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            return this.executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object requiredCapacityValue_ = this.executeRequiredCapacity_(frameValue);
            return this.executeDynamicObject_(arrayValue_, requiredCapacityValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            return (DynamicObject)this.execute0(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && requiredCapacityValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_)) {
                    return GeneralizeNullNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                    return GeneralizeIntNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return GeneralizeLongNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return GeneralizeDoubleNode_.create(this.root);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeRequiredCapacity_(Frame frameValue) {
            Object object;
            Class requiredCapacityType_ = this.root.requiredCapacityType_;
            if (requiredCapacityType_ == Integer.TYPE) {
                return this.root.requiredCapacity_.executeInteger((VirtualFrame)frameValue);
            }
            if (requiredCapacityType_ != null) return this.root.requiredCapacity_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.requiredCapacity_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.requiredCapacityType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.requiredCapacityType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.requiredCapacityType_ = _type;
            return object;
        }
    }
}

