/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ClassNodes;
import org.jruby.truffle.nodes.objects.FreezeNode;
import org.jruby.truffle.nodes.objects.FreezeNodeGen;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.object.ObjectIDOperations;

@NodeChild(value="value", type=RubyNode.class)
public abstract class SingletonClassNode
extends RubyNode {
    @Node.Child
    IsFrozenNode isFrozenNode;
    @Node.Child
    FreezeNode freezeNode;

    public SingletonClassNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract DynamicObject executeSingletonClass(Object var1);

    @Specialization(guards={"value"})
    protected DynamicObject singletonClassTrue(boolean value) {
        return this.getContext().getCoreLibrary().getTrueClass();
    }

    @Specialization(guards={"!value"})
    protected DynamicObject singletonClassFalse(boolean value) {
        return this.getContext().getCoreLibrary().getFalseClass();
    }

    @Specialization(guards={"isNil(value)"})
    protected DynamicObject singletonClassNil(DynamicObject value) {
        return this.getContext().getCoreLibrary().getNilClass();
    }

    @Specialization
    protected DynamicObject singletonClass(int value) {
        return this.noSingletonClass();
    }

    @Specialization
    protected DynamicObject singletonClass(long value) {
        return this.noSingletonClass();
    }

    @Specialization
    protected DynamicObject singletonClass(double value) {
        return this.noSingletonClass();
    }

    @Specialization(guards={"isRubyBignum(value)"})
    protected DynamicObject singletonClassBignum(DynamicObject value) {
        return this.noSingletonClass();
    }

    @Specialization(guards={"isRubySymbol(value)"})
    protected DynamicObject singletonClassSymbol(DynamicObject value) {
        return this.noSingletonClass();
    }

    @Specialization(guards={"isRubyClass(rubyClass)"})
    protected DynamicObject singletonClassClass(DynamicObject rubyClass) {
        return ClassNodes.getSingletonClass(this.getContext(), rubyClass);
    }

    @Specialization(guards={"!isNil(object)", "!isRubyBignum(object)", "!isRubySymbol(object)", "!isRubyClass(object)"})
    protected DynamicObject singletonClass(DynamicObject object) {
        return this.getNormalObjectSingletonClass(object);
    }

    public DynamicObject getNormalObjectSingletonClass(DynamicObject object) {
        CompilerAsserts.neverPartOfCompilation();
        if (RubyGuards.isRubyClass(object)) {
            return ClassNodes.getSingletonClass(this.getContext(), object);
        }
        if (Layouts.CLASS.getIsSingleton(Layouts.BASIC_OBJECT.getMetaClass(object))) {
            return Layouts.BASIC_OBJECT.getMetaClass(object);
        }
        CompilerDirectives.transferToInterpreter();
        DynamicObject logicalClass = Layouts.BASIC_OBJECT.getLogicalClass(object);
        DynamicObject attached = null;
        if (RubyGuards.isRubyModule(object)) {
            attached = object;
        }
        String name = String.format("#<Class:#<%s:0x%x>>", Layouts.MODULE.getFields(logicalClass).getName(), ObjectIDOperations.verySlowGetObjectID(this.getContext(), object));
        DynamicObject singletonClass = ClassNodes.createSingletonClassOfObject(this.getContext(), logicalClass, attached, name);
        this.propagateFrozen(object, singletonClass);
        Layouts.BASIC_OBJECT.setMetaClass(object, singletonClass);
        return singletonClass;
    }

    private void propagateFrozen(Object object, DynamicObject singletonClass) {
        assert (RubyGuards.isRubyClass(singletonClass));
        if (this.isFrozenNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isFrozenNode = this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
            this.freezeNode = this.insert(FreezeNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        if (this.isFrozenNode.executeIsFrozen(object)) {
            this.freezeNode.executeFreeze(singletonClass);
        }
    }

    private DynamicObject noSingletonClass() {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantDefineSingleton(this));
    }
}

