/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.time;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joda.time.DateTimeZone;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.constants.ReadLiteralConstantNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.util.ByteList;

public class ReadTimeZoneNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode hashNode;
    @Node.Child
    private ReadLiteralConstantNode envNode;
    private final ConditionProfile tzNilProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile tzStringProfile = ConditionProfile.createBinaryProfile();
    private static final ByteList defaultZone = StringOperations.encodeByteList(DateTimeZone.getDefault().toString(), (Encoding)UTF8Encoding.INSTANCE);
    private final DynamicObject TZ;

    public ReadTimeZoneNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.envNode = new ReadLiteralConstantNode(context, sourceSection, new LiteralNode(context, sourceSection, this.getContext().getCoreLibrary().getObjectClass()), "ENV");
        this.TZ = this.create7BitString(StringOperations.encodeByteList("TZ", (Encoding)UTF8Encoding.INSTANCE));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object tz = this.hashNode.call(frame, this.envNode.execute(frame), "[]", null, this.TZ);
        if (this.tzNilProfile.profile(tz == this.nil())) {
            return this.createString(defaultZone.dup());
        }
        if (this.tzStringProfile.profile(RubyGuards.isRubyString(tz))) {
            return tz;
        }
        throw new UnsupportedOperationException();
    }
}

