/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.ModuleChain;

public class IncludedModule
implements ModuleChain {
    private final DynamicObject includedModule;
    @CompilerDirectives.CompilationFinal
    private ModuleChain parentModule;

    public IncludedModule(DynamicObject includedModule, ModuleChain parentModule) {
        assert (RubyGuards.isRubyModule(includedModule));
        this.includedModule = includedModule;
        this.parentModule = parentModule;
    }

    @Override
    public ModuleChain getParentModule() {
        return this.parentModule;
    }

    @Override
    public DynamicObject getActualModule() {
        return this.includedModule;
    }

    public String toString() {
        return super.toString() + "(" + this.includedModule + ")";
    }

    @Override
    public void insertAfter(DynamicObject module) {
        this.parentModule = new IncludedModule(module, this.parentModule);
    }
}

