/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.rubinius.AtomicReferenceLayout;

public class AtomicReferenceLayoutImpl
extends BasicObjectLayoutImpl
implements AtomicReferenceLayout {
    public static final AtomicReferenceLayout INSTANCE = new AtomicReferenceLayoutImpl();
    protected static final Shape.Allocator ATOMIC_REFERENCE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey VALUE_IDENTIFIER = new HiddenKey("value");
    protected static final Property VALUE_PROPERTY = Property.create(VALUE_IDENTIFIER, ATOMIC_REFERENCE_ALLOCATOR.locationForType(AtomicReference.class, EnumSet.of(LocationModifier.NonNull)), 0);

    protected AtomicReferenceLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createAtomicReferenceShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new AtomicReferenceType(logicalClass, metaClass)).addProperty(VALUE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createAtomicReference(DynamicObjectFactory factory, Object value) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsAtomicReference(factory));
        assert (factory.getShape().hasProperty(VALUE_IDENTIFIER));
        assert (value != null);
        return factory.newInstance(new AtomicReference<Object>(value));
    }

    private boolean isAtomicReference(DynamicObject object) {
        return this.isAtomicReference(object.getShape().getObjectType());
    }

    private boolean isAtomicReference(ObjectType objectType) {
        return objectType instanceof AtomicReferenceType;
    }

    private boolean createsAtomicReference(DynamicObjectFactory factory) {
        return this.isAtomicReference(factory.getShape().getObjectType());
    }

    @Override
    public Object getValue(DynamicObject object) {
        assert (this.isAtomicReference(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        return ((AtomicReference)VALUE_PROPERTY.get(object, true)).get();
    }

    @Override
    public void setValue(DynamicObject object, Object value) {
        assert (this.isAtomicReference(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        assert (value != null);
        ((AtomicReference)VALUE_PROPERTY.get(object, true)).set(value);
    }

    @Override
    public boolean compareAndSetValue(DynamicObject object, Object expected_value, Object value) {
        assert (this.isAtomicReference(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        assert (value != null);
        return ((AtomicReference)VALUE_PROPERTY.get(object, true)).compareAndSet(expected_value, value);
    }

    @Override
    public Object getAndSetValue(DynamicObject object, Object value) {
        assert (this.isAtomicReference(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        assert (value != null);
        return ((AtomicReference)VALUE_PROPERTY.get(object, true)).getAndSet(value);
    }

    protected static class AtomicReferenceType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public AtomicReferenceType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public AtomicReferenceType setLogicalClass(DynamicObject logicalClass) {
            return new AtomicReferenceType(logicalClass, this.metaClass);
        }

        @Override
        public AtomicReferenceType setMetaClass(DynamicObject metaClass) {
            return new AtomicReferenceType(this.logicalClass, metaClass);
        }
    }
}

