/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.handlers.interfaces;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.WorkDoneDataModel;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.pdf.handlers.interfaces.CmdExecutor;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.utils.FilenameComparator;
import org.pdfsam.console.utils.PdfFilter;

public abstract class AbstractCmdExecutor
extends Observable
implements CmdExecutor {
    private final Logger LOG = Logger.getLogger(AbstractCmdExecutor.class.getPackage().getName());
    private WorkDoneDataModel workDone = null;

    protected final void setPercentageOfWorkDone(int percentage) {
        if (this.workDone == null) {
            this.workDone = new WorkDoneDataModel();
        }
        this.workDone.setPercentage(percentage);
        this.setChanged();
        this.notifyObservers(this.workDone);
    }

    protected final void setWorkIndeterminate() {
        this.setPercentageOfWorkDone(-1);
    }

    protected final void setWorkCompleted() {
        this.setPercentageOfWorkDone(1000);
    }

    protected final void resetPercentageOfWorkDone() {
        if (this.workDone != null) {
            this.workDone.resetPercentage();
        }
    }

    public abstract void execute(AbstractParsedCommand var1) throws ConsoleException;

    protected PdfFile[] getPdfFiles(File directory) {
        PdfFile[] retVal = null;
        if (directory != null && directory.isDirectory()) {
            File[] fileList = directory.listFiles(new PdfFilter());
            Arrays.sort(fileList, new FilenameComparator());
            ArrayList<PdfFile> list = new ArrayList<PdfFile>();
            for (int i = 0; i < fileList.length; ++i) {
                list.add(new PdfFile(fileList[i], null));
            }
            if (list.size() <= 0) {
                this.LOG.warn("No pdf documents found in " + directory);
            }
            retVal = list.toArray(new PdfFile[list.size()]);
        }
        return retVal;
    }

    protected PdfFile[] arraysConcat(PdfFile[] first, PdfFile[] second) {
        PdfFile[] retVal = null;
        if (first != null && second != null) {
            retVal = new PdfFile[first.length + second.length];
            System.arraycopy(first, 0, retVal, 0, first.length);
            System.arraycopy(second, 0, retVal, first.length, second.length);
        } else {
            retVal = first != null ? first : second;
        }
        return retVal;
    }

    protected void setCompressionSettingOnWriter(AbstractParsedCommand inputCommand, PdfWriter pdfWriter) {
        if (inputCommand.isCompress()) {
            pdfWriter.setFullCompression();
            pdfWriter.setCompressionLevel(9);
        }
    }

    protected void setCompressionSettingOnStamper(AbstractParsedCommand inputCommand, PdfStamper pdfStamper) {
        if (inputCommand.isCompress()) {
            pdfStamper.setFullCompression();
            pdfStamper.getWriter().setCompressionLevel(9);
        }
    }

    protected void setPdfVersionSettingOnWriter(AbstractParsedCommand inputCommand, PdfWriter pdfWriter, Character defaultVersion) {
        if (inputCommand.getOutputPdfVersion() != null) {
            pdfWriter.setPdfVersion(inputCommand.getOutputPdfVersion().charValue());
        } else if (defaultVersion != null) {
            pdfWriter.setPdfVersion(defaultVersion.charValue());
        }
    }

    protected void setPdfVersionSettingOnWriter(AbstractParsedCommand inputCommand, PdfWriter pdfWriter) {
        this.setPdfVersionSettingOnWriter(inputCommand, pdfWriter, null);
    }

    protected void closePdfReader(PdfReader pdfReader) {
        if (pdfReader != null) {
            pdfReader.close();
            pdfReader = null;
        }
    }

    protected void closePdfStamper(PdfStamper pdfStamper) {
        if (pdfStamper != null) {
            try {
                pdfStamper.close();
            }
            catch (Exception e) {
                this.LOG.error("An error occured closing the PdfStamper.", e);
            }
            pdfStamper = null;
        }
    }

    protected void closePdfWriter(PdfWriter pdfWriter) {
        if (pdfWriter != null) {
            pdfWriter.close();
            pdfWriter = null;
        }
    }
}

