/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class FDObject
extends COSBasedObject {
    protected FDObject(COSObject cOSObject) {
        super(cOSObject);
    }

    protected void cosMoveField(COSName cOSName, COSDictionary cOSDictionary, COSDictionary cOSDictionary2) {
        COSObject cOSObject = cOSDictionary.get(cOSName);
        if (!cOSObject.isNull()) {
            cOSDictionary.remove(cOSName);
            cOSDictionary2.put(cOSName, cOSObject);
        }
    }

    protected List getFDObjects(COSName cOSName, COSBasedObject.MetaClass metaClass) {
        COSArray cOSArray = this.cosGetField(cOSName).asArray();
        if (cOSArray == null) {
            return null;
        }
        ArrayList<COSBasedObject> arrayList = new ArrayList<COSBasedObject>();
        Iterator iterator = cOSArray.iterator();
        while (iterator.hasNext()) {
            arrayList.add(metaClass.createFromCos((COSObject)iterator.next()));
        }
        return arrayList;
    }

    protected float[] getFloatArray(COSName cOSName) {
        COSArray cOSArray = this.cosGetField(cOSName).asArray();
        if (cOSArray == null) {
            return null;
        }
        float[] fArray = new float[cOSArray.size()];
        int n = 0;
        while (n < cOSArray.size()) {
            COSNumber cOSNumber = (COSNumber)cOSArray.get(n);
            fArray[n] = cOSNumber.floatValue();
            ++n;
        }
        return fArray;
    }

    protected void setFDObjects(COSName cOSName, List list, boolean bl) {
        if (list == null || list.isEmpty()) {
            if (bl) {
                this.cosSetField(cOSName, COSArray.create());
            } else {
                this.cosRemoveField(cOSName);
            }
            return;
        }
        COSArray cOSArray = COSArray.create();
        this.cosSetField(cOSName, cOSArray);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            cOSArray.add(((FDObject)iterator.next()).cosGetObject());
        }
    }

    protected void setFloatArray(COSName cOSName, float[] fArray, boolean bl) {
        if (fArray == null || fArray.length == 0) {
            if (bl) {
                this.cosSetField(cOSName, COSArray.create());
            } else {
                this.cosRemoveField(cOSName);
            }
            return;
        }
        COSArray cOSArray = COSArray.create();
        this.cosSetField(cOSName, cOSArray);
        int n = 0;
        while (n < fArray.length) {
            cOSArray.add(COSFixed.create(fArray[n]));
            ++n;
        }
    }

    @Override
    public String toString() {
        String string = "[]";
        if (this.cosGetObject().isIndirect()) {
            string = "[" + this.cosGetObject().getIndirectObject().toString() + "]";
        }
        return string;
    }

    public static abstract class MetaClass
    extends COSBasedObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }
    }
}

