/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.AcroFormSigFlags;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.pd.PDSignatureLock;
import de.intarsys.pdf.pd.PDSignatureSeedValue;
import java.util.HashSet;

public class PDAFSignatureField
extends PDAcroFormField {
    public static final COSName DK_Lock = COSName.constant("Lock");
    public static final COSName DK_SV = COSName.constant("SV");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private PDSignature cachedSignature;

    protected PDAFSignatureField(COSObject cOSObject) {
        super(cOSObject);
    }

    public void clearSignature() {
        COSDictionary cOSDictionary = this.getDoc().cosGetPermissionsDict();
        if (cOSDictionary != null) {
            for (COSName cOSName : new HashSet(cOSDictionary.keySet())) {
                COSObject cOSObject = cOSDictionary.get(cOSName);
                if (cOSObject != this.cosGetValue()) continue;
                cOSDictionary.remove(cOSName);
            }
        }
        this.setSignature(null);
    }

    @Override
    public COSName cosGetExpectedFieldType() {
        return CN_FT_Sig;
    }

    @Override
    public COSObject cosSetValue(COSObject cOSObject) {
        COSObject cOSObject2 = super.cosSetValue(cOSObject);
        AcroFormSigFlags acroFormSigFlags = this.getAcroForm().getSigFlags();
        acroFormSigFlags.setAppendOnly(this.getAcroForm().isSigned());
        return cOSObject2;
    }

    public PDSignatureLock getLock() {
        return (PDSignatureLock)PDSignatureLock.META.createFromCos(this.cosGetField(DK_Lock));
    }

    public PDSignatureSeedValue getSeedValue() {
        return (PDSignatureSeedValue)PDSignatureSeedValue.META.createFromCos(this.cosGetField(DK_SV));
    }

    public PDSignature getSignature() {
        if (this.cachedSignature == null) {
            this.cachedSignature = (PDSignature)PDSignature.META.createFromCos(this.cosGetValue());
            if (this.cachedSignature != null) {
                this.cachedSignature.setAcroFormField(this);
            }
        }
        return this.cachedSignature;
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedSignature = null;
    }

    public boolean isSigned() {
        return !this.cosGetValue().isNull();
    }

    @Override
    public boolean isTypeSig() {
        return true;
    }

    public void setLock(PDSignatureLock pDSignatureLock) {
        this.setFieldObject(DK_Lock, pDSignatureLock);
    }

    public void setSeedValue(PDSignatureSeedValue pDSignatureSeedValue) {
        this.setFieldObject(DK_SV, pDSignatureSeedValue);
    }

    public void setSignature(PDSignature pDSignature) {
        if (this.cachedSignature != null) {
            this.cachedSignature.setAcroFormField(null);
        }
        this.cachedSignature = pDSignature;
        if (pDSignature != null) {
            pDSignature.setAcroFormField(this);
            this.cosSetValue(pDSignature.cosGetObject());
        } else {
            this.cosSetValue(null);
        }
    }

    public static class MetaClass
    extends PDAcroFormField.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDAFSignatureField(cOSObject);
        }
    }
}

