/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.thumbnails.executors;

import java.util.Collection;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.IdManager;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class ThumbnailsExecutor {
    private static final Logger log = Logger.getLogger(ThumbnailsExecutor.class.getPackage().getName());
    private static ThumbnailsExecutor instance = null;
    private ExecutorService executor = Executors.newFixedThreadPool(Configuration.getInstance().getThumbCreatorPoolSize());

    private ThumbnailsExecutor() {
    }

    public static synchronized ThumbnailsExecutor getInstance() {
        if (instance == null) {
            instance = new ThumbnailsExecutor();
        }
        return instance;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cannot clone ThumbnailsExecutor object.");
    }

    public synchronized void submit(Callable<?> c) {
        this.getExecutor().submit(c);
    }

    public synchronized void execute(Runnable r) {
        this.getExecutor().execute(r);
    }

    private ExecutorService getExecutor() {
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = Executors.newFixedThreadPool(Configuration.getInstance().getThumbCreatorPoolSize());
        }
        return this.executor;
    }

    public void invokeAll(Collection<? extends Callable<Boolean>> tasks, Callable<Boolean> closeTask, long id) {
        Thread t = new Thread(new Invoker(tasks, closeTask, id));
        t.start();
    }

    private class Invoker
    implements Runnable {
        private Collection<? extends Callable<Boolean>> tasks;
        private Callable<Boolean> closeTask;
        private long id;

        public Invoker(Collection<? extends Callable<Boolean>> tasks, Callable<Boolean> closeTask, long id) {
            this.tasks = tasks;
            this.closeTask = closeTask;
            this.id = id;
        }

        @Override
        public void run() {
            try {
                if (this.tasks != null && this.tasks.size() > 0) {
                    long startTime = System.currentTimeMillis();
                    ThumbnailsExecutor.this.getExecutor().invokeAll(this.tasks);
                    if (this.closeTask != null) {
                        ThumbnailsExecutor.this.getExecutor().submit(this.closeTask);
                    }
                    if (!IdManager.getInstance().isCancelledExecution(this.id)) {
                        log.debug(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)("Thumbnails generated in " + (System.currentTimeMillis() - startTime) + "ms")));
                    }
                    IdManager.getInstance().removeCancelledExecution(this.id);
                }
            }
            catch (InterruptedException ie) {
                log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to generate thumbnail"), ie);
            }
        }
    }
}

