/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import org.pdfsam.guiclient.dto.VisualPageListItem;

public class VisualListModel
extends AbstractListModel {
    private static final long serialVersionUID = -1468591826451724954L;
    protected Vector<VisualPageListItem> data = new Vector();

    @Override
    public Object getElementAt(int index) {
        VisualPageListItem retVal = null;
        if (index < this.data.size()) {
            retVal = this.data.get(index);
        }
        return retVal;
    }

    @Override
    public int getSize() {
        return this.data != null ? this.data.size() : 0;
    }

    public void setData(VisualPageListItem[] inputData) {
        this.clearData();
        int inputDataSize = inputData.length;
        if (inputDataSize > 0) {
            for (int i = 0; i < inputDataSize; ++i) {
                this.data.add(inputData[i]);
            }
            this.fireIntervalAdded(this, 0, inputDataSize - 1);
        }
    }

    public void setData(Vector<VisualPageListItem> inputData) {
        this.clearData();
        int inputDataSize = inputData.size();
        if (inputDataSize > 0) {
            this.data = inputData;
            this.fireIntervalAdded(this, 0, inputDataSize - 1);
        }
    }

    public void clearData() {
        int dataSize = this.data.size();
        this.data.clear();
        if (dataSize > 0) {
            this.fireIntervalRemoved(this, 0, dataSize - 1);
        }
    }

    public void removeElementAt(int index, boolean physicalDeletion) {
        if (physicalDeletion) {
            this.data.remove(index);
        } else {
            this.data.get(index).setDeleted(true);
        }
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeElements(int[] rows, boolean physicalDeletion) throws IndexOutOfBoundsException {
        if (rows.length > 0 && rows.length <= this.data.size()) {
            if (physicalDeletion) {
                this.data.subList(rows[0], rows[rows.length - 1] + 1).clear();
            } else {
                for (int i = 0; i < rows.length; ++i) {
                    this.data.get(rows[i]).setDeleted(true);
                }
            }
            this.fireIntervalRemoved(this, rows[0], rows[rows.length - 1]);
        }
    }

    public void removeElements(int fromIndex, int toIndex, boolean physicalDeletion) throws IndexOutOfBoundsException {
        if (fromIndex >= 0 && toIndex < this.data.size() && fromIndex <= toIndex) {
            if (physicalDeletion) {
                this.data.subList(fromIndex, toIndex + 1).clear();
            } else {
                for (int i = fromIndex; i < toIndex; ++i) {
                    this.data.get(i).setDeleted(true);
                }
            }
            this.fireIntervalRemoved(this, fromIndex, toIndex);
        }
    }

    public void addElementAt(VisualPageListItem inputData, int index) {
        if (inputData != null) {
            this.data.add(index, inputData);
            this.fireIntervalAdded(this, index, index);
        }
    }

    public void addElement(VisualPageListItem inputData) {
        this.data.add(inputData);
        this.fireIntervalAdded(this, this.data.size(), this.data.size());
    }

    public void addAllElements(Collection<VisualPageListItem> c) {
        if (c != null) {
            int i = 0;
            for (VisualPageListItem element : c) {
                this.data.add(element);
                ++i;
            }
            this.fireIntervalAdded(this, this.data.size(), this.data.size() + i - 1);
        }
    }

    public void appendAllElements(Collection<VisualPageListItem> c) {
        this.addAllElements(c);
    }

    public void prependAllElements(Collection<VisualPageListItem> c) {
        if (c != null && c.size() > 0) {
            this.data.addAll(0, c);
            this.fireIntervalAdded(this, 0, c.size() - 1);
        }
    }

    public void addAllElements(int index, Collection<VisualPageListItem> c) {
        if (c != null && index >= 0 && index <= this.data.size()) {
            int i = index;
            for (VisualPageListItem element : c) {
                this.data.add(i, element);
                ++i;
            }
            this.fireIntervalAdded(this, index, i - 1);
        }
    }

    public Collection<VisualPageListItem> subList(int fromIndex, int toIndex) {
        return this.subList(fromIndex, toIndex, false);
    }

    public Collection<VisualPageListItem> subList(int fromIndex, int toIndex, boolean newInstance) {
        List<VisualPageListItem> retVal = null;
        if (fromIndex >= 0 && toIndex <= this.data.size()) {
            if (newInstance) {
                List<VisualPageListItem> itemsList = this.data.subList(fromIndex, toIndex);
                if (itemsList != null && itemsList.size() > 0) {
                    retVal = new Vector<VisualPageListItem>(itemsList.size());
                    for (VisualPageListItem currItem : itemsList) {
                        retVal.add((VisualPageListItem)currItem.clone());
                    }
                } else {
                    retVal = new Vector<VisualPageListItem>();
                }
            } else {
                retVal = this.data.subList(fromIndex, toIndex);
            }
        }
        return retVal;
    }

    public VisualPageListItem[] getElements() {
        VisualPageListItem[] retVal = null;
        if (this.data != null) {
            retVal = this.data.toArray(new VisualPageListItem[this.data.size()]);
        }
        return retVal;
    }

    public void updateElementAt(int index, VisualPageListItem inputData) {
        if (inputData != null && index >= 0 && index < this.data.size()) {
            this.data.set(index, inputData);
            this.fireContentsChanged(this, index, index);
        }
    }

    public void elementChanged(VisualPageListItem inputData) {
        int position;
        if (inputData != null && this.data.size() > 0 && (position = this.data.indexOf(inputData)) >= 0) {
            this.fireContentsChanged(this, position, position);
        }
    }

    public void elementsChanged() {
        this.fireContentsChanged(this, 0, this.data.size());
    }

    public void undeleteElements(int[] indexes) throws IndexOutOfBoundsException {
        if (indexes.length > 0 && indexes.length <= this.data.size()) {
            for (int i = 0; i < indexes.length; ++i) {
                this.data.get(indexes[i]).setDeleted(false);
            }
            this.fireContentsChanged(this, indexes[0] - 1, indexes[indexes.length - 1]);
        }
    }

    public void reverseElements(int[] indexes) throws IndexOutOfBoundsException {
        if (indexes.length > 0 && indexes.length <= this.data.size()) {
            int i;
            ArrayList<VisualPageListItem> items = new ArrayList<VisualPageListItem>(this.data.size());
            for (i = 0; i < indexes.length; ++i) {
                items.add(this.data.get(indexes[i]));
            }
            Collections.reverse(items);
            for (i = 0; i < indexes.length; ++i) {
                this.data.set(indexes[i], (VisualPageListItem)items.get(i));
            }
            this.fireContentsChanged(this, indexes[0] - 1, indexes[indexes.length - 1]);
        }
    }

    public void rotateClockwiseElements(int[] indexes) throws IndexOutOfBoundsException {
        if (indexes.length > 0 && indexes.length <= this.data.size()) {
            for (int i = 0; i < indexes.length; ++i) {
                VisualPageListItem item = this.data.get(indexes[i]);
                item.rotateClockwise();
            }
            this.fireContentsChanged(this, indexes[0] - 1, indexes[indexes.length - 1]);
        }
    }

    public void rotateAnticlockwiseElements(int[] indexes) throws IndexOutOfBoundsException {
        if (indexes.length > 0 && indexes.length <= this.data.size()) {
            for (int i = 0; i < indexes.length; ++i) {
                VisualPageListItem item = this.data.get(indexes[i]);
                item.rotateAnticlockwise();
            }
            this.fireContentsChanged(this, indexes[0] - 1, indexes[indexes.length - 1]);
        }
    }

    public void moveUpIndex(int index) throws IndexOutOfBoundsException {
        if (index >= 1 && index < this.data.size()) {
            VisualPageListItem tmpElement = this.data.get(index);
            this.data.set(index, this.data.get(index - 1));
            this.data.set(index - 1, tmpElement);
            this.fireContentsChanged(this, index - 1, index);
        }
    }

    public void moveUpIndexes(int[] indexes) throws IndexOutOfBoundsException {
        if (indexes.length > 0 && indexes.length < this.data.size() && indexes[0] > 0) {
            VisualPageListItem tmpElement = this.data.get(indexes[0] - 1);
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] <= 0) continue;
                this.data.set(indexes[i] - 1, this.data.get(indexes[i]));
            }
            this.data.set(indexes[indexes.length - 1], tmpElement);
            this.fireContentsChanged(this, indexes[0] - 1, indexes[indexes.length - 1]);
        }
    }

    public void moveDownIndex(int index) throws IndexOutOfBoundsException {
        if (index >= 0 && index < this.data.size() - 1) {
            VisualPageListItem tmpElement = this.data.get(index);
            this.data.set(index, this.data.get(index + 1));
            this.data.set(index + 1, tmpElement);
            this.fireContentsChanged(this, index, index + 1);
        }
    }

    public void moveDownIndexes(int[] indexes) throws IndexOutOfBoundsException {
        if (indexes.length > 0 && indexes.length < this.data.size() && indexes[indexes.length - 1] < this.data.size() - 1) {
            VisualPageListItem tmpElement = this.data.get(indexes[indexes.length - 1] + 1);
            for (int i = indexes.length - 1; i >= 0; --i) {
                if (indexes[indexes.length - 1] >= this.data.size() - 1) continue;
                this.data.set(indexes[i] + 1, this.data.get(indexes[i]));
            }
            this.data.set(indexes[0], tmpElement);
            this.fireContentsChanged(this, indexes[0], indexes[indexes.length - 1] + 1);
        }
    }

    public List<VisualPageListItem> getValidElements() {
        ArrayList<VisualPageListItem> retVal = null;
        if (this.data != null && this.data.size() > 0) {
            retVal = new ArrayList<VisualPageListItem>(this.data.size());
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get(i).isDeleted()) continue;
                retVal.add(this.data.get(i));
            }
        }
        return retVal;
    }
}

