/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro.statistics;

import common.FolderIteratorInfo;
import common.FolderIteratorListener;
import common.Util;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPInputStream;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.guitarPro.statistics.GPStatsPiece;
import java.io.File;
import java.io.IOException;

public class GPStats
implements FolderIteratorListener {
    GPStatsPiece PieceCumulative;
    private boolean detailed;
    protected static int level = 0;
    String msg;
    private String results;

    private static float porcentaje(int v, int max) {
        return v * 100 / max;
    }

    protected String stringFor(int value, String sValue, int max, String sMax) {
        String res = "";
        if (value != 0) {
            res = String.valueOf(res) + Util.tabs(level);
            res = String.valueOf(res) + value + "/" + max + " ";
            res = String.valueOf(res) + "(" + sValue + "/" + sMax + ") = ";
            res = String.valueOf(res) + GPStats.porcentaje(value, max) + "%";
            res = String.valueOf(res) + "\n";
        }
        return res;
    }

    public void actionForFile(File file, FolderIteratorInfo FII) {
        boolean error = false;
        try {
            GPInputStream GIS = new GPInputStream(file);
            GPSong p = (GPSong)GIS.readObject();
            if (p != null) {
                GPStatsPiece pieceInfo = new GPStatsPiece();
                pieceInfo.getStats(p, file.getAbsolutePath());
                ++level;
                this.results = String.valueOf(this.results) + pieceInfo.toString();
                --level;
                this.PieceCumulative.add(pieceInfo);
            } else {
                this.msg = "GPInputStream.readPiece() failed";
                error = true;
            }
        }
        catch (GPFormatException GPFE) {
            error = true;
            this.msg = GPFE.toString();
        }
        catch (IOException FNFE) {
            error = true;
            this.msg = FNFE.getLocalizedMessage();
        }
        if (error) {
            String aux = "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
            aux = String.valueOf(aux) + "\n\tFILE >" + file + "< was not processed\n";
            aux = String.valueOf(aux) + "\n\tERROR:" + this.msg;
            aux = String.valueOf(aux) + "\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n";
            this.results = String.valueOf(this.results) + aux;
        }
    }

    public void actionRunInit(FolderIteratorInfo FII) {
        level = 0;
        this.results = "Statistics for '" + FII.getStartigPath() + "'\n";
        this.PieceCumulative = new GPStatsPiece();
    }

    public void actionRunFinished(FolderIteratorInfo FII) {
        int j = 0;
        while (j < 3) {
            this.results = String.valueOf(this.results) + "==========================";
            ++j;
        }
        this.results = String.valueOf(this.results) + "\n";
        this.results = String.valueOf(this.results) + "Totals for '" + FII.getStartigPath() + "'\n";
        this.results = String.valueOf(this.results) + "\t" + FII.getCountFiles() + " " + "files" + "\n";
        this.results = String.valueOf(this.results) + "\t" + FII.getCountFolders() + " " + "folders" + "\n";
        this.results = String.valueOf(this.results) + this.PieceCumulative.toString();
    }

    public void setResults(String results) {
        this.results = results;
    }

    public String getResults() {
        return this.results;
    }

    public void setDetailed(boolean detailed) {
        this.detailed = detailed;
    }

    public boolean isDetailed() {
        return this.detailed;
    }

    public void actionForFolder(File folder, File path, FolderIteratorInfo FII) {
    }
}

