/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.nodes.NodeUtil;

public final class ProbeFailure {
    private final Reason reason;
    private final Node parent;
    private final Node child;
    private final Object wrapper;

    public ProbeFailure(Reason reason, Node parent, Node child, Object wrapper) {
        this.reason = reason;
        this.parent = parent;
        this.child = child;
        this.wrapper = wrapper;
    }

    public Reason getReason() {
        return this.reason;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getChild() {
        return this.child;
    }

    public Object getWrapper() {
        return this.wrapper;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.reason.message) + ": ");
        if (this.parent != null) {
            sb.append("parent=" + this.parent.getClass().getSimpleName() + " ");
            if (this.child != null) {
                sb.append("child=" + this.child.getClass().getSimpleName() + " ");
                NodeFieldAccessor field = NodeUtil.findChildField(this.parent, this.child);
                if (field != null) {
                    sb.append("field=" + field.getName() + " ");
                }
            }
        }
        if (this.wrapper != null) {
            sb.append("wrapper=" + this.wrapper.getClass().getSimpleName());
        }
        return sb.toString();
    }

    public static enum Reason {
        NO_PARENT("Node to be probed has no parent"),
        WRAPPER_NODE("The node to be probed is a wrapper"),
        NOT_INSTRUMENTABLE("The node to be project is \"not instrumentable\""),
        NO_WRAPPER("No wrapper could be created"),
        WRAPPER_TYPE("Wrapper not assignable to parent's child field");

        final String message;

        private Reason(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

