/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import java.util.Objects;

public abstract class Transition {
    public int hashCode() {
        int result = 1;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public abstract boolean isDirect();

    public String getShortName() {
        return this.getClass().getSimpleName().replaceFirst("Transition$", "").toLowerCase();
    }

    public static final class AddPropertyTransition
    extends PropertyTransition {
        public AddPropertyTransition(Property property) {
            super(property);
        }

        @Override
        public boolean isDirect() {
            return true;
        }
    }

    public static final class ObjectTypeTransition
    extends Transition {
        private final ObjectType objectType;

        public ObjectTypeTransition(ObjectType objectType) {
            this.objectType = objectType;
        }

        public ObjectType getObjectType() {
            return this.objectType;
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && Objects.equals(this.objectType, ((ObjectTypeTransition)other).objectType);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
            return result;
        }

        @Override
        public boolean isDirect() {
            return true;
        }
    }

    public static abstract class PropertyTransition
    extends Transition {
        private final Property property;

        public PropertyTransition(Property property) {
            this.property = property;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            PropertyTransition other = (PropertyTransition)obj;
            return Objects.equals(this.property, other.property);
        }

        public Property getProperty() {
            return this.property;
        }
    }

    public static final class RemovePropertyTransition
    extends PropertyTransition {
        public RemovePropertyTransition(Property property) {
            super(property);
        }

        @Override
        public boolean isDirect() {
            return false;
        }
    }

    public static final class ReplacePropertyTransition
    extends PropertyTransition {
        private final Property after;

        public ReplacePropertyTransition(Property before, Property after) {
            super(before);
            this.after = after;
        }

        public Property getPropertyBefore() {
            return this.getProperty();
        }

        public Property getPropertyAfter() {
            return this.after;
        }

        @Override
        public boolean isDirect() {
            return false;
        }
    }

    public static final class ReservePrimitiveArrayTransition
    extends Transition {
        @Override
        public boolean isDirect() {
            return true;
        }
    }
}

