/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.basic;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.DynamicObjectImpl;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.basic.BasicLocations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DynamicObjectBasic
extends DynamicObjectImpl {
    @DynamicField
    private long primitive1;
    @DynamicField
    private long primitive2;
    @DynamicField
    private long primitive3;
    @DynamicField
    private Object object1;
    @DynamicField
    private Object object2;
    @DynamicField
    private Object object3;
    @DynamicField
    private Object object4;
    private Object[] objext;
    private long[] primext;
    static final BasicLocations.SimpleObjectFieldLocation[] OBJECT_FIELD_LOCATIONS;
    static final BasicLocations.SimpleLongFieldLocation[] PRIMITIVE_FIELD_LOCATIONS;
    static final BasicLocations.SimpleObjectFieldLocation OBJECT_ARRAY_LOCATION;
    static final BasicLocations.SimpleObjectFieldLocation PRIMITIVE_ARRAY_LOCATION;

    static {
        int index = 0;
        PRIMITIVE_FIELD_LOCATIONS = new BasicLocations.SimpleLongFieldLocation[]{new BasicLocations.SimpleLongFieldLocation(index++){

            @Override
            public long getLong(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).primitive1;
            }

            @Override
            public void setLongInternal(DynamicObject store, long value) {
                ((DynamicObjectBasic)store).primitive1 = value;
            }
        }, new BasicLocations.SimpleLongFieldLocation(index++){

            @Override
            public long getLong(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).primitive2;
            }

            @Override
            public void setLongInternal(DynamicObject store, long value) {
                ((DynamicObjectBasic)store).primitive2 = value;
            }
        }, new BasicLocations.SimpleLongFieldLocation(index++){

            @Override
            public long getLong(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).primitive3;
            }

            @Override
            public void setLongInternal(DynamicObject store, long value) {
                ((DynamicObjectBasic)store).primitive3 = value;
            }
        }};
        index = 0;
        OBJECT_FIELD_LOCATIONS = new BasicLocations.SimpleObjectFieldLocation[]{new BasicLocations.SimpleObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).object1;
            }

            @Override
            public void setInternal(DynamicObject store, Object value) {
                ((DynamicObjectBasic)store).object1 = value;
            }
        }, new BasicLocations.SimpleObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).object2;
            }

            @Override
            public void setInternal(DynamicObject store, Object value) {
                ((DynamicObjectBasic)store).object2 = value;
            }
        }, new BasicLocations.SimpleObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).object3;
            }

            @Override
            public void setInternal(DynamicObject store, Object value) {
                ((DynamicObjectBasic)store).object3 = value;
            }
        }, new BasicLocations.SimpleObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).object4;
            }

            @Override
            public void setInternal(DynamicObject store, Object value) {
                ((DynamicObjectBasic)store).object4 = value;
            }
        }};
        OBJECT_ARRAY_LOCATION = new BasicLocations.SimpleObjectFieldLocation(index++){

            public Object[] get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).objext;
            }

            @Override
            public void setInternal(DynamicObject store, Object value) {
                ((DynamicObjectBasic)store).objext = (Object[])value;
            }
        };
        PRIMITIVE_ARRAY_LOCATION = new BasicLocations.SimpleObjectFieldLocation(index++){

            public long[] get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).primext;
            }

            @Override
            public void setInternal(DynamicObject store, Object value) {
                ((DynamicObjectBasic)store).primext = (long[])value;
            }
        };
    }

    public DynamicObjectBasic(Shape shape) {
        super(shape);
    }

    @Override
    protected final void initialize(Shape shape) {
        assert (this.getObjectStore(shape) == null);
        int capacity = ((ShapeImpl)shape).getObjectArrayCapacity();
        if (capacity != 0) {
            this.setObjectStore(new Object[capacity], shape);
        }
        if (((ShapeImpl)shape).getPrimitiveArrayCapacity() != 0) {
            this.setPrimitiveStore(new long[((ShapeImpl)shape).getPrimitiveArrayCapacity()], shape);
        }
    }

    @Override
    protected final void growObjectStore(Shape oldShape, Shape newShape) {
        int newObjectArrayCapacity;
        int oldObjectArrayCapacity = ((ShapeImpl)oldShape).getObjectArrayCapacity();
        if (oldObjectArrayCapacity != (newObjectArrayCapacity = ((ShapeImpl)newShape).getObjectArrayCapacity())) {
            this.growObjectStoreIntl(oldObjectArrayCapacity, newObjectArrayCapacity, oldShape);
        }
    }

    private void growObjectStoreIntl(int oldObjectArrayCapacity, int newObjectArrayCapacity, Shape newShape) {
        Object[] newObjectStore = new Object[newObjectArrayCapacity];
        if (oldObjectArrayCapacity != 0) {
            assert (oldObjectArrayCapacity < newObjectArrayCapacity);
            Object[] oldObjectStore = this.getObjectStore(newShape);
            int i = 0;
            while (i < oldObjectArrayCapacity) {
                newObjectStore[i] = oldObjectStore[i];
                ++i;
            }
        }
        this.setObjectStore(newObjectStore, newShape);
    }

    @Override
    protected final void growPrimitiveStore(Shape oldShape, Shape newShape) {
        assert (((ShapeImpl)newShape).hasPrimitiveArray());
        int oldPrimitiveCapacity = oldShape.getPrimitiveArrayCapacity();
        int newPrimitiveCapacity = newShape.getPrimitiveArrayCapacity();
        if (newPrimitiveCapacity == 0) {
            this.setPrimitiveStore(null, newShape);
        } else if (oldPrimitiveCapacity != newPrimitiveCapacity) {
            this.growPrimitiveStoreIntl(oldPrimitiveCapacity, newPrimitiveCapacity, oldShape);
        }
    }

    private void growPrimitiveStoreIntl(int oldPrimitiveCapacity, int newPrimitiveCapacity, Shape newShape) {
        long[] newPrimitiveArray = new long[newPrimitiveCapacity];
        if (oldPrimitiveCapacity != 0) {
            long[] oldPrimitiveArray = this.getPrimitiveStore(newShape);
            int i = 0;
            while (i < Math.min(oldPrimitiveCapacity, newPrimitiveCapacity)) {
                newPrimitiveArray[i] = oldPrimitiveArray[i];
                ++i;
            }
        }
        this.setPrimitiveStore(newPrimitiveArray, newShape);
    }

    @Override
    protected final void resizeObjectStore(Shape oldShape, Shape newShape) {
        Object[] newObjectStore = null;
        int destinationCapacity = newShape.getObjectArrayCapacity();
        if (destinationCapacity != 0) {
            newObjectStore = new Object[destinationCapacity];
            int sourceCapacity = oldShape.getObjectArrayCapacity();
            if (sourceCapacity != 0) {
                Object[] oldObjectStore = this.getObjectStore(newShape);
                int i = 0;
                while (i < Math.min(sourceCapacity, destinationCapacity)) {
                    newObjectStore[i] = oldObjectStore[i];
                    ++i;
                }
            }
        }
        this.setObjectStore(newObjectStore, newShape);
    }

    private Object[] getObjectStore(Shape currentShape) {
        return this.objext;
    }

    private void setObjectStore(Object[] newArray, Shape currentShape) {
        this.objext = newArray;
    }

    private long[] getPrimitiveStore(Shape currentShape) {
        return this.primext;
    }

    private void setPrimitiveStore(long[] newArray, Shape currentShape) {
        this.primext = newArray;
    }

    @Override
    protected final void resizePrimitiveStore(Shape oldShape, Shape newShape) {
        assert (newShape.hasPrimitiveArray());
        long[] newPrimitiveArray = null;
        int destinationCapacity = newShape.getPrimitiveArrayCapacity();
        if (destinationCapacity != 0) {
            newPrimitiveArray = new long[destinationCapacity];
            int sourceCapacity = oldShape.getPrimitiveArrayCapacity();
            if (sourceCapacity != 0) {
                long[] oldPrimitiveArray = this.getPrimitiveStore(newShape);
                int i = 0;
                while (i < Math.min(sourceCapacity, destinationCapacity)) {
                    newPrimitiveArray[i] = oldPrimitiveArray[i];
                    ++i;
                }
            }
        }
        this.setPrimitiveStore(newPrimitiveArray, newShape);
    }

    private boolean checkSetShape(Shape oldShape, Shape newShape) {
        ShapeImpl currentShape = this.getShape();
        assert (oldShape != newShape) : "Wrong old shape assumption?";
        assert (newShape != currentShape) : "Redundant shape change? shape=" + currentShape;
        assert (oldShape == currentShape || oldShape.getParent() == currentShape) : "Out-of-order shape change?\nparentShape=" + currentShape + "\noldShape=" + oldShape + "\nnewShape=" + newShape;
        return true;
    }

    @Override
    protected final boolean checkExtensionArrayInvariants(Shape newShape) {
        assert (this.getShape() == newShape);
        assert (this.getObjectStore(newShape) == null && newShape.getObjectArrayCapacity() == 0 || this.getObjectStore(newShape) != null && this.getObjectStore(newShape).length == newShape.getObjectArrayCapacity());
        if (newShape.hasPrimitiveArray()) assert (this.getPrimitiveStore(newShape) == null && newShape.getPrimitiveArrayCapacity() == 0 || this.getPrimitiveStore(newShape) != null && this.getPrimitiveStore(newShape).length == newShape.getPrimitiveArrayCapacity());
        return true;
    }

    @Override
    protected final DynamicObject cloneWithShape(Shape currentShape) {
        assert (this.getShape() == currentShape);
        DynamicObjectBasic clone = (DynamicObjectBasic)super.clone();
        if (this.getObjectStore(currentShape) != null) {
            clone.setObjectStore((Object[])this.getObjectStore(currentShape).clone(), currentShape);
        }
        if (currentShape.hasPrimitiveArray() && this.getPrimitiveStore(currentShape) != null) {
            clone.setPrimitiveStore((long[])this.getPrimitiveStore(currentShape).clone(), currentShape);
        }
        return clone;
    }

    protected final void reshape(ShapeImpl newShape) {
        reshapeCount.inc();
        ShapeImpl oldShape = this.getShape();
        ShapeImpl commonAncestor = ShapeImpl.findCommonAncestor(oldShape, newShape);
        if (ObjectStorageOptions.TraceReshape) {
            int limit = 150;
            System.out.printf("RESHAPE\nOLD %s\nNEW %s\nLCA %s\nDIFF %s\n---\n", oldShape.toStringLimit(limit), newShape.toStringLimit(limit), commonAncestor.toStringLimit(limit), ShapeImpl.diff(oldShape, newShape));
        }
        DynamicObject original = this.cloneWithShape(oldShape);
        this.setShapeAndGrow(oldShape, newShape);
        assert (!newShape.hasPrimitiveArray() || newShape.getPrimitiveArrayCapacity() != 0 || this.getPrimitiveStore(newShape) == null);
        this.copyProperties(original, commonAncestor);
        assert (this.checkExtensionArrayInvariants(newShape));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface DynamicField {
    }
}

