/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.SuperNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.arguments.CheckArityNode;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.arguments.ShouldDestructureNode;
import org.jruby.truffle.nodes.cast.ArrayCastNode;
import org.jruby.truffle.nodes.cast.ArrayCastNodeGen;
import org.jruby.truffle.nodes.control.IfNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.dispatch.RespondToNode;
import org.jruby.truffle.nodes.locals.FlipFlopStateNode;
import org.jruby.truffle.nodes.locals.WriteLocalVariableNode;
import org.jruby.truffle.nodes.methods.BlockDefinitionNode;
import org.jruby.truffle.nodes.methods.CatchForLambdaNode;
import org.jruby.truffle.nodes.methods.CatchForMethodNode;
import org.jruby.truffle.nodes.methods.CatchForProcNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.nodes.supercall.GeneralSuperCallNode;
import org.jruby.truffle.nodes.supercall.GeneralSuperReCallNode;
import org.jruby.truffle.nodes.supercall.ZSuperOutsideMethodNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.LoadArgumentsTranslator;
import org.jruby.truffle.translator.ParameterCollector;
import org.jruby.truffle.translator.ReloadArgumentsTranslator;
import org.jruby.truffle.translator.TranslatorEnvironment;

public class MethodTranslator
extends BodyTranslator {
    private final ArgsNode argsNode;
    private boolean isBlock;

    public MethodTranslator(com.oracle.truffle.api.nodes.Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, boolean isBlock, Source source, ArgsNode argsNode) {
        super(currentNode, context, parent, environment, source, false);
        this.isBlock = isBlock;
        this.argsNode = argsNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockDefinitionNode compileBlockNode(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo, ProcNodes.Type type) {
        RubyNode preludeProc;
        RubyNode body;
        this.declareArguments(sourceSection, methodName, sharedMethodInfo);
        Arity arity = MethodTranslator.getArity(this.argsNode);
        Arity arityForCheck = this.argsNode.getRestArgNode() instanceof UnnamedRestArgNode && !((UnnamedRestArgNode)this.argsNode.getRestArgNode()).isStar() ? arity.withRest(false) : arity;
        this.parentSourceSection.push(sourceSection);
        try {
            body = this.translateNodeOrNil(sourceSection, bodyNode);
        }
        finally {
            this.parentSourceSection.pop();
        }
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, this.isBlock, this);
        RubyNode loadArguments = (RubyNode)this.argsNode.accept((NodeVisitor)loadArgumentsTranslator);
        if (this.shouldConsiderDestructuringArrayArg(arity)) {
            ReadPreArgumentNode readArrayNode = new ReadPreArgumentNode(this.context, sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR);
            ArrayCastNode castArrayNode = ArrayCastNodeGen.create(this.context, sourceSection, readArrayNode);
            FrameSlot arraySlot = this.environment.declareVar(this.environment.allocateLocalTemp("destructure"));
            WriteLocalVariableNode writeArrayNode = new WriteLocalVariableNode(this.context, sourceSection, castArrayNode, arraySlot);
            LoadArgumentsTranslator destructureArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, this.isBlock, this);
            destructureArgumentsTranslator.pushArraySlot(arraySlot);
            RubyNode newDestructureArguments = (RubyNode)this.argsNode.accept((NodeVisitor)destructureArgumentsTranslator);
            preludeProc = new IfNode(this.context, sourceSection, new ShouldDestructureNode(this.context, sourceSection, new RespondToNode(this.context, sourceSection, readArrayNode, "to_ary")), SequenceNode.sequence(this.context, sourceSection, writeArrayNode, newDestructureArguments), loadArguments);
        } else {
            preludeProc = loadArguments;
        }
        RubyNode preludeLambda = SequenceNode.sequence(this.context, sourceSection, CheckArityNode.create(this.context, sourceSection, arityForCheck), NodeUtil.cloneNode(loadArguments));
        CatchForProcNode bodyProc = new CatchForProcNode(this.context, sourceSection, this.composeBody(preludeProc, body));
        RubyRootNode newRootNodeForProcs = new RubyRootNode(this.context, sourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), bodyProc, this.environment.needsDeclarationFrame());
        CatchForLambdaNode bodyLambda = new CatchForLambdaNode(this.context, sourceSection, this.composeBody(preludeLambda, body), this.environment.getReturnID());
        RubyRootNode newRootNodeForLambdas = new RubyRootNode(this.context, sourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), bodyLambda, this.environment.needsDeclarationFrame());
        RootCallTarget callTargetAsProc = Truffle.getRuntime().createCallTarget(newRootNodeForProcs);
        RootCallTarget callTargetAsLambda = Truffle.getRuntime().createCallTarget(newRootNodeForLambdas);
        return new BlockDefinitionNode(this.context, sourceSection, type, this.environment.getSharedMethodInfo(), callTargetAsProc, callTargetAsLambda, this.environment.getBreakID());
    }

    private boolean shouldConsiderDestructuringArrayArg(Arity arity) {
        if (!arity.hasRest() && arity.getOptional() == 0 && arity.getRequired() <= 1) {
            return false;
        }
        return !arity.hasRest() || arity.getRequired() != 0;
    }

    private RubyNode composeBody(RubyNode prelude, RubyNode body) {
        SourceSection sourceSection = body.getSourceSection();
        body = SequenceNode.sequence(this.context, sourceSection, prelude, body);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = SequenceNode.sequence(this.context, sourceSection, this.initFlipFlopStates(sourceSection), body);
        }
        return body;
    }

    public RubyNode compileMethodBody(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        return this.doCompileMethodBody(sourceSection, methodName, bodyNode, sharedMethodInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode doCompileMethodBody(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode body;
        this.declareArguments(sourceSection, methodName, sharedMethodInfo);
        Arity arity = MethodTranslator.getArity(this.argsNode);
        this.parentSourceSection.push(sourceSection);
        try {
            body = this.translateNodeOrNil(sourceSection, bodyNode);
        }
        finally {
            this.parentSourceSection.pop();
        }
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, this.isBlock, this);
        RubyNode loadArguments = (RubyNode)this.argsNode.accept((NodeVisitor)loadArgumentsTranslator);
        RubyNode prelude = this.usesRubiniusPrimitive ? loadArguments : SequenceNode.sequence(this.context, sourceSection, CheckArityNode.create(this.context, sourceSection, arity), loadArguments);
        body = SequenceNode.sequence(this.context, sourceSection, prelude, body);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = SequenceNode.sequence(this.context, sourceSection, this.initFlipFlopStates(sourceSection), body);
        }
        body = new CatchForMethodNode(this.context, sourceSection, body, this.environment.getReturnID());
        body = new ExceptionTranslatingNode(this.context, sourceSection, body);
        return body;
    }

    public MethodDefinitionNode compileMethodNode(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode body = this.compileMethodBody(sourceSection, methodName, bodyNode, sharedMethodInfo);
        RubyRootNode rootNode = new RubyRootNode(this.context, sourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body, this.environment.needsDeclarationFrame());
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(rootNode);
        return new MethodDefinitionNode(this.context, sourceSection, methodName, this.environment.getSharedMethodInfo(), callTarget);
    }

    private void declareArguments(SourceSection sourceSection, String methodName, SharedMethodInfo sharedMethodInfo) {
        ParameterCollector parameterCollector = new ParameterCollector();
        this.argsNode.accept((NodeVisitor)parameterCollector);
        for (String parameter : parameterCollector.getParameters()) {
            this.environment.declareVar(parameter);
        }
    }

    public static Arity getArity(ArgsNode argsNode) {
        String[] keywordArguments;
        if (argsNode.hasKwargs() && argsNode.getKeywords() != null) {
            Node[] keywordNodes = argsNode.getKeywords().children();
            int keywordsCount = keywordNodes.length;
            keywordArguments = new String[keywordsCount];
            for (int i = 0; i < keywordsCount; ++i) {
                KeywordArgNode kwarg = (KeywordArgNode)keywordNodes[i];
                AssignableNode assignableNode = kwarg.getAssignable();
                if (assignableNode instanceof LocalAsgnNode) {
                    keywordArguments[i] = ((LocalAsgnNode)assignableNode).getName();
                    continue;
                }
                if (assignableNode instanceof DAsgnNode) {
                    keywordArguments[i] = ((DAsgnNode)assignableNode).getName();
                    continue;
                }
                throw new UnsupportedOperationException("unsupported keyword arg " + kwarg);
            }
        } else {
            keywordArguments = Arity.NO_KEYWORDS;
        }
        return new Arity(argsNode.getPreCount(), argsNode.getOptionalArgsCount(), argsNode.hasRestArg(), argsNode.getPostCount(), keywordArguments, argsNode.hasKeyRest());
    }

    public RubyNode visitSuperNode(SuperNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        BodyTranslator.ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, node.getIterNode(), node.getArgsNode(), this.environment.getNamedMethodName());
        return new GeneralSuperCallNode(this.context, sourceSection, argumentsAndBlock.getBlock(), argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted());
    }

    public RubyNode visitZSuperNode(ZSuperNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.environment.isBlock()) {
            this.environment.setNeedsDeclarationFrame();
        }
        this.currentCallMethodName = this.environment.getNamedMethodName();
        RubyNode blockNode = node.getIterNode() != null ? (RubyNode)node.getIterNode().accept((NodeVisitor)this) : null;
        boolean insideDefineMethod = false;
        MethodTranslator methodArgumentsTranslator = this;
        while (methodArgumentsTranslator.isBlock) {
            if (!(methodArgumentsTranslator.parent instanceof MethodTranslator)) {
                return new ZSuperOutsideMethodNode(this.context, sourceSection, insideDefineMethod);
            }
            if (methodArgumentsTranslator.currentCallMethodName.equals("define_method")) {
                insideDefineMethod = true;
            }
            methodArgumentsTranslator = (MethodTranslator)methodArgumentsTranslator.parent;
        }
        ReloadArgumentsTranslator reloadTranslator = new ReloadArgumentsTranslator(this.currentNode, this.context, this.source, this);
        ArgsNode argsNode = methodArgumentsTranslator.argsNode;
        SequenceNode reloadSequence = (SequenceNode)reloadTranslator.visitArgsNode(argsNode);
        return new GeneralSuperReCallNode(this.context, sourceSection, reloadTranslator.isSplatted(), reloadSequence.getSequence(), blockNode);
    }

    @Override
    protected FlipFlopStateNode createFlipFlopState(SourceSection sourceSection, int depth) {
        if (this.isBlock) {
            this.environment.setNeedsDeclarationFrame();
            return this.parent.createFlipFlopState(sourceSection, depth + 1);
        }
        return super.createFlipFlopState(sourceSection, depth);
    }

    public TranslatorState getCurrentState() {
        return new TranslatorState(this.getEnvironment().getLexicalScope(), new ArrayDeque(this.parentSourceSection));
    }

    public void restoreState(TranslatorState state) {
        this.getEnvironment().getParseEnvironment().resetLexicalScope(state.scope);
        this.parentSourceSection = state.parentSourceSection;
    }

    public static class TranslatorState {
        private final LexicalScope scope;
        private final Deque<SourceSection> parentSourceSection;

        private TranslatorState(LexicalScope scope, Deque<SourceSection> parentSourceSection) {
            this.scope = scope;
            this.parentSourceSection = parentSourceSection;
        }
    }
}

