/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.List;
import org.jruby.EvalType;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ast.RootNode;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.IRTranslator;
import org.jruby.ir.interpreter.BeginEndInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class Interpreter
extends IRTranslator<IRubyObject, IRubyObject> {
    public static final Logger LOG = LoggerFactory.getLogger("Interpreter");
    public static final String ROOT = "(root)";
    static int interpInstrsCount = 0;

    public static void dumpStats() {
        if ((IRRuntimeHelpers.isDebug() || IRRuntimeHelpers.inProfileMode()) && interpInstrsCount > 10000) {
            LOG.info("-- Interpreted instructions: {}", interpInstrsCount);
        }
    }

    public static void runBeginBlocks(List<IRClosure> beBlocks, ThreadContext context, IRubyObject self2, StaticScope currScope, Object[] temp) {
        if (beBlocks == null) {
            return;
        }
        for (IRClosure b2 : beBlocks) {
            Block blk = (Block)new WrappedIRClosure(b2.getSelf(), b2).retrieve(context, self2, currScope, context.getCurrentScope(), temp);
            blk.yield(context, null);
        }
    }

    @Override
    protected IRubyObject execute(Ruby runtime, IRScriptBody irScope, IRubyObject self2) {
        StaticScope scope;
        RubyModule currModule;
        BeginEndInterpreterContext ic = (BeginEndInterpreterContext)irScope.getInterpreterContext();
        ThreadContext context = runtime.getCurrentContext();
        String name2 = ROOT;
        if (IRRuntimeHelpers.isDebug()) {
            LOG.info("Executing " + ic, new Object[0]);
        }
        if ((currModule = (scope = ic.getStaticScope()).getModule()) == null) {
            currModule = context.getRuntime().getObject();
        }
        scope.setModule(currModule);
        DynamicScope tlbScope = irScope.getToplevelScope();
        if (tlbScope == null) {
            context.preMethodScopeOnly(scope);
        } else {
            context.preScopedBody(tlbScope);
            tlbScope.growIfNeeded();
        }
        context.setCurrentVisibility(Visibility.PRIVATE);
        try {
            Interpreter.runBeginBlocks(ic.getBeginBlocks(), context, self2, scope, null);
            IRubyObject iRubyObject = Interpreter.INTERPRET_ROOT(context, self2, ic, currModule, name2);
            return iRubyObject;
        }
        catch (IRBreakJump bj) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
        finally {
            Interpreter.dumpStats();
            context.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_ROOT(ThreadContext context, IRubyObject self2, InterpreterContext ic, RubyModule clazz, String name2) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, clazz, name2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK, null);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(ThreadContext context, IRubyObject self2, InterpreterContext ic, RubyModule clazz, IRubyObject[] args2, String name2, Block block, Block.Type blockType) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, clazz, name2, args2, block, blockType);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_BLOCK(ThreadContext context, IRubyObject self2, InterpreterContext ic, IRubyObject[] args2, String name2, Block block, Block.Type blockType) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, null, name2, args2, block, blockType);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalSimple(ThreadContext context, RubyModule under, IRubyObject self2, RubyString src, String file2, int lineNumber, EvalType evalType) {
        Ruby runtime = context.runtime;
        if (runtime.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.TRUFFLE) {
            throw new UnsupportedOperationException();
        }
        DynamicScope parentScope = context.getCurrentScope();
        ManyVarsDynamicScope evalScope = new ManyVarsDynamicScope(runtime.getStaticScopeFactory().newEvalScope(parentScope.getStaticScope()), parentScope);
        evalScope.getStaticScope().setModule(under);
        context.pushEvalSimpleFrame(self2);
        try {
            IRubyObject iRubyObject = Interpreter.evalCommon(context, evalScope, self2, src, file2, lineNumber, "(eval)", Block.NULL_BLOCK, evalType);
            return iRubyObject;
        }
        finally {
            context.popFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject evalCommon(ThreadContext context, DynamicScope evalScope, IRubyObject self2, IRubyObject src, String file2, int lineNumber, String name2, Block block, EvalType evalType) {
        StaticScope ss = evalScope.getStaticScope();
        BeginEndInterpreterContext ic = Interpreter.prepareIC(context, evalScope, src, file2, lineNumber, evalType);
        evalScope.setEvalType(evalType);
        context.pushScope(evalScope);
        try {
            evalScope.growIfNeeded();
            Interpreter.runBeginBlocks(ic.getBeginBlocks(), context, self2, ss, null);
            IRubyObject iRubyObject = Interpreter.INTERPRET_EVAL(context, self2, ic, ic.getStaticScope().getModule(), IRubyObject.NULL_ARRAY, name2, block, null);
            return iRubyObject;
        }
        finally {
            evalScope.clearEvalType();
            context.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject self2, IRubyObject src, Binding binding2) {
        Ruby runtime = context.runtime;
        if (runtime.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.TRUFFLE) {
            throw new UnsupportedOperationException();
        }
        DynamicScope evalScope = binding2.getEvalScope(runtime);
        evalScope.getStaticScope().determineModule();
        Frame lastFrame = context.preEvalWithBinding(binding2);
        try {
            IRubyObject iRubyObject = Interpreter.evalCommon(context, evalScope, self2, src, binding2.getFile(), binding2.getLine(), binding2.getMethod(), binding2.getFrame().getBlock(), EvalType.BINDING_EVAL);
            return iRubyObject;
        }
        finally {
            context.postEvalWithBinding(binding2, lastFrame);
        }
    }

    private static BeginEndInterpreterContext prepareIC(ThreadContext context, DynamicScope evalScope, IRubyObject src, String file2, int lineNumber, EvalType evalType) {
        Ruby runtime = context.runtime;
        IRScope containingIRScope = evalScope.getStaticScope().getEnclosingScope().getIRScope();
        RootNode rootNode = (RootNode)runtime.parseEval(src.convertToString().getByteList(), file2, evalScope, lineNumber);
        StaticScope staticScope = evalScope.getStaticScope();
        IREvalScript script = new IREvalScript(runtime.getIRManager(), containingIRScope, file2, lineNumber, staticScope, evalType);
        staticScope.setIRScope(script);
        BeginEndInterpreterContext ic = (BeginEndInterpreterContext)IRBuilder.topIRBuilder(runtime.getIRManager(), script).buildEvalRoot(rootNode);
        if (IRRuntimeHelpers.isDebug()) {
            LOG.info(script.debugOutput(), new Object[0]);
        }
        return ic;
    }
}

