/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public abstract class CommonLocator
implements ILocator,
Serializable {
    static final long serialVersionUID = 1L;
    private boolean readOnly = false;

    protected ILocator createTempFileLocator() throws IOException {
        File file = TempTools.createTempFile("locator", ".tmp");
        file.deleteOnExit();
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = this.getInputStream();
            fileOutputStream = new FileOutputStream(file);
            StreamTools.copyStream(inputStream, false, fileOutputStream, false);
        }
        catch (Throwable throwable) {
            StreamTools.close(inputStream);
            StreamTools.close(fileOutputStream);
            throw throwable;
        }
        StreamTools.close(inputStream);
        StreamTools.close(fileOutputStream);
        FileLocator fileLocator = new FileLocator(file);
        fileLocator.setReadOnly();
        return fileLocator;
    }

    @Override
    public void delete() throws IOException {
        throw new IOException("unsupported operation");
    }

    @Override
    public long getLength() throws IOException {
        return -1L;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void rename(String string) throws IOException {
        throw new IOException("unsupported operation");
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }
}

