/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.io.ConservativeSizingByteArrayOutputStream;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.CrossReference;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.HexStringObject;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.ObjectStream;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.fonts.FontDescriptor;
import org.icepdf.core.pobjects.fonts.FontFactory;
import org.icepdf.core.pobjects.graphics.TilingPattern;
import org.icepdf.core.util.Library;

public class Parser {
    private static final Logger logger = Logger.getLogger(Parser.class.toString());
    public static final int PARSE_MODE_NORMAL = 0;
    public static final int PARSE_MODE_OBJECT_STREAM = 1;
    private InputStream reader;
    boolean lastTokenHString = false;
    private Stack<Object> stack = new Stack();
    private int parseMode;

    public Parser(SeekableInput r) {
        this(r, 0);
    }

    public Parser(SeekableInput r, int pm) {
        this.reader = r.getInputStream();
        this.parseMode = pm;
    }

    public Parser(InputStream r) {
        this(r, 0);
    }

    public Parser(InputStream r, int pm) {
        this.reader = new BufferedInputStream(r);
        this.parseMode = pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Library library) throws PDFException {
        int deepnessCount = 0;
        boolean inObject = false;
        boolean complete = false;
        Reference objectReference = null;
        try {
            do {
                Object nextToken;
                try {
                    nextToken = this.getToken();
                }
                catch (IOException e) {
                    return null;
                }
                if (nextToken instanceof StringObject || nextToken instanceof Name || nextToken instanceof Number) {
                    if (nextToken instanceof StringObject) {
                        StringObject tmp = (StringObject)nextToken;
                        tmp.setReference(objectReference);
                    }
                    this.stack.push(nextToken);
                } else if (nextToken.equals("obj")) {
                    if (inObject) {
                        this.stack.pop();
                        this.stack.pop();
                        return this.addPObject(library, objectReference);
                    }
                    deepnessCount = 1;
                    inObject = true;
                    Number generationNumber = (Number)this.stack.pop();
                    Number objectNumber = (Number)this.stack.pop();
                    objectReference = new Reference(objectNumber, generationNumber);
                } else {
                    if (nextToken.equals("endobj")) {
                        --deepnessCount;
                        if (inObject) {
                            inObject = false;
                            return this.addPObject(library, objectReference);
                        }
                        return null;
                    }
                    if (nextToken.equals("endstream")) {
                        --deepnessCount;
                        if (inObject) {
                            inObject = false;
                            return this.addPObject(library, objectReference);
                        }
                    } else if (nextToken.equals("stream")) {
                        SeekableInputConstrainedWrapper streamInputWrapper;
                        ++deepnessCount;
                        Hashtable streamHash = (Hashtable)this.stack.pop();
                        int streamLength = library.getInt(streamHash, "Length");
                        try {
                            this.reader.mark(2);
                            int curChar = this.reader.read();
                            if (curChar == 13) {
                                this.reader.mark(1);
                                if (this.reader.read() != 10) {
                                    this.reader.reset();
                                }
                            } else if (curChar != 10) {
                                this.reader.reset();
                            }
                            if (this.reader instanceof SeekableInput) {
                                long lengthOfStreamData;
                                SeekableInput streamDataInput = (SeekableInput)((Object)this.reader);
                                long filePositionOfStreamData = streamDataInput.getAbsolutePosition();
                                if (streamLength > 0) {
                                    lengthOfStreamData = streamLength;
                                    streamDataInput.seekRelative(streamLength);
                                    lengthOfStreamData += this.skipUntilEndstream(null);
                                } else {
                                    lengthOfStreamData = this.captureStreamData(null);
                                }
                                streamInputWrapper = new SeekableInputConstrainedWrapper(streamDataInput, filePositionOfStreamData, lengthOfStreamData, false);
                            } else {
                                ConservativeSizingByteArrayOutputStream out;
                                if (!library.isLinearTraversal() && streamLength > 0) {
                                    int currRead;
                                    byte[] buffer = new byte[streamLength];
                                    for (int totalRead = 0; totalRead < buffer.length && (currRead = this.reader.read(buffer, totalRead, buffer.length - totalRead)) > 0; totalRead += currRead) {
                                    }
                                    out = new ConservativeSizingByteArrayOutputStream(buffer, library.memoryManager);
                                    this.skipUntilEndstream(out);
                                } else {
                                    out = new ConservativeSizingByteArrayOutputStream(16384, library.memoryManager);
                                    this.captureStreamData(out);
                                }
                                int size = out.size();
                                out.trim();
                                byte[] buffer = out.relinquishByteArray();
                                SeekableByteArrayInputStream streamDataInput = new SeekableByteArrayInputStream(buffer);
                                long filePositionOfStreamData = 0L;
                                long lengthOfStreamData = size;
                                streamInputWrapper = new SeekableInputConstrainedWrapper(streamDataInput, filePositionOfStreamData, lengthOfStreamData, true);
                            }
                        }
                        catch (IOException e) {
                            return null;
                        }
                        PTrailer trailer = null;
                        Stream stream = null;
                        Name type = (Name)library.getObject(streamHash, "Type");
                        Name subtype = (Name)library.getObject(streamHash, "Subtype");
                        if (type != null) {
                            if (type.equals("Pattern")) {
                                stream = new TilingPattern(library, streamHash, streamInputWrapper);
                            } else if (type.equals("XRef")) {
                                stream = new Stream(library, streamHash, streamInputWrapper);
                                stream.init();
                                InputStream in = stream.getInputStreamForDecodedStreamBytes();
                                CrossReference xrefStream = new CrossReference();
                                if (in != null) {
                                    try {
                                        xrefStream.addXRefStreamEntries(library, streamHash, in);
                                    }
                                    finally {
                                        try {
                                            in.close();
                                        }
                                        catch (IOException e) {
                                            logger.log(Level.FINE, "Error appending stream entries.", e);
                                        }
                                    }
                                }
                                stream.dispose(false);
                                Hashtable trailerHash = (Hashtable)streamHash.clone();
                                trailer = new PTrailer(library, trailerHash, null, xrefStream);
                            } else if (type.equals("ObjStm")) {
                                stream = new ObjectStream(library, streamHash, streamInputWrapper);
                            }
                        }
                        if (subtype != null && subtype.equals("Form") && !"pattern".equals(type)) {
                            stream = new Form(library, streamHash, streamInputWrapper);
                        }
                        if (trailer != null) {
                            this.stack.push(trailer);
                        } else {
                            if (stream == null) {
                                stream = new Stream(library, streamHash, streamInputWrapper);
                            }
                            this.stack.push(stream);
                        }
                    } else if (nextToken.equals("true")) {
                        this.stack.push(new Boolean(true));
                    } else if (nextToken.equals("false")) {
                        this.stack.push(new Boolean(false));
                    } else if (nextToken.equals("R")) {
                        Number generationNumber = (Number)this.stack.pop();
                        Number objectNumber = (Number)this.stack.pop();
                        this.stack.push(new Reference(objectNumber, generationNumber));
                    } else if (nextToken.equals("[")) {
                        ++deepnessCount;
                        this.stack.push(nextToken);
                    } else if (nextToken.equals("]")) {
                        --deepnessCount;
                        int searchPosition = this.stack.search("[");
                        int size = searchPosition - 1;
                        Vector<Object> v = new Vector<Object>(size > 0 ? size : 1);
                        if (size > 0) {
                            v.setSize(size);
                        }
                        if (searchPosition > 0) {
                            for (int i = size - 1; i >= 0; --i) {
                                Object obj = this.stack.pop();
                                v.set(i, obj);
                            }
                            this.stack.pop();
                        } else {
                            this.stack.clear();
                        }
                        this.stack.push(v);
                    } else if (nextToken.equals("<<")) {
                        ++deepnessCount;
                        this.stack.push(nextToken);
                    } else if (nextToken.equals(">>")) {
                        --deepnessCount;
                        Hashtable<Object, Object> hashTable = new Hashtable<Object, Object>();
                        if (!this.stack.isEmpty()) {
                            Object obj = this.stack.pop();
                            while (!(obj instanceof String && obj.equals("<<") || this.stack.isEmpty())) {
                                Object key = this.stack.pop();
                                hashTable.put(key, obj);
                                if (this.stack.isEmpty()) break;
                                obj = this.stack.pop();
                            }
                            if ((obj = hashTable.get("Type")) != null && obj instanceof Name) {
                                Name n = (Name)obj;
                                if (n.equals("Catalog")) {
                                    this.stack.push(new Catalog(library, hashTable));
                                } else if (n.equals("Pages")) {
                                    this.stack.push(new PageTree(library, hashTable));
                                } else if (n.equals("Page")) {
                                    this.stack.push(new Page(library, hashTable));
                                } else if (n.equals("Font")) {
                                    this.stack.push(FontFactory.getInstance().getFont(library, hashTable));
                                } else if (n.equals("FontDescriptor")) {
                                    this.stack.push(new FontDescriptor(library, hashTable));
                                } else if (n.equals("CMap")) {
                                    this.stack.push(hashTable);
                                } else if (n.equals("Annot")) {
                                    this.stack.push(Annotation.buildAnnotation(library, hashTable));
                                } else {
                                    this.stack.push(hashTable);
                                }
                            } else {
                                this.stack.push(hashTable);
                            }
                            if (deepnessCount == 0) {
                                return this.stack.pop();
                            }
                        }
                    } else if (nextToken.equals("xref")) {
                        CrossReference xrefTable = new CrossReference();
                        xrefTable.addXRefTableEntries(this);
                        this.stack.push(xrefTable);
                    } else {
                        if (nextToken.equals("trailer")) {
                            CrossReference xrefTable = null;
                            if (this.stack.peek() instanceof CrossReference) {
                                xrefTable = (CrossReference)this.stack.pop();
                            }
                            this.stack.clear();
                            Hashtable trailerDictionary = (Hashtable)this.getObject(library);
                            return new PTrailer(library, trailerDictionary, xrefTable, null);
                        }
                        if (!(nextToken instanceof String) || !((String)nextToken).startsWith("%")) {
                            this.stack.push(nextToken);
                        }
                    }
                }
                if (this.parseMode != 1 || deepnessCount != 0 || this.stack.size() <= 0) continue;
                return this.stack.pop();
            } while (!complete);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Fatal error parsing PDF file stream.", e);
            return null;
        }
        return this.stack.pop();
    }

    public PObject addPObject(Library library, Reference objectReference) {
        Object o = this.stack.pop();
        if (o instanceof Stream) {
            Stream tmp = (Stream)o;
            tmp.setPObjectReference(objectReference);
        } else if (o instanceof Dictionary) {
            Dictionary tmp = (Dictionary)o;
            tmp.setPObjectReference(objectReference);
        }
        library.addObject(o, objectReference);
        return new PObject(o, objectReference);
    }

    public Object getStreamObject() throws IOException {
        Cloneable o = this.getToken();
        if (o instanceof String) {
            if (((Object)o).equals("<<")) {
                Hashtable<Object, Object> h = new Hashtable<Object, Object>();
                Object o1 = this.getStreamObject();
                while (!o1.equals(">>")) {
                    h.put(o1, this.getStreamObject());
                    o1 = this.getStreamObject();
                }
                o = h;
            } else if (((Object)o).equals("[")) {
                Vector<Object> v = new Vector<Object>();
                Object o1 = this.getStreamObject();
                while (!o1.equals("]")) {
                    v.addElement(o1);
                    o1 = this.getStreamObject();
                }
                v.trimToSize();
                o = v;
            }
        }
        return o;
    }

    public Object getToken() throws IOException {
        int currentByte;
        char currentChar;
        boolean inString = false;
        boolean hexString = false;
        this.lastTokenHString = false;
        do {
            if ((currentByte = this.reader.read()) >= 0) continue;
            throw new IOException();
        } while (Parser.isWhitespace(currentChar = (char)currentByte));
        if (currentChar == '(') {
            inString = true;
        } else {
            if (currentChar == ']') {
                return "]";
            }
            if (currentChar == '[') {
                return "[";
            }
            if (currentChar == '%') {
                StringBuilder stringBuffer = new StringBuilder();
                do {
                    stringBuffer.append(currentChar);
                    currentByte = this.reader.read();
                    if (currentByte >= 0) continue;
                    if (stringBuffer.length() > 0) {
                        return stringBuffer.toString();
                    }
                    throw new IOException();
                } while ((currentChar = (char)currentByte) != '\r' && currentChar != '\n');
                return stringBuffer.toString();
            }
        }
        this.reader.mark(1);
        char nextChar = (char)this.reader.read();
        if (currentChar == '>' && nextChar == '>') {
            return ">>";
        }
        if (currentChar == '<') {
            if (nextChar == '<') {
                return "<<";
            }
            inString = true;
            hexString = true;
        }
        this.reader.reset();
        StringBuilder stringBuffer = new StringBuilder();
        if (!inString) {
            if (currentChar < '\u0080') {
                stringBuffer.append(currentChar);
            }
            if (currentChar == 'Q' || currentChar == 'q') {
                this.reader.read();
                return stringBuffer.toString();
            }
        } else {
            stringBuffer.append(currentChar);
        }
        int parenthesisCount = 0;
        boolean complete = false;
        boolean ignoreChar = false;
        do {
            block42: {
                block40: {
                    block49: {
                        block48: {
                            block47: {
                                block46: {
                                    block45: {
                                        block44: {
                                            block43: {
                                                block41: {
                                                    if (!inString) {
                                                        this.reader.mark(1);
                                                    }
                                                    if (!inString && !hexString && currentChar != 'd' && currentChar > 'A' && nextChar >= '0' && nextChar <= '9' && stringBuffer.charAt(0) != '/') {
                                                        this.reader.reset();
                                                        break;
                                                    }
                                                    currentByte = this.reader.read();
                                                    if (currentByte < 0) {
                                                        return stringBuffer.toString();
                                                    }
                                                    currentChar = (char)currentByte;
                                                    if (!inString) break block40;
                                                    if (!hexString) break block41;
                                                    if (currentChar == '>') {
                                                        complete = true;
                                                        stringBuffer.append(currentChar);
                                                        break;
                                                    }
                                                    break block42;
                                                }
                                                if (currentChar == '(') {
                                                    ++parenthesisCount;
                                                }
                                                if (currentChar == ')') {
                                                    if (parenthesisCount == 0) {
                                                        complete = true;
                                                        stringBuffer.append(currentChar);
                                                        break;
                                                    }
                                                    --parenthesisCount;
                                                }
                                                if (currentChar != '\\') break block42;
                                                currentChar = (char)this.reader.read();
                                                if (!Character.isDigit(currentChar)) break block43;
                                                StringBuilder digit = new StringBuilder();
                                                digit.append(currentChar);
                                                for (int i = 0; i < 2; ++i) {
                                                    this.reader.mark(1);
                                                    currentChar = (char)this.reader.read();
                                                    if (!Character.isDigit(currentChar)) {
                                                        this.reader.reset();
                                                        break;
                                                    }
                                                    digit.append(currentChar);
                                                }
                                                int charNumber = 0;
                                                try {
                                                    charNumber = Integer.parseInt(digit.toString(), 8);
                                                }
                                                catch (NumberFormatException e) {
                                                    logger.log(Level.FINE, "Integer parse error ", e);
                                                }
                                                currentChar = (char)charNumber;
                                                break block42;
                                            }
                                            if (currentChar == '(' || currentChar == ')' || currentChar == '\\') break block42;
                                            if (currentChar != 't') break block44;
                                            currentChar = '\t';
                                            break block42;
                                        }
                                        if (currentChar != 114) break block45;
                                        currentChar = '\r';
                                        break block42;
                                    }
                                    if (currentChar != 110) break block46;
                                    currentChar = '\n';
                                    break block42;
                                }
                                if (currentChar != 98) break block47;
                                currentChar = '\b';
                                break block42;
                            }
                            if (currentChar != 102) break block48;
                            currentChar = '\f';
                            break block42;
                        }
                        if (currentChar != 13) break block49;
                        ignoreChar = true;
                        break block42;
                    }
                    if (!logger.isLoggable(Level.FINE)) break block42;
                    logger.warning("C=" + currentChar);
                    break block42;
                }
                if (Parser.isWhitespace(currentChar)) {
                    if (currentByte != 13 && currentByte != 10) break;
                    this.reader.reset();
                    break;
                }
                if (Parser.isDelimiter(currentChar)) {
                    this.reader.reset();
                    break;
                }
            }
            if (!ignoreChar) {
                if (inString) {
                    stringBuffer.append(currentChar);
                    continue;
                }
                if (currentChar >= '\u0080') continue;
                stringBuffer.append(currentChar);
                continue;
            }
            ignoreChar = false;
        } while (!complete);
        if (hexString) {
            this.lastTokenHString = true;
            return new HexStringObject(stringBuffer);
        }
        if (inString) {
            return new LiteralStringObject(stringBuffer);
        }
        if (stringBuffer.charAt(0) == '/') {
            return new Name(stringBuffer.deleteCharAt(0));
        }
        boolean foundDigit = false;
        boolean foundDecimal = false;
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            char curr = stringBuffer.charAt(i);
            if (curr == '.') {
                foundDecimal = true;
                continue;
            }
            if (curr < '0' || curr > '9') continue;
            foundDigit = true;
        }
        if (foundDigit) {
            try {
                if (foundDecimal) {
                    return Float.valueOf(stringBuffer.toString());
                }
                return Integer.valueOf(stringBuffer.toString());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    public Object getNumberOrStringWithMark(int maxLength) throws IOException {
        int curr;
        this.reader.mark(maxLength);
        StringBuilder sb = new StringBuilder(maxLength);
        boolean readNonWhitespaceYet = false;
        boolean foundDigit = false;
        boolean foundDecimal = false;
        for (int i = 0; i < maxLength && (curr = this.reader.read()) >= 0; ++i) {
            char currChar = (char)curr;
            if (Parser.isWhitespace(currChar)) {
                if (!readNonWhitespaceYet) continue;
                break;
            }
            if (Parser.isDelimiter(currChar)) {
                this.reader.reset();
                this.reader.mark(maxLength);
                for (int j = 0; j < i; ++j) {
                    this.reader.read();
                }
                readNonWhitespaceYet = true;
                break;
            }
            readNonWhitespaceYet = true;
            if (currChar == '.') {
                foundDecimal = true;
            } else if (currChar >= '0' && curr <= 57) {
                foundDigit = true;
            }
            sb.append(currChar);
        }
        if (foundDigit) {
            try {
                if (foundDecimal) {
                    return Float.valueOf(sb.toString());
                }
                return Integer.valueOf(sb.toString());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public void ungetNumberOrStringWithReset() throws IOException {
        this.reader.reset();
    }

    public int getIntSurroundedByWhitespace() {
        int num = 0;
        boolean makeNegative = false;
        boolean readNonWhitespace = false;
        try {
            int curr;
            while ((curr = this.reader.read()) >= 0) {
                if (Character.isWhitespace((char)curr)) {
                    if (!readNonWhitespace) continue;
                    break;
                }
                if (curr == 45) {
                    makeNegative = true;
                    readNonWhitespace = true;
                    continue;
                }
                if (curr < 48 || curr > 57) continue;
                num *= 10;
                num += curr - 48;
                readNonWhitespace = true;
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error detecting int.", e);
        }
        if (makeNegative) {
            num *= -1;
        }
        return num;
    }

    public long getLongSurroundedByWhitespace() {
        long num = 0L;
        boolean makeNegative = false;
        boolean readNonWhitespace = false;
        try {
            int curr;
            while ((curr = this.reader.read()) >= 0) {
                if (Character.isWhitespace((char)curr)) {
                    if (!readNonWhitespace) continue;
                    break;
                }
                if (curr == 45) {
                    makeNegative = true;
                    readNonWhitespace = true;
                    continue;
                }
                if (curr < 48 || curr > 57) continue;
                num *= 10L;
                num += (long)(curr - 48);
                readNonWhitespace = true;
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error detecting long.", e);
        }
        if (makeNegative) {
            num *= -1L;
        }
        return num;
    }

    public char getCharSurroundedByWhitespace() {
        char alpha = '\u0000';
        try {
            int curr;
            while ((curr = this.reader.read()) >= 0) {
                char c = (char)curr;
                if (Character.isWhitespace(c)) continue;
                alpha = c;
                break;
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error detecting char.", e);
        }
        return alpha;
    }

    int hexToInt(String hex) {
        hex = hex.substring(1, hex.length() - 1).toUpperCase();
        return Integer.parseInt(hex, 16);
    }

    String hexToString(String hh) {
        hh = hh.substring(1, hh.length() - 1).toUpperCase();
        StringBuilder sb = new StringBuilder();
        if (hh.charAt(0) == 'F' && hh.charAt(1) == 'E' && hh.charAt(2) == 'F' && hh.charAt(3) == 'F') {
            byte[] b = new byte[4];
            for (int i = 1; i < hh.length() / 4; ++i) {
                b[0] = (byte)hh.charAt(i * 4);
                b[1] = (byte)hh.charAt(i * 4 + 1);
                b[2] = (byte)hh.charAt(i * 4 + 2);
                b[3] = (byte)hh.charAt(i * 4 + 3);
                sb.append((char)Integer.parseInt(new String(b), 16));
            }
        } else {
            byte[] b = new byte[2];
            for (int i = 0; i < hh.length() / 2; ++i) {
                try {
                    b[0] = (byte)hh.charAt(i * 2);
                    b[1] = (byte)hh.charAt(i * 2 + 1);
                    sb.append((char)Short.parseShort(new String(b), 16));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return sb.toString();
    }

    boolean readLineForInlineImage(OutputStream out) throws IOException {
        int c;
        boolean STATE_PRE_E = false;
        boolean STATE_PRE_I = true;
        int STATE_PRE_WHITESPACE = 2;
        int state = 0;
        while ((c = this.reader.read()) >= 0) {
            if (state == 0 && c == 69) {
                ++state;
                continue;
            }
            if (state == 1 && c == 73) {
                ++state;
                continue;
            }
            if (state == 2 && Parser.isWhitespace((char)(0xFF & c))) {
                boolean imageDataFound = Parser.isStillInlineImageData(this.reader, 32);
                if (imageDataFound) {
                    out.write(69);
                    out.write(73);
                    out.write(c);
                    state = 0;
                    if (c != 13 && c != 10) continue;
                    break;
                }
                return true;
            }
            if (state > 0) {
                out.write(69);
            }
            if (state > 1) {
                out.write(73);
            }
            state = 0;
            out.write((byte)c);
            if (c != 13 && c != 10) continue;
            break;
        }
        return state == 2;
    }

    byte readByte() throws IOException {
        return (byte)this.reader.read();
    }

    public static final boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f';
    }

    private static final boolean isDelimiter(char c) {
        return c == '[' || c == ']' || c == '(' || c == ')' || c == '<' || c == '>' || c == '{' || c == '}' || c == '/' || c == '%';
    }

    private static boolean isExpectedInContentStream(char c) {
        return c >= 'a' && c <= 'Z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Parser.isWhitespace(c) || Parser.isDelimiter(c) || c == '\\' || c == '\'' || c == '\"' || c == '*' || c == '.';
    }

    private static boolean isStillInlineImageData(InputStream reader, int numBytesToCheck) throws IOException {
        boolean imageDataFound = false;
        boolean onlyWhitespaceSoFar = true;
        reader.mark(numBytesToCheck);
        byte[] toCheck = new byte[numBytesToCheck];
        int numReadToCheck = reader.read(toCheck);
        for (int i = 0; i < numReadToCheck; ++i) {
            boolean typicalTextTokenInContentStream;
            char charToCheck = (char)(toCheck[i] & 0xFF);
            boolean bl = typicalTextTokenInContentStream = charToCheck == 'Q' || charToCheck == 'q' || charToCheck == 'S' || charToCheck == 's';
            if (onlyWhitespaceSoFar && typicalTextTokenInContentStream && i + 1 < numReadToCheck && Parser.isWhitespace((char)(toCheck[i + 1] & 0xFF))) break;
            if (!Parser.isWhitespace(charToCheck)) {
                onlyWhitespaceSoFar = false;
            }
            if (Parser.isExpectedInContentStream(charToCheck)) continue;
            imageDataFound = true;
            break;
        }
        reader.reset();
        return imageDataFound;
    }

    String peek2() throws IOException {
        this.reader.mark(2);
        char[] c = new char[]{(char)this.reader.read(), (char)this.reader.read()};
        String s = new String(c);
        this.reader.reset();
        return s;
    }

    private long captureStreamData(OutputStream out) throws IOException {
        long numBytes = 0L;
        while (true) {
            int nextByte;
            if ((nextByte = this.reader.read()) == 101) {
                this.reader.mark(10);
                if (this.reader.read() == 110 && this.reader.read() == 100 && this.reader.read() == 115 && this.reader.read() == 116 && this.reader.read() == 114 && this.reader.read() == 101 && this.reader.read() == 97 && this.reader.read() == 109) break;
                this.reader.reset();
            } else if (nextByte < 0) break;
            if (out != null) {
                out.write(nextByte);
            }
            ++numBytes;
        }
        return numBytes;
    }

    private long skipUntilEndstream(OutputStream out) throws IOException {
        long skipped = 0L;
        while (true) {
            this.reader.mark(10);
            int nextByte = this.reader.read();
            if (nextByte == 101 && this.reader.read() == 110 && this.reader.read() == 100 && this.reader.read() == 115 && this.reader.read() == 116 && this.reader.read() == 114 && this.reader.read() == 101 && this.reader.read() == 97 && this.reader.read() == 109) {
                this.reader.reset();
                break;
            }
            if (nextByte < 0) break;
            if (nextByte == 10 || nextByte == 13 || nextByte == 32) continue;
            if (out != null) {
                out.write(nextByte);
            }
            ++skipped;
        }
        return skipped;
    }
}

