/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.StandardCryptHandler;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESCryptHandler
extends StandardCryptHandler {
    public static final String KEY_ALGORITHM = "AES";
    public static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final String DIGEST_ALGORITHM = "MD5";
    private int blockSize;

    @Override
    protected synchronized byte[] basicDecrypt(byte[] byArray, byte[] byArray2, int n, int n2) throws COSSecurityException {
        try {
            this.updateHash(byArray2, n, n2);
            byte[] byArray3 = this.md.digest();
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray, 0, this.blockSize);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, 0, this.length, KEY_ALGORITHM);
            this.cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            return this.cipher.doFinal(byArray, this.blockSize, byArray.length - this.blockSize);
        }
        catch (Exception exception) {
            throw new COSSecurityException(exception);
        }
    }

    @Override
    protected synchronized byte[] basicEncrypt(byte[] byArray, byte[] byArray2, int n, int n2) throws COSSecurityException {
        try {
            this.updateHash(byArray2, n, n2);
            byte[] byArray3 = this.md.digest();
            byte[] byArray4 = this.cipher.getIV();
            if (byArray4 == null) {
                byArray4 = new byte[16];
            }
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray4, 0, byArray4.length);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, 0, this.length, KEY_ALGORITHM);
            this.cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            byte[] byArray5 = this.cipher.doFinal(byArray, 0, byArray.length);
            byte[] byArray6 = new byte[byArray4.length + byArray5.length];
            System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
            System.arraycopy(byArray5, 0, byArray6, byArray4.length, byArray5.length);
            return byArray6;
        }
        catch (Exception exception) {
            throw new COSSecurityException(exception);
        }
    }

    @Override
    public void initialize(byte[] byArray) throws COSSecurityException {
        super.initialize(byArray);
        try {
            this.md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            this.cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            this.blockSize = this.cipher.getBlockSize();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new COSSecurityException(noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new COSSecurityException(noSuchPaddingException);
        }
    }

    @Override
    protected void updateHash(byte[] byArray, int n, int n2) {
        super.updateHash(byArray, n, n2);
        this.md.update(new byte[]{115, 65, 108, 84});
    }
}

