/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Insets;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.GapContent;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Utils;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

final class TextComponentBuilders {
    TextComponentBuilders() {
    }

    static ComponentBuilders.ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (DetailsUtils.isSubclassOf(instance, JTextField.class.getName())) {
            return new JTextFieldBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JTextArea.class.getName())) {
            return new JTextAreaBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JEditorPane.class.getName())) {
            return new JEditorPaneBuilder(instance, heap);
        }
        return null;
    }

    private static class JEditorPaneBuilder
    extends JTextComponentBuilder<JEditorPane> {
        JEditorPaneBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JEditorPane createInstanceImpl() {
            return new JEditorPane();
        }
    }

    private static class JTextAreaBuilder
    extends JTextComponentBuilder<JTextArea> {
        JTextAreaBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JTextArea createInstanceImpl() {
            return new JTextArea();
        }
    }

    private static class JTextFieldBuilder
    extends JTextComponentBuilder<JTextField> {
        JTextFieldBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JTextField createInstanceImpl() {
            return new JTextField();
        }
    }

    private static abstract class JTextComponentBuilder<T extends JTextComponent>
    extends ComponentBuilders.JComponentBuilder<T> {
        private final DocumentTextBuilder model;
        private final boolean isEditable;
        private final BaseBuilders.InsetsBuilder margin;

        JTextComponentBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.model = DocumentTextBuilder.fromField(instance, "model", heap);
            this.isEditable = DetailsUtils.getBooleanFieldValue(instance, "editable", false);
            this.margin = BaseBuilders.InsetsBuilder.fromField(instance, "margin", heap);
        }

        @Override
        protected void setupInstance(T t) {
            super.setupInstance(t);
            if (this.model != null) {
                ((JTextComponent)t).setText((String)this.model.createInstance());
            }
            ((JTextComponent)t).setEditable(this.isEditable);
            if (this.margin != null) {
                ((JTextComponent)t).setMargin((Insets)this.margin.createInstance());
            }
        }
    }

    private static class DocumentTextBuilder
    extends Utils.InstanceBuilder<String> {
        private final ContentTextBuilder data;

        DocumentTextBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.data = ContentTextBuilder.fromField(instance, "data", heap);
        }

        static DocumentTextBuilder fromField(Instance instance, String string, Heap heap) {
            Object object = instance.getValueOfField(string);
            if (!(object instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)object, PlainDocument.class.getName())) {
                return null;
            }
            return new DocumentTextBuilder((Instance)object, heap);
        }

        @Override
        protected String createInstanceImpl() {
            return this.data != null ? (String)this.data.createInstance() : "";
        }
    }

    private static class ContentTextBuilder
    extends Utils.InstanceBuilder<String> {
        private final char[] array;

        ContentTextBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            List<String> list = DetailsUtils.getPrimitiveArrayFieldValues(instance, "array");
            this.array = list != null ? DetailsUtils.getCharArray(list) : null;
        }

        static ContentTextBuilder fromField(Instance instance, String string, Heap heap) {
            Object object = instance.getValueOfField(string);
            if (!(object instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)object, GapContent.class.getName())) {
                return null;
            }
            return new ContentTextBuilder((Instance)object, heap);
        }

        @Override
        protected String createInstanceImpl() {
            return this.array != null ? new String(this.array).trim() : "";
        }
    }
}

