/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.spi;

import com.sun.rowset.providers.RIOptimisticProvider;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.sql.SQLPermission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.sql.rowset.spi.ProviderImpl;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import sun.reflect.misc.ReflectUtil;

public class SyncFactory {
    public static final String ROWSET_SYNC_PROVIDER = "rowset.provider.classname";
    public static final String ROWSET_SYNC_VENDOR = "rowset.provider.vendor";
    public static final String ROWSET_SYNC_PROVIDER_VERSION = "rowset.provider.version";
    private static String ROWSET_PROPERTIES = "rowset.properties";
    private static final SQLPermission SET_SYNCFACTORY_PERMISSION = new SQLPermission("setSyncFactory");
    private static Context ic;
    private static volatile Logger rsLogger;
    private static Hashtable<String, SyncProvider> implementations;
    private static String colon;
    private static String strFileSep;
    private static boolean debug;
    private static int providerImplIndex;
    private static boolean lazyJNDICtxRefresh;

    private SyncFactory() {
    }

    public static synchronized void registerProvider(String string) throws SyncFactoryException {
        ProviderImpl providerImpl = new ProviderImpl();
        providerImpl.setClassname(string);
        SyncFactory.initMapIfNecessary();
        implementations.put(string, providerImpl);
    }

    public static SyncFactory getSyncFactory() {
        return SyncFactoryHolder.factory;
    }

    public static synchronized void unregisterProvider(String string) throws SyncFactoryException {
        SyncFactory.initMapIfNecessary();
        if (implementations.containsKey(string)) {
            implementations.remove(string);
        }
    }

    private static synchronized void initMapIfNecessary() throws SyncFactoryException {
        Properties properties = new Properties();
        if (implementations == null) {
            Object object;
            String string;
            implementations = new Hashtable();
            try {
                Object object2;
                try {
                    string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return System.getProperty("rowset.properties");
                        }
                    }, null, new PropertyPermission("rowset.properties", "read"));
                }
                catch (Exception exception) {
                    System.out.println("errorget rowset.properties: " + exception);
                    string = null;
                }
                if (string != null) {
                    ROWSET_PROPERTIES = string;
                    object2 = new FileInputStream(ROWSET_PROPERTIES);
                    object = null;
                    try {
                        properties.load((InputStream)object2);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object2 != null) {
                            if (object != null) {
                                try {
                                    ((FileInputStream)object2).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ((FileInputStream)object2).close();
                            }
                        }
                    }
                    SyncFactory.parseProperties(properties);
                }
                ROWSET_PROPERTIES = "javax" + strFileSep + "sql" + strFileSep + "rowset" + strFileSep + "rowset.properties";
                object2 = Thread.currentThread().getContextClassLoader();
                try {
                    AccessController.doPrivileged(() -> SyncFactory.lambda$initMapIfNecessary$250((ClassLoader)object2, properties));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof SyncFactoryException) {
                        throw (SyncFactoryException)exception;
                    }
                    SyncFactoryException syncFactoryException = new SyncFactoryException();
                    syncFactoryException.initCause(privilegedActionException.getException());
                    throw syncFactoryException;
                }
                SyncFactory.parseProperties(properties);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new SyncFactoryException("Cannot locate properties file: " + fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new SyncFactoryException("IOException: " + iOException);
            }
            properties.clear();
            try {
                string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(SyncFactory.ROWSET_SYNC_PROVIDER);
                    }
                }, null, new PropertyPermission(ROWSET_SYNC_PROVIDER, "read"));
            }
            catch (Exception exception) {
                string = null;
            }
            if (string != null) {
                int n = 0;
                if (string.indexOf(colon) > 0) {
                    object = new StringTokenizer(string, colon);
                    while (((StringTokenizer)object).hasMoreElements()) {
                        properties.put("rowset.provider.classname." + n, ((StringTokenizer)object).nextToken());
                        ++n;
                    }
                } else {
                    properties.put(ROWSET_SYNC_PROVIDER, string);
                }
                SyncFactory.parseProperties(properties);
            }
        }
    }

    private static void parseProperties(Properties properties) {
        ProviderImpl providerImpl = null;
        String string = null;
        String[] stringArray = null;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            int n = string2.length();
            if (!string2.startsWith(ROWSET_SYNC_PROVIDER)) continue;
            providerImpl = new ProviderImpl();
            providerImpl.setIndex(providerImplIndex++);
            stringArray = n == ROWSET_SYNC_PROVIDER.length() ? SyncFactory.getPropertyNames(false) : SyncFactory.getPropertyNames(true, string2.substring(n - 1));
            string = properties.getProperty(stringArray[0]);
            providerImpl.setClassname(string);
            providerImpl.setVendor(properties.getProperty(stringArray[1]));
            providerImpl.setVersion(properties.getProperty(stringArray[2]));
            implementations.put(string, providerImpl);
        }
    }

    private static String[] getPropertyNames(boolean bl) {
        return SyncFactory.getPropertyNames(bl, null);
    }

    private static String[] getPropertyNames(boolean bl, String string) {
        String string2 = ".";
        String[] stringArray = new String[]{ROWSET_SYNC_PROVIDER, ROWSET_SYNC_VENDOR, ROWSET_SYNC_PROVIDER_VERSION};
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i] + string2 + string;
            }
            return stringArray;
        }
        return stringArray;
    }

    private static void showImpl(ProviderImpl providerImpl) {
        System.out.println("Provider implementation:");
        System.out.println("Classname: " + providerImpl.getClassname());
        System.out.println("Vendor: " + providerImpl.getVendor());
        System.out.println("Version: " + providerImpl.getVersion());
        System.out.println("Impl index: " + providerImpl.getIndex());
    }

    public static SyncProvider getInstance(String string) throws SyncFactoryException {
        if (string == null) {
            throw new SyncFactoryException("The providerID cannot be null");
        }
        SyncFactory.initMapIfNecessary();
        SyncFactory.initJNDIContext();
        ProviderImpl providerImpl = (ProviderImpl)implementations.get(string);
        if (providerImpl == null) {
            return new RIOptimisticProvider();
        }
        try {
            ReflectUtil.checkPackageAccess(string);
        }
        catch (AccessControlException accessControlException) {
            SyncFactoryException syncFactoryException = new SyncFactoryException();
            syncFactoryException.initCause(accessControlException);
            throw syncFactoryException;
        }
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(string, true, classLoader);
            if (clazz != null) {
                return (SyncProvider)clazz.newInstance();
            }
            return new RIOptimisticProvider();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SyncFactoryException("IllegalAccessException: " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new SyncFactoryException("InstantiationException: " + instantiationException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SyncFactoryException("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
    }

    public static Enumeration<SyncProvider> getRegisteredProviders() throws SyncFactoryException {
        SyncFactory.initMapIfNecessary();
        return implementations.elements();
    }

    public static void setLogger(Logger logger) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_SYNCFACTORY_PERMISSION);
        }
        if (logger == null) {
            throw new NullPointerException("You must provide a Logger");
        }
        rsLogger = logger;
    }

    public static void setLogger(Logger logger, Level level) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_SYNCFACTORY_PERMISSION);
        }
        if (logger == null) {
            throw new NullPointerException("You must provide a Logger");
        }
        logger.setLevel(level);
        rsLogger = logger;
    }

    public static Logger getLogger() throws SyncFactoryException {
        Logger logger = rsLogger;
        if (logger == null) {
            throw new SyncFactoryException("(SyncFactory) : No logger has been set");
        }
        return logger;
    }

    public static synchronized void setJNDIContext(Context context) throws SyncFactoryException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_SYNCFACTORY_PERMISSION);
        }
        if (context == null) {
            throw new SyncFactoryException("Invalid JNDI context supplied");
        }
        ic = context;
    }

    private static synchronized void initJNDIContext() throws SyncFactoryException {
        if (ic != null && !lazyJNDICtxRefresh) {
            try {
                SyncFactory.parseProperties(SyncFactory.parseJNDIContext());
                lazyJNDICtxRefresh = true;
            }
            catch (NamingException namingException) {
                namingException.printStackTrace();
                throw new SyncFactoryException("SPI: NamingException: " + namingException.getExplanation());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SyncFactoryException("SPI: Exception: " + exception.getMessage());
            }
        }
    }

    private static Properties parseJNDIContext() throws NamingException {
        NamingEnumeration<Binding> namingEnumeration = ic.listBindings("");
        Properties properties = new Properties();
        SyncFactory.enumerateBindings(namingEnumeration, properties);
        return properties;
    }

    private static void enumerateBindings(NamingEnumeration<?> namingEnumeration, Properties properties) throws NamingException {
        boolean bl = false;
        try {
            Binding binding = null;
            Object object = null;
            String string = null;
            while (namingEnumeration.hasMore()) {
                binding = (Binding)namingEnumeration.next();
                string = binding.getName();
                object = binding.getObject();
                if (!(ic.lookup(string) instanceof Context) && ic.lookup(string) instanceof SyncProvider) {
                    bl = true;
                }
                if (!bl) continue;
                SyncProvider syncProvider = (SyncProvider)object;
                properties.put(ROWSET_SYNC_PROVIDER, syncProvider.getProviderID());
                bl = false;
            }
        }
        catch (NotContextException notContextException) {
            namingEnumeration.next();
            SyncFactory.enumerateBindings(namingEnumeration, properties);
        }
    }

    private static /* synthetic */ Void lambda$initMapIfNecessary$250(ClassLoader classLoader, Properties properties) throws Exception {
        try (InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(ROWSET_PROPERTIES) : classLoader.getResourceAsStream(ROWSET_PROPERTIES);){
            if (inputStream == null) {
                throw new SyncFactoryException("Resource " + ROWSET_PROPERTIES + " not found");
            }
            properties.load(inputStream);
        }
        return null;
    }

    static {
        colon = ":";
        strFileSep = "/";
        debug = false;
        providerImplIndex = 0;
        lazyJNDICtxRefresh = false;
    }

    private static class SyncFactoryHolder {
        static final SyncFactory factory = new SyncFactory();

        private SyncFactoryHolder() {
        }
    }
}

