/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.runtime.ScriptFunction;

public class TypeMap {
    private final Map<Integer, Type[]> paramTypeMap = new HashMap<Integer, Type[]>();
    private final Map<Integer, Type> returnTypeMap = new HashMap<Integer, Type>();
    private final boolean needsCallee;

    public TypeMap(int functionNodeId, MethodType type, boolean needsCallee) {
        Type[] types = new Type[type.parameterCount()];
        int pos = 0;
        for (Class<?> p : type.parameterArray()) {
            types[pos++] = Type.typeFor(p);
        }
        this.paramTypeMap.put(functionNodeId, types);
        this.returnTypeMap.put(functionNodeId, Type.typeFor(type.returnType()));
        this.needsCallee = needsCallee;
    }

    public Type[] getParameterTypes(int functionNodeId) {
        Type[] paramTypes = this.paramTypeMap.get(functionNodeId);
        if (paramTypes == null) {
            throw new NoSuchElementException(Integer.toString(functionNodeId));
        }
        return (Type[])paramTypes.clone();
    }

    MethodType getCallSiteType(FunctionNode functionNode) {
        Type[] types = this.paramTypeMap.get(functionNode.getId());
        if (types == null) {
            return null;
        }
        MethodType mt = MethodType.methodType(this.returnTypeMap.get(functionNode.getId()).getTypeClass());
        if (this.needsCallee) {
            mt = mt.appendParameterTypes(ScriptFunction.class);
        }
        mt = mt.appendParameterTypes(Object.class);
        for (Type type : types) {
            if (type == null) {
                return null;
            }
            mt = mt.appendParameterTypes(type.getTypeClass());
        }
        return mt;
    }

    public boolean needsCallee() {
        return this.needsCallee;
    }

    Type get(FunctionNode functionNode, int pos) {
        Object[] types = this.paramTypeMap.get(functionNode.getId());
        assert (types == null || pos < types.length) : "fn = " + functionNode.getId() + " " + "types=" + Arrays.toString(types) + " || pos=" + pos + " >= length=" + types.length + " in " + this;
        if (types != null && pos < types.length) {
            return types[pos];
        }
        return null;
    }

    boolean has(FunctionNode functionNode) {
        int id = functionNode.getId();
        Type[] paramTypes = this.paramTypeMap.get(id);
        assert (paramTypes == null == (this.returnTypeMap.get(id) == null)) : "inconsistent param and return types in param map";
        return paramTypes != null;
    }

    public String toString() {
        return this.toString("");
    }

    String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        if (this.paramTypeMap.isEmpty()) {
            sb.append(prefix).append("\t<empty>");
            return sb.toString();
        }
        for (Map.Entry<Integer, Type[]> entry : this.paramTypeMap.entrySet()) {
            int id = entry.getKey();
            sb.append(prefix).append('\t');
            sb.append("function ").append(id).append('\n');
            sb.append(prefix).append("\t\tparamTypes=");
            if (entry.getValue() == null) {
                sb.append("[]");
            } else {
                sb.append(Arrays.toString(entry.getValue()));
            }
            sb.append('\n');
            sb.append(prefix).append("\t\treturnType=");
            Type ret = this.returnTypeMap.get(id);
            sb.append(ret == null ? "N/A" : ret);
            sb.append('\n');
        }
        return sb.toString();
    }
}

