/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeConversionException;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class ExactFunction
implements Function {
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final long serialVersionUID = -6303315343568906710L;

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type textType1 = parameters.getType(0);
        Object textValue1 = parameters.getValue(0);
        Type textType2 = parameters.getType(1);
        Object textValue2 = parameters.getValue(1);
        try {
            Number number1 = typeRegistry.convertToNumber(textType1, textValue1);
            Number number2 = typeRegistry.convertToNumber(textType2, textValue2);
            double delta = Math.abs(Math.abs(number1.doubleValue()) - Math.abs(number2.doubleValue()));
            if (delta < 5.0E-5) {
                return RETURN_TRUE;
            }
            return RETURN_FALSE;
        }
        catch (TypeConversionException number1) {
            String text1 = typeRegistry.convertToText(textType1, textValue1);
            String text2 = typeRegistry.convertToText(textType2, textValue2);
            if (text1 == null || text2 == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            if (text1.equals(text2)) {
                return RETURN_TRUE;
            }
            return RETURN_FALSE;
        }
    }

    public String getCanonicalName() {
        return "EXACT";
    }
}

