<?php

/**
 * @file
 * Contains \Drupal\Core\Entity\FieldableEntityStorageInterface.
 */

namespace Drupal\Core\Entity;

/**
 * A storage that supports entity types with field definitions.
 */
interface FieldableEntityStorageInterface extends EntityStorageInterface {

  /**
   * Determines the number of entities with values for a given field.
   *
   * @param \Drupal\Core\Field\FieldStorageDefinitionInterface $storage_definition
   *   The field for which to count data records.
   * @param bool $as_bool
   *   (Optional) Optimises the query for checking whether there are any records
   *   or not. Defaults to FALSE.
   *
   * @return bool|int
   *   The number of entities. If $as_bool parameter is TRUE then the
   *   value will either be TRUE or FALSE.
   *
   * @see \Drupal\Core\Entity\FieldableEntityStorageInterface::purgeFieldData()
   */
  public function countFieldData($storage_definition, $as_bool = FALSE);

}
