/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.split.listeners;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.listeners.AbstractRunButtonActionListener;
import org.pdfsam.guiclient.commons.business.SoundPlayer;
import org.pdfsam.guiclient.commons.business.WorkExecutor;
import org.pdfsam.guiclient.commons.business.WorkThread;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.utils.DialogUtility;
import org.pdfsam.i18n.GettextResource;
import org.pdfsam.plugin.split.GUI.SplitMainGUI;

public class RunButtonActionListener
extends AbstractRunButtonActionListener {
    private static final Logger log = Logger.getLogger((String)RunButtonActionListener.class.getPackage().getName());
    private SplitMainGUI panel;

    public RunButtonActionListener(SplitMainGUI panel) {
        this.panel = panel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        if (WorkExecutor.getInstance().getRunningThreads() > 0 || this.panel.getSelectionPanel().isAdding()) {
            DialogUtility.showWarningAddingDocument((Component)((Object)this.panel));
            return;
        }
        if (!this.panel.getSameAsSourceRadio().isSelected() && StringUtils.isEmpty((String)this.panel.getDestinationFolderText().getText())) {
            DialogUtility.showWarningNoDestinationSelected((Component)((Object)this.panel), (int)1);
            return;
        }
        PdfSelectionTableItem[] items = this.panel.getSelectionPanel().getTableRows();
        if (items == null || items.length != 1) {
            DialogUtility.showWarningNoDocsSelected((Component)((Object)this.panel), (int)1);
            return;
        }
        LinkedList<String> args = new LinkedList<String>();
        try {
            PdfSelectionTableItem item = null;
            if (this.panel.getOverwriteCheckbox().isSelected() && Configuration.getInstance().isAskOverwriteConfirmation()) {
                int dialogRet = DialogUtility.askForOverwriteConfirmation((Component)((Object)this.panel));
                if (1 == dialogRet) {
                    this.panel.getOverwriteCheckbox().setSelected(false);
                } else if (2 == dialogRet) {
                    return;
                }
            }
            item = items[0];
            args.add("-f");
            String f = item.getInputFile().getAbsolutePath();
            if (item.getPassword() != null && item.getPassword().length() > 0) {
                log.debug((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Found a password for input file."));
                f = f + ":" + item.getPassword();
            }
            args.add(f);
            args.add("-p");
            args.add(this.panel.getOutPrefixText().getText());
            args.add("-s");
            String splitType = this.panel.getSplitType();
            args.add(splitType);
            if (splitType.equals("SPLIT")) {
                args.add("-n");
                args.add(this.panel.getThisPageTextField().getText());
            } else if (splitType.equals("NSPLIT")) {
                args.add("-n");
                args.add(this.panel.getnPagesTextField().getText());
            } else if (splitType.equals("SIZE")) {
                args.add("-b");
                if (!this.panel.getSplitSizeCombo().isSelectedItem() || !this.panel.getSplitSizeCombo().isValidSelectedItem()) throw new Exception(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Invalid split size"));
                args.add(Long.toString(this.panel.getSplitSizeCombo().getSelectedBytes()));
            } else if (splitType.equals("BLEVEL")) {
                args.add("-bl");
                args.add((String)this.panel.getbLevelCombo().getSelectedItem());
            }
            args.add("-o");
            if (this.panel.getSameAsSourceRadio().isSelected()) {
                if (item != null) {
                    args.add(item.getInputFile().getParent());
                }
            } else {
                if (StringUtils.isEmpty((String)this.panel.getDestinationFolderText().getText())) {
                    String suggestedDir = this.getSuggestedDestinationDirectory(item);
                    int chosenOpt = DialogUtility.showConfirmOuputLocationDialog((Component)((Object)this.panel), (String)suggestedDir);
                    if (0 == chosenOpt) {
                        this.panel.getDestinationFolderText().setText(suggestedDir);
                    } else if (2 == chosenOpt) {
                        return;
                    }
                }
                args.add(this.panel.getDestinationFolderText().getText());
            }
            if (this.panel.getOverwriteCheckbox().isSelected()) {
                args.add("-overwrite");
            }
            if (this.panel.getOutputCompressedCheck().isSelected()) {
                args.add("-compressed");
            }
            args.add("-pdfversion");
            if ("1000".equals(((StringItem)this.panel.getVersionCombo().getSelectedItem()).getId())) {
                StringItem minItem = this.panel.getVersionCombo().getMinItem();
                String currentPdfVersion = Character.toString(item.getPdfVersion());
                if (minItem != null && Integer.parseInt(currentPdfVersion) < Integer.parseInt(minItem.getId()) && 0 != DialogUtility.askForPdfVersionConfilct((Component)((Object)this.panel), (String)minItem.getDescription())) {
                    return;
                }
                args.add(currentPdfVersion);
            } else {
                args.add(((StringItem)this.panel.getVersionCombo().getSelectedItem()).getId());
            }
            args.add("split");
            String[] myStringArray = args.toArray(new String[args.size()]);
            WorkExecutor.getInstance().execute((Runnable)new WorkThread(myStringArray));
            return;
        }
        catch (Exception ex) {
            log.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
            SoundPlayer.getInstance().playErrorSound();
        }
    }
}

