/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.models;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import org.pdfsam.guiclient.commons.models.AbstractPdfSelectionTableModel;
import org.pdfsam.guiclient.commons.models.SimplePdfSelectionTableModel;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;

public class SortablePdfSelectionTableModel
extends SimplePdfSelectionTableModel {
    private static final long serialVersionUID = -3947614487255713123L;
    private AbstractPdfSelectionTableModel.SortingState sortingState = new AbstractPdfSelectionTableModel.SortingState();
    public final PdfSelectionTableItemComparator comparator = new PdfSelectionTableItemComparator();

    public SortablePdfSelectionTableModel() {
        this.setSortable(true);
    }

    public SortablePdfSelectionTableModel(int showedColumns, int maxRowsNumber) {
        super(showedColumns, maxRowsNumber);
        this.setSortable(true);
    }

    @Override
    public AbstractPdfSelectionTableModel.SortingState getSortingState() {
        return this.sortingState;
    }

    @Override
    public void setSortingState(AbstractPdfSelectionTableModel.SortingState sortingState) {
        this.sortingState = sortingState;
        this.sort();
    }

    public void setSortingState(int col, int sortType) {
        this.sortingState.setCol(col);
        this.sortingState.setSortType(sortType);
        this.sort();
    }

    public void clearSortingState() {
        this.sortingState.setCol(-1);
        this.sortingState.setSortType(0);
    }

    @Override
    public void sort() {
        if (0 != this.sortingState.getSortType()) {
            this.comparator.setSortingState(this.sortingState);
            Collections.sort(this.data, this.comparator);
            this.fireTableDataChanged();
        }
    }

    private void cancelSorting() {
        if (this.sortingState != null && 0 != this.sortingState.getSortType()) {
            this.sortingState.setSortType(0);
            this.fireTableStructureChanged();
        }
    }

    @Override
    public void addRow(PdfSelectionTableItem inputData) {
        this.cancelSorting();
        super.addRow(inputData);
    }

    @Override
    public void addRowAt(int index, PdfSelectionTableItem inputData) {
        this.cancelSorting();
        super.addRowAt(index, inputData);
    }

    @Override
    public void moveUpRow(int row) throws IndexOutOfBoundsException {
        this.cancelSorting();
        super.moveUpRow(row);
    }

    @Override
    public void moveUpRows(int[] rows) throws IndexOutOfBoundsException {
        this.cancelSorting();
        super.moveUpRows(rows);
    }

    @Override
    public void moveDownRow(int row) throws IndexOutOfBoundsException {
        this.cancelSorting();
        super.moveDownRow(row);
    }

    @Override
    public void moveDownRows(int[] rows) throws IndexOutOfBoundsException {
        this.cancelSorting();
        super.moveDownRows(rows);
    }

    public class PdfSelectionTableItemComparator
    implements Comparator<PdfSelectionTableItem>,
    Serializable {
        private static final long serialVersionUID = 1128466157306952391L;
        private AbstractPdfSelectionTableModel.SortingState sortingState;

        public PdfSelectionTableItemComparator() {
            this.sortingState = new AbstractPdfSelectionTableModel.SortingState();
        }

        @Override
        public int compare(PdfSelectionTableItem o1, PdfSelectionTableItem o2) {
            int retVal = 0;
            if (this.sortingState.getCol() == -1) {
                retVal = o1.toString().compareTo(o2.toString());
            } else {
                Object second;
                Object first;
                switch (this.sortingState.getCol()) {
                    case 1: {
                        first = o1.getInputFile() != null ? o1.getInputFile().getName() : "";
                        second = o2.getInputFile() != null ? o2.getInputFile().getName() : "";
                        break;
                    }
                    case 2: {
                        first = o1.getInputFile() != null ? o1.getInputFile().getAbsolutePath() : "";
                        second = o2.getInputFile() != null ? o2.getInputFile().getAbsolutePath() : "";
                        break;
                    }
                    case 3: {
                        first = o1.getPagesNumber() != null ? new Integer(o1.getPagesNumber()) : new Integer("0");
                        second = o2.getPagesNumber() != null ? new Integer(o2.getPagesNumber()) : new Integer("0");
                        break;
                    }
                    case 5: {
                        first = Character.valueOf(o1.getPdfVersion());
                        second = Character.valueOf(o2.getPdfVersion());
                        break;
                    }
                    case 6: {
                        first = o1.getPageSelection() != null ? o1.getPageSelection() : "";
                        second = o2.getPageSelection() != null ? o2.getPageSelection() : "";
                        break;
                    }
                    default: {
                        first = o1;
                        second = o2;
                    }
                }
                retVal = Comparable.class.isAssignableFrom(first.getClass()) ? (this.sortingState.getSortType() == -1 ? ((Comparable)first).compareTo(second) : ((Comparable)second).compareTo(first)) : (this.sortingState.getSortType() == -1 ? first.toString().compareTo(second.toString()) : second.toString().compareTo(first.toString()));
            }
            return retVal;
        }

        public AbstractPdfSelectionTableModel.SortingState getSortingState() {
            return this.sortingState;
        }

        public void setSortingState(AbstractPdfSelectionTableModel.SortingState sortingState) {
            this.sortingState = sortingState;
        }
    }
}

