/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocator {
    private final List<ClassLoader> classLoaders;

    public ServiceLocator(ClassLoader ... classLoaders) {
        this.classLoaders = Arrays.asList(classLoaders);
    }

    public <T> T get(Class<T> serviceType) throws UnknownServiceException {
        return this.getFactory(serviceType).create();
    }

    public <T> List<T> getAll(Class<T> serviceType) throws UnknownServiceException {
        List<ServiceFactory<T>> factories = this.findFactoriesForServiceType(serviceType);
        ArrayList<T> services = new ArrayList<T>();
        for (ServiceFactory<T> factory : factories) {
            services.add(factory.create());
        }
        return services;
    }

    public <T> ServiceFactory<T> getFactory(Class<T> serviceType) throws UnknownServiceException {
        ServiceFactory<T> factory = this.findFactory(serviceType);
        if (factory == null) {
            throw new UnknownServiceException(serviceType, String.format("Could not find meta-data resource 'META-INF/services/%s' for service '%s'.", serviceType.getName(), serviceType.getName()));
        }
        return factory;
    }

    public <T> ServiceFactory<T> findFactory(Class<T> serviceType) {
        List<ServiceFactory<T>> factories = this.findFactoriesForServiceType(serviceType);
        if (factories.isEmpty()) {
            return null;
        }
        return factories.get(0);
    }

    private <T> List<ServiceFactory<T>> findFactoriesForServiceType(Class<T> serviceType) {
        List<Class<T>> implementationClasses;
        try {
            implementationClasses = this.findServiceImplementations(serviceType);
        }
        catch (ServiceLookupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceLookupException(String.format("Could not determine implementation classes for service '%s'.", serviceType.getName()), e);
        }
        ArrayList<ServiceFactory<T>> factories = new ArrayList<ServiceFactory<T>>();
        for (Class<T> implementationClass : implementationClasses) {
            factories.add(new ServiceFactory<T>(serviceType, implementationClass));
        }
        return factories;
    }

    private <T> List<Class<? extends T>> findServiceImplementations(Class<T> serviceType) throws IOException {
        String resourceName = "META-INF/services/" + serviceType.getName();
        HashSet<String> implementationClassNames = new HashSet<String>();
        ArrayList<Class<T>> implementations = new ArrayList<Class<T>>();
        for (ClassLoader classLoader : this.classLoaders) {
            Enumeration<URL> resources = classLoader.getResources(resourceName);
            while (resources.hasMoreElements()) {
                List<String> implementationClassNamesFromResource;
                URL resource = resources.nextElement();
                try {
                    implementationClassNamesFromResource = this.extractImplementationClassNames(resource);
                    if (implementationClassNamesFromResource.isEmpty()) {
                        throw new RuntimeException(String.format("No implementation class for service '%s' specified.", serviceType.getName()));
                    }
                }
                catch (Exception e) {
                    throw new ServiceLookupException(String.format("Could not determine implementation class for service '%s' specified in resource '%s'.", serviceType.getName(), resource), e);
                }
                for (String implementationClassName : implementationClassNamesFromResource) {
                    if (!implementationClassNames.add(implementationClassName)) continue;
                    try {
                        Class<?> implClass = classLoader.loadClass(implementationClassName);
                        if (!serviceType.isAssignableFrom(implClass)) {
                            throw new RuntimeException(String.format("Implementation class '%s' is not assignable to service class '%s'.", implementationClassName, serviceType.getName()));
                        }
                        implementations.add(implClass.asSubclass(serviceType));
                    }
                    catch (Exception e) {
                        throw new ServiceLookupException(String.format("Could not load implementation class '%s' for service '%s' specified in resource '%s'.", implementationClassName, serviceType.getName(), resource), e);
                    }
                }
            }
        }
        return implementations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> extractImplementationClassNames(URL resource) throws IOException {
        InputStream inputStream = resource.openStream();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            ArrayList<String> implemetationClassNames = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.replaceAll("#.*", "").trim()).length() <= 0) continue;
                implemetationClassNames.add(line);
            }
            ArrayList<String> arrayList = implemetationClassNames;
            return arrayList;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServiceFactory<T>
    implements Factory<T> {
        private final Class<T> serviceType;
        private final Class<? extends T> implementationClass;

        public ServiceFactory(Class<T> serviceType, Class<? extends T> implementationClass) {
            this.serviceType = serviceType;
            this.implementationClass = implementationClass;
        }

        public Class<? extends T> getImplementationClass() {
            return this.implementationClass;
        }

        @Override
        public T create() {
            return this.newInstance(new Object[0]);
        }

        public T newInstance(Object ... params) {
            DirectInstantiator instantiator = new DirectInstantiator();
            try {
                return instantiator.newInstance(this.implementationClass, params);
            }
            catch (ObjectInstantiationException t) {
                throw new RuntimeException(String.format("Could not create an implementation of service '%s'.", this.serviceType.getName()), t);
            }
        }
    }
}

