/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.reactivestreams;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.core.support.NonBlocking;

public class SerializedSubscriber<T>
implements Subscription,
Subscriber<T>,
NonBlocking {
    private final Subscriber<? super T> delegate;
    private boolean emitting = false;
    private boolean terminated = false;
    private FastList queue;
    private Subscription subscription;
    private static final int MAX_DRAIN_ITERATION = Integer.MAX_VALUE;
    private static final Object NULL_SENTINEL = new Object();
    private static final Object COMPLETE_SENTINEL = new Object();

    public static <T> SerializedSubscriber<T> create(Subscriber<? super T> s) {
        return new SerializedSubscriber<T>(s);
    }

    private SerializedSubscriber(Subscriber<? super T> s) {
        this.delegate = s;
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        this.delegate.onSubscribe((Subscription)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        FastList list;
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
            if (this.emitting) {
                if (this.queue == null) {
                    this.queue = new FastList();
                }
                this.queue.add(COMPLETE_SENTINEL);
                return;
            }
            this.emitting = true;
            list = this.queue;
            this.queue = null;
        }
        this.drainQueue(list);
        this.delegate.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable e) {
        FastList list;
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.terminated) {
                return;
            }
            if (this.emitting) {
                if (this.queue == null) {
                    this.queue = new FastList();
                }
                this.queue.add(new ErrorSentinel(e));
                return;
            }
            this.emitting = true;
            list = this.queue;
            this.queue = null;
        }
        this.drainQueue(list);
        this.delegate.onError(e);
        serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            this.emitting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(T t) {
        FastList list;
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.terminated) {
                return;
            }
            if (this.emitting) {
                if (this.queue == null) {
                    this.queue = new FastList();
                }
                this.queue.add(t != null ? t : NULL_SENTINEL);
                return;
            }
            this.emitting = true;
            list = this.queue;
            this.queue = null;
        }
        boolean skipFinal = false;
        try {
            int iter = Integer.MAX_VALUE;
            this.drainQueue(list);
            if (iter == Integer.MAX_VALUE) {
                this.delegate.onNext(t);
            }
            if (--iter > 0) {
                SerializedSubscriber serializedSubscriber2 = this;
                synchronized (serializedSubscriber2) {
                    block28: {
                        list = this.queue;
                        this.queue = null;
                        if (list != null) break block28;
                        this.emitting = false;
                        skipFinal = true;
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[1, 5, 10, 27] lbl39 : MonitorExitStatement: MONITOREXIT : var5_8
                }
            }
        }
        finally {
            if (!skipFinal) {
                SerializedSubscriber serializedSubscriber3 = this;
                synchronized (serializedSubscriber3) {
                    if (this.terminated) {
                        list = this.queue;
                        this.queue = null;
                    } else {
                        this.emitting = false;
                        list = null;
                    }
                }
            }
        }
    }

    public void request(long n) {
        if (this.subscription != null) {
            this.subscription.request(n);
        }
    }

    public void cancel() {
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    void drainQueue(FastList list) {
        Object v;
        if (list == null || list.size == 0) {
            return;
        }
        for (int i = 0; i < list.size && (v = list.array[i]) != null; ++i) {
            if (v == NULL_SENTINEL) {
                this.delegate.onNext(null);
                continue;
            }
            if (v == COMPLETE_SENTINEL) {
                this.delegate.onComplete();
                return;
            }
            if (v.getClass() == ErrorSentinel.class) {
                this.delegate.onError(((ErrorSentinel)v).e);
                continue;
            }
            Object t = v;
            this.delegate.onNext(t);
        }
    }

    public Subscriber<? super T> delegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        FastList queue;
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            queue = this.queue;
            if (queue == null) {
                return "";
            }
        }
        String res = "{";
        for (Object o : queue.array) {
            res = res + o + " ";
        }
        return res + "}";
    }

    @Override
    public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
        return false;
    }

    @Override
    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    private static final class ErrorSentinel {
        final Throwable e;

        ErrorSentinel(Throwable e) {
            this.e = e;
        }
    }

    private static final class RequestSentinel {
        final long n;

        RequestSentinel(long n) {
            this.n = n;
        }
    }

    static final class FastList {
        Object[] array;
        int size;

        FastList() {
        }

        public void add(Object o) {
            int s = this.size;
            Object[] a = this.array;
            if (a == null) {
                this.array = a = new Object[16];
            } else if (s == a.length) {
                Object[] array2 = new Object[s + (s >> 2)];
                System.arraycopy(a, 0, array2, 0, s);
                this.array = a = array2;
            }
            a[s] = o;
            this.size = s + 1;
        }
    }
}

