/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.ReflectionUtils;

public class EntityAccess {
    private static final Set EXCLUDED_PROPERTIES = new HashSet<String>(Arrays.asList("class", "metaClass", "properties"));
    protected Object entity;
    protected BeanWrapper beanWrapper;
    protected PersistentEntity persistentEntity;

    public EntityAccess(PersistentEntity persistentEntity, Object entity) {
        this.entity = entity;
        this.persistentEntity = persistentEntity;
        this.beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)entity);
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setConversionService(ConversionService conversionService) {
        this.beanWrapper.setConversionService(conversionService);
    }

    public Object getProperty(String name) {
        return this.beanWrapper.getPropertyValue(name);
    }

    public Class getPropertyType(String name) {
        return this.beanWrapper.getPropertyType(name);
    }

    public void setProperty(String name, Object value) {
        Class type = this.getPropertyType(name);
        if (value == null) {
            if (!type.isPrimitive()) {
                this.beanWrapper.setPropertyValue(name, value);
            }
        } else {
            this.beanWrapper.setPropertyValue(name, value);
        }
    }

    public Object getIdentifier() {
        String idName = this.getIdentifierName(this.persistentEntity.getMapping());
        if (idName != null) {
            return this.getProperty(idName);
        }
        return this.getProperty(this.persistentEntity.getIdentity().getName());
    }

    public void setIdentifier(Object id) {
        String idName = this.getIdentifierName(this.persistentEntity.getMapping());
        this.setProperty(idName, id);
    }

    protected String getIdentifierName(ClassMapping cm) {
        IdentityMapping identifier = cm.getIdentifier();
        if (identifier != null && identifier.getIdentifierName() != null) {
            return identifier.getIdentifierName()[0];
        }
        return null;
    }

    public String getIdentifierName() {
        return this.getIdentifierName(this.persistentEntity.getMapping());
    }

    public PersistentEntity getPersistentEntity() {
        return this.persistentEntity;
    }

    public void setPropertyNoConversion(String name, Object value) {
        PropertyDescriptor pd = this.beanWrapper.getPropertyDescriptor(name);
        if (pd == null) {
            return;
        }
        Method writeMethod = pd.getWriteMethod();
        if (writeMethod != null) {
            ReflectionUtils.invokeMethod((Method)writeMethod, (Object)this.beanWrapper.getWrappedInstance(), (Object[])new Object[]{value});
        }
    }

    public void refresh() {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = this.beanWrapper.getPropertyDescriptors()) {
            String name = descriptor.getName();
            if (EXCLUDED_PROPERTIES.contains(name) || !this.beanWrapper.isReadableProperty(name) || !this.beanWrapper.isWritableProperty(name)) continue;
            Object newValue = this.getProperty(name);
            this.setProperty(name, newValue);
        }
    }
}

