/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.FetchType;
import javax.persistence.FlushModeType;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.query.AssociationQuery;
import org.grails.datastore.mapping.query.Projections;
import org.grails.datastore.mapping.query.Restrictions;
import org.grails.datastore.mapping.query.api.AssociationCriteria;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.query.event.PostQueryEvent;
import org.grails.datastore.mapping.query.event.PreQueryEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.util.Assert;

public abstract class Query
implements Cloneable {
    protected PersistentEntity entity;
    protected Junction criteria = new Conjunction();
    protected ProjectionList projections = new ProjectionList();
    protected int max = -1;
    protected int offset = 0;
    protected List<Order> orderBy = new ArrayList<Order>();
    protected Session session;
    protected boolean uniqueResult;
    protected Map<String, FetchType> fetchStrategies = new HashMap<String, FetchType>();
    protected Boolean queryCache;
    protected Boolean lockResult;

    protected Query(Session session, PersistentEntity entity) {
        this.entity = entity;
        this.session = session;
    }

    public Object clone() {
        Query newQuery = this.getSession().createQuery(this.entity.getJavaClass());
        for (Criterion criterion : this.criteria.getCriteria()) {
            newQuery.add(criterion);
        }
        return newQuery;
    }

    public Junction getCriteria() {
        return this.criteria;
    }

    public Query join(String property) {
        this.fetchStrategies.put(property, FetchType.EAGER);
        return this;
    }

    public Query select(String property) {
        this.fetchStrategies.put(property, FetchType.LAZY);
        return this;
    }

    public Query cache(boolean cache) {
        this.queryCache = cache;
        return this;
    }

    public Query lock(boolean lock) {
        this.lockResult = lock;
        return this;
    }

    public ProjectionList projections() {
        return this.projections;
    }

    public void add(Criterion criterion) {
        Junction currentJunction = this.criteria;
        this.add(currentJunction, criterion);
    }

    public void add(Junction currentJunction, Criterion criterion) {
        this.addToJunction(currentJunction, criterion);
    }

    public Session getSession() {
        return this.session;
    }

    public PersistentEntity getEntity() {
        return this.entity;
    }

    public Junction disjunction() {
        Junction currentJunction = this.criteria;
        return this.disjunction(currentJunction);
    }

    public Junction conjunction() {
        Junction currentJunction = this.criteria;
        return this.conjunction(currentJunction);
    }

    public Junction negation() {
        Junction currentJunction = this.criteria;
        return this.negation(currentJunction);
    }

    private Junction negation(Junction currentJunction) {
        Negation dis = new Negation();
        currentJunction.add(dis);
        return dis;
    }

    public Query max(int max) {
        this.max = max;
        return this;
    }

    public Query maxResults(int max) {
        return this.max(max);
    }

    public Query offset(int offset) {
        this.offset = offset;
        return this;
    }

    public Query firstResult(int offset) {
        return this.offset(offset);
    }

    public Query order(Order order) {
        if (order != null) {
            this.orderBy.add(order);
        }
        return this;
    }

    public List<Order> getOrderBy() {
        return this.orderBy;
    }

    public Query eq(String property, Object value) {
        Object resolved = this.resolvePropertyValue(this.entity, property, value);
        if (resolved == value) {
            this.criteria.add(Restrictions.eq(property, value));
        } else {
            this.criteria.add(Restrictions.eq(property, resolved));
        }
        return this;
    }

    Object resolvePropertyValue(PersistentEntity entity, String property, Object value) {
        PersistentProperty persistentProperty = entity.getPropertyByName(property);
        Object resolved = persistentProperty instanceof Embedded ? value : this.resolveIdIfEntity(value);
        return resolved;
    }

    public Query allEq(Map<String, Object> values) {
        Junction conjunction = this.conjunction();
        for (String property : values.keySet()) {
            Object value = values.get(property);
            Object resolved = this.resolvePropertyValue(this.entity, property, value);
            conjunction.add(Restrictions.eq(property, resolved));
        }
        return this;
    }

    public Query isEmpty(String property) {
        this.criteria.add(Restrictions.isEmpty(property));
        return this;
    }

    public Query isNotEmpty(String property) {
        this.criteria.add(Restrictions.isNotEmpty(property));
        return this;
    }

    public Query isNull(String property) {
        this.criteria.add(Restrictions.isNull(property));
        return this;
    }

    public Query isNotNull(String property) {
        this.criteria.add(Restrictions.isNotNull(property));
        return this;
    }

    public AssociationQuery createQuery(String associationName) {
        PersistentProperty property = this.entity.getPropertyByName(associationName);
        if (property == null || !(property instanceof Association)) {
            throw new InvalidDataAccessResourceUsageException("Cannot query association [" + associationName + "] of class [" + this.entity + "]. The specified property is not an association.");
        }
        Association association = (Association)property;
        PersistentEntity associatedEntity = association.getAssociatedEntity();
        return new AssociationQuery(this.session, associatedEntity, association);
    }

    public Query idEq(Object value) {
        value = this.resolveIdIfEntity(value);
        this.criteria.add(Restrictions.idEq(value));
        return this;
    }

    public Query gt(String property, Object value) {
        this.criteria.add(Restrictions.gt(property, value));
        return this;
    }

    public Query gte(String property, Object value) {
        this.criteria.add(Restrictions.gte(property, value));
        return this;
    }

    public Query lte(String property, Object value) {
        this.criteria.add(Restrictions.lte(property, value));
        return this;
    }

    public Query ge(String property, Object value) {
        return this.gte(property, value);
    }

    public Query le(String property, Object value) {
        return this.lte(property, value);
    }

    public Query lt(String property, Object value) {
        this.criteria.add(Restrictions.lt(property, value));
        return this;
    }

    public Query in(String property, List values) {
        this.criteria.add(Restrictions.in(property, values));
        return this;
    }

    public Query between(String property, Object start, Object end) {
        this.criteria.add(Restrictions.between(property, start, end));
        return this;
    }

    public Query like(String property, String expr) {
        this.criteria.add(Restrictions.like(property, expr));
        return this;
    }

    public Query ilike(String property, String expr) {
        this.criteria.add(Restrictions.ilike(property, expr));
        return this;
    }

    public Query rlike(String property, String expr) {
        this.criteria.add(Restrictions.rlike(property, expr));
        return this;
    }

    public Query and(Criterion a, Criterion b) {
        Assert.notNull((Object)a, (String)"Left hand side of AND cannot be null");
        Assert.notNull((Object)b, (String)"Right hand side of AND cannot be null");
        this.criteria.add(Restrictions.and(a, b));
        return this;
    }

    public Query or(Criterion a, Criterion b) {
        Assert.notNull((Object)a, (String)"Left hand side of AND cannot be null");
        Assert.notNull((Object)b, (String)"Right hand side of AND cannot be null");
        this.criteria.add(Restrictions.or(a, b));
        return this;
    }

    public List list() {
        this.uniqueResult = false;
        this.flushBeforeQuery();
        ApplicationEventPublisher publisher = this.session.getDatastore().getApplicationEventPublisher();
        if (publisher != null) {
            publisher.publishEvent((ApplicationEvent)new PreQueryEvent(this));
        }
        List results = this.executeQuery(this.entity, this.criteria);
        if (publisher != null) {
            PostQueryEvent postQueryEvent = new PostQueryEvent(this, results);
            publisher.publishEvent((ApplicationEvent)postQueryEvent);
            results = postQueryEvent.getResults();
        }
        return results;
    }

    public Object singleResult() {
        this.uniqueResult = true;
        List results = this.list();
        return results.isEmpty() ? null : results.get(0);
    }

    @Deprecated
    public void setUniqueResult(boolean uniqueResult) {
        this.uniqueResult = uniqueResult;
    }

    protected abstract List executeQuery(PersistentEntity var1, Junction var2);

    protected Object resolveIdIfEntity(Object value) {
        MappingContext mappingContext = this.session.getMappingContext();
        if (mappingContext.getProxyFactory().isProxy(value)) {
            return mappingContext.getProxyFactory().getIdentifier(value);
        }
        return mappingContext.isPersistentEntity(value) ? this.findInstanceId(value) : value;
    }

    private Serializable findInstanceId(Object value) {
        EntityPersister ep = (EntityPersister)this.session.getPersister(value);
        if (ep != null) {
            return ep.getObjectIdentifier(value);
        }
        return (Serializable)new EntityAccess(this.session.getMappingContext().getPersistentEntity(value.getClass().getName()), value).getIdentifier();
    }

    private Junction disjunction(Junction currentJunction) {
        Disjunction dis = new Disjunction();
        currentJunction.add(dis);
        return dis;
    }

    private Junction conjunction(Junction currentJunction) {
        Conjunction con = new Conjunction();
        currentJunction.add(con);
        return con;
    }

    protected void flushBeforeQuery() {
        if (this.session.getFlushMode() == FlushModeType.AUTO) {
            this.session.flush();
        }
    }

    private void addToJunction(Junction currentJunction, Criterion criterion) {
        if (criterion instanceof PropertyCriterion) {
            PropertyCriterion pc = (PropertyCriterion)criterion;
            String property = pc.getProperty();
            Object value = this.resolvePropertyValue(this.entity, property, pc.getValue());
            pc.setValue(value);
        }
        if (criterion instanceof AssociationCriteria) {
            AssociationCriteria ac = (AssociationCriteria)((Object)criterion);
            AssociationQuery associationQuery = this.createQuery(ac.getAssociation().getName());
            for (Criterion associationCriterion : ac.getCriteria()) {
                associationQuery.add(associationCriterion);
            }
            currentJunction.add(associationQuery);
        } else if (criterion instanceof Junction) {
            Junction j = (Junction)criterion;
            Junction newj = j instanceof Disjunction ? this.disjunction(currentJunction) : (j instanceof Negation ? this.negation(currentJunction) : this.conjunction(currentJunction));
            for (Criterion c : j.getCriteria()) {
                this.addToJunction(newj, c);
            }
        } else {
            currentJunction.add(criterion);
        }
    }

    public static class ProjectionList
    implements org.grails.datastore.mapping.query.api.ProjectionList {
        private List<Projection> projections = new ArrayList<Projection>();

        public List<Projection> getProjectionList() {
            return Collections.unmodifiableList(this.projections);
        }

        public ProjectionList add(Projection p) {
            this.projections.add(p);
            return this;
        }

        @Override
        public org.grails.datastore.mapping.query.api.ProjectionList id() {
            this.add(Projections.id());
            return this;
        }

        @Override
        public org.grails.datastore.mapping.query.api.ProjectionList count() {
            this.add(Projections.count());
            return this;
        }

        @Override
        public org.grails.datastore.mapping.query.api.ProjectionList countDistinct(String property) {
            this.add(Projections.countDistinct(property));
            return this;
        }

        public boolean isEmpty() {
            return this.projections.isEmpty();
        }

        @Override
        public ProjectionList distinct() {
            return this;
        }

        @Override
        public org.grails.datastore.mapping.query.api.ProjectionList distinct(String property) {
            this.add(Projections.distinct(property));
            return this;
        }

        @Override
        public org.grails.datastore.mapping.query.api.ProjectionList rowCount() {
            return this.count();
        }

        @Override
        public org.grails.datastore.mapping.query.api.ProjectionList property(String name) {
            this.add(Projections.property(name));
            return this;
        }

        @Override
        public org.grails.datastore.mapping.query.api.ProjectionList sum(String name) {
            this.add(Projections.sum(name));
            return this;
        }

        @Override
        public org.grails.datastore.mapping.query.api.ProjectionList min(String name) {
            this.add(Projections.min(name));
            return this;
        }

        @Override
        public org.grails.datastore.mapping.query.api.ProjectionList max(String name) {
            this.add(Projections.max(name));
            return this;
        }

        @Override
        public org.grails.datastore.mapping.query.api.ProjectionList avg(String name) {
            this.add(Projections.avg(name));
            return this;
        }
    }

    public static class SumProjection
    extends PropertyProjection {
        protected SumProjection(String propertyName) {
            super(propertyName);
        }
    }

    public static class MinProjection
    extends PropertyProjection {
        protected MinProjection(String propertyName) {
            super(propertyName);
        }
    }

    public static class MaxProjection
    extends PropertyProjection {
        protected MaxProjection(String propertyName) {
            super(propertyName);
        }
    }

    public static class AvgProjection
    extends PropertyProjection {
        protected AvgProjection(String propertyName) {
            super(propertyName);
        }
    }

    public static class CountDistinctProjection
    extends PropertyProjection {
        public CountDistinctProjection(String property) {
            super(property);
        }
    }

    public static class DistinctPropertyProjection
    extends PropertyProjection {
        protected DistinctPropertyProjection(String propertyName) {
            super(propertyName);
        }
    }

    public static class PropertyProjection
    extends Projection {
        private String propertyName;

        protected PropertyProjection(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static class DistinctProjection
    extends Projection {
    }

    public static class CountProjection
    extends Projection {
    }

    public static class IdProjection
    extends Projection {
    }

    public static class Projection {
    }

    public static class Negation
    extends Junction {
    }

    public static class Disjunction
    extends Junction {
        public Disjunction() {
        }

        public Disjunction(List<Criterion> criteria) {
            super(criteria);
        }
    }

    public static class Conjunction
    extends Junction {
        public Conjunction() {
        }

        public Conjunction(List<Criterion> criteria) {
            super(criteria);
        }
    }

    public static abstract class Junction
    implements Criterion {
        private List<Criterion> criteria = new ArrayList<Criterion>();

        protected Junction() {
        }

        public Junction(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        public Junction add(Criterion c) {
            if (c != null) {
                this.criteria.add(c);
            }
            return this;
        }

        public List<Criterion> getCriteria() {
            return this.criteria;
        }

        public boolean isEmpty() {
            return this.criteria.isEmpty();
        }
    }

    public static class RLike
    extends Like {
        public RLike(String name, String expression) {
            super(name, expression);
        }

        @Override
        public String getPattern() {
            return this.getValue().toString();
        }
    }

    public static class ILike
    extends Like {
        public ILike(String name, String expression) {
            super(name, expression);
        }
    }

    public static class Like
    extends PropertyCriterion {
        public Like(String name, String expression) {
            super(name, expression);
        }

        public String getPattern() {
            return this.getValue().toString();
        }
    }

    public static class Between
    extends PropertyCriterion {
        private String property;
        private Object from;
        private Object to;

        public Between(String property, Object from, Object to) {
            super(property, from);
            this.property = property;
            this.from = from;
            this.to = to;
        }

        @Override
        public String getProperty() {
            return this.property;
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }
    }

    public static class LessThanEquals
    extends PropertyCriterion {
        public LessThanEquals(String name, Object value) {
            super(name, value);
        }
    }

    public static class LessThan
    extends PropertyCriterion {
        public LessThan(String name, Object value) {
            super(name, value);
        }
    }

    public static class GreaterThanEquals
    extends PropertyCriterion {
        public GreaterThanEquals(String name, Object value) {
            super(name, value);
        }
    }

    public static class GreaterThan
    extends PropertyCriterion {
        public GreaterThan(String name, Object value) {
            super(name, value);
        }
    }

    public static class NotExists
    implements Criterion {
        private QueryableCriteria subquery;

        public NotExists(QueryableCriteria subquery) {
            this.subquery = subquery;
        }

        public QueryableCriteria getSubquery() {
            return this.subquery;
        }
    }

    public static class Exists
    implements Criterion {
        private QueryableCriteria subquery;

        public Exists(QueryableCriteria subquery) {
            this.subquery = subquery;
        }

        public QueryableCriteria getSubquery() {
            return this.subquery;
        }
    }

    public static class NotIn
    extends SubqueryCriterion {
        private QueryableCriteria subquery;

        public NotIn(String name, QueryableCriteria subquery) {
            super(name, subquery);
            this.subquery = subquery;
        }

        public String getName() {
            return this.getProperty();
        }

        public QueryableCriteria getSubquery() {
            return this.subquery;
        }
    }

    public static class In
    extends PropertyCriterion {
        private Collection values = Collections.emptyList();
        private QueryableCriteria subquery;

        public In(String name, Collection values) {
            super(name, values);
            this.values = In.convertCharSequenceValuesIfNecessary(values);
        }

        private static Collection convertCharSequenceValuesIfNecessary(Collection values) {
            boolean requiresConversion = false;
            for (Object val : values) {
                if (val instanceof String || !(val instanceof CharSequence)) continue;
                requiresConversion = true;
                break;
            }
            if (requiresConversion) {
                ArrayList newList = new ArrayList(values.size());
                for (Object val : values) {
                    newList.add(val instanceof CharSequence ? val.toString() : val);
                }
                return newList;
            }
            return values;
        }

        public In(String name, QueryableCriteria subquery) {
            super(name, subquery);
            this.subquery = subquery;
        }

        public String getName() {
            return this.getProperty();
        }

        public Collection getValues() {
            return Collections.unmodifiableCollection(this.values);
        }

        public QueryableCriteria getSubquery() {
            return this.subquery;
        }
    }

    public static class NotEquals
    extends PropertyCriterion {
        public NotEquals(String name, Object value) {
            super(name, value);
        }

        @Override
        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static class IdEquals
    extends PropertyCriterion {
        private static final String ID = "id";

        public IdEquals(Object value) {
            super(ID, value);
        }

        @Override
        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static class SizeLessThan
    extends PropertyCriterion {
        public SizeLessThan(String name, int value) {
            super(name, value);
        }
    }

    public static class SizeLessThanEquals
    extends PropertyCriterion {
        public SizeLessThanEquals(String name, int value) {
            super(name, value);
        }
    }

    public static class SizeGreaterThanEquals
    extends PropertyCriterion {
        public SizeGreaterThanEquals(String name, int value) {
            super(name, value);
        }
    }

    public static class SizeGreaterThan
    extends PropertyCriterion {
        public SizeGreaterThan(String name, int value) {
            super(name, value);
        }
    }

    public static class SizeNotEquals
    extends PropertyCriterion {
        public SizeNotEquals(String name, int value) {
            super(name, value);
        }
    }

    public static class SizeEquals
    extends PropertyCriterion {
        public SizeEquals(String name, int value) {
            super(name, value);
        }
    }

    public static class Equals
    extends PropertyCriterion {
        public Equals(String name, Object value) {
            super(name, value);
        }

        @Override
        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static class LessThanEqualsAll
    extends SubqueryCriterion {
        public LessThanEqualsAll(String name, QueryableCriteria value) {
            super(name, value);
        }
    }

    public static class GreaterThanEqualsAll
    extends SubqueryCriterion {
        public GreaterThanEqualsAll(String name, QueryableCriteria value) {
            super(name, value);
        }
    }

    public static class LessThanAll
    extends SubqueryCriterion {
        public LessThanAll(String name, QueryableCriteria value) {
            super(name, value);
        }
    }

    public static class LessThanEqualsSome
    extends SubqueryCriterion {
        public LessThanEqualsSome(String name, QueryableCriteria value) {
            super(name, value);
        }
    }

    public static class LessThanSome
    extends SubqueryCriterion {
        public LessThanSome(String name, QueryableCriteria value) {
            super(name, value);
        }
    }

    public static class GreaterThanEqualsSome
    extends SubqueryCriterion {
        public GreaterThanEqualsSome(String name, QueryableCriteria value) {
            super(name, value);
        }
    }

    public static class GreaterThanSome
    extends SubqueryCriterion {
        public GreaterThanSome(String name, QueryableCriteria value) {
            super(name, value);
        }
    }

    public static class GreaterThanAll
    extends SubqueryCriterion {
        public GreaterThanAll(String name, QueryableCriteria value) {
            super(name, value);
        }
    }

    public static class NotEqualsAll
    extends SubqueryCriterion {
        public NotEqualsAll(String name, QueryableCriteria value) {
            super(name, value);
        }
    }

    public static class EqualsAll
    extends SubqueryCriterion {
        public EqualsAll(String name, QueryableCriteria value) {
            super(name, value);
        }
    }

    public static class SubqueryCriterion
    extends PropertyCriterion {
        public SubqueryCriterion(String name, QueryableCriteria value) {
            super(name, value);
        }

        @Override
        public QueryableCriteria getValue() {
            return (QueryableCriteria)super.getValue();
        }
    }

    public static class PropertyCriterion
    extends PropertyNameCriterion {
        protected Object value;

        public PropertyCriterion(String name, Object value) {
            super(name);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object v) {
            this.value = v;
        }
    }

    public static class LessThanEqualsProperty
    extends PropertyComparisonCriterion {
        public LessThanEqualsProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class LessThanProperty
    extends PropertyComparisonCriterion {
        public LessThanProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class GreaterThanEqualsProperty
    extends PropertyComparisonCriterion {
        public GreaterThanEqualsProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class GreaterThanProperty
    extends PropertyComparisonCriterion {
        public GreaterThanProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class NotEqualsProperty
    extends PropertyComparisonCriterion {
        public NotEqualsProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class EqualsProperty
    extends PropertyComparisonCriterion {
        public EqualsProperty(String property, String otherProperty) {
            super(property, otherProperty);
        }
    }

    public static class PropertyComparisonCriterion
    extends PropertyNameCriterion {
        protected String otherProperty;

        public PropertyComparisonCriterion(String property, String otherProperty) {
            super(property);
            this.otherProperty = otherProperty;
        }

        public String getOtherProperty() {
            return this.otherProperty;
        }
    }

    public static class PropertyNameCriterion
    implements Criterion {
        protected String name;

        public PropertyNameCriterion(String name) {
            this.name = name;
        }

        public String getProperty() {
            return this.name;
        }
    }

    public static class IsNotNull
    extends PropertyNameCriterion {
        public IsNotNull(String name) {
            super(name);
        }
    }

    public static class IsNotEmpty
    extends PropertyNameCriterion {
        public IsNotEmpty(String name) {
            super(name);
        }
    }

    public static class IsEmpty
    extends PropertyNameCriterion {
        public IsEmpty(String name) {
            super(name);
        }
    }

    public static class IsNull
    extends PropertyNameCriterion {
        public IsNull(String name) {
            super(name);
        }
    }

    public static class Order {
        private Direction direction = Direction.ASC;
        private String property;
        private boolean ignoreCase = false;

        public Order(String property) {
            this.property = property;
        }

        public Order(String property, Direction direction) {
            this.direction = direction;
            this.property = property;
        }

        public Order ignoreCase() {
            this.ignoreCase = true;
            return this;
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String getProperty() {
            return this.property;
        }

        public static Order desc(String property) {
            return new Order(property, Direction.DESC);
        }

        public static Order asc(String property) {
            return new Order(property, Direction.ASC);
        }

        public static enum Direction {
            ASC,
            DESC;

        }
    }

    public static interface Criterion {
    }
}

