/*
 * Decompiled with CFR 0.152.
 */
package grails.async.factory;

import grails.async.Promise;
import grails.async.PromiseFactory;
import grails.async.PromiseList;
import grails.async.PromiseMap;
import grails.async.decorator.PromiseDecorator;
import grails.async.decorator.PromiseDecoratorLookupStrategy;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.grails.async.factory.BoundPromise;

public abstract class AbstractPromiseFactory
implements PromiseFactory {
    protected Collection<PromiseDecoratorLookupStrategy> lookupStrategies = new ConcurrentLinkedQueue<PromiseDecoratorLookupStrategy>();

    @Override
    public void addPromiseDecoratorLookupStrategy(PromiseDecoratorLookupStrategy lookupStrategy) {
        this.lookupStrategies.add(lookupStrategy);
    }

    @Override
    public <T> Promise<T> createBoundPromise(T value) {
        return new BoundPromise<T>(value);
    }

    @Override
    public <T> Promise<T> createPromise(Closure<T> c, List<PromiseDecorator> decorators) {
        c = this.applyDecorators(c, decorators);
        return this.createPromise(c);
    }

    @Override
    public <T> Closure<T> applyDecorators(Closure<T> c, List<PromiseDecorator> decorators) {
        ArrayList<PromiseDecorator> allDecorators = decorators != null ? new ArrayList<PromiseDecorator>(decorators) : new ArrayList();
        for (PromiseDecoratorLookupStrategy lookupStrategy : this.lookupStrategies) {
            allDecorators.addAll(lookupStrategy.findDecorators());
        }
        if (!allDecorators.isEmpty()) {
            for (PromiseDecorator d : allDecorators) {
                c = d.decorate(c);
            }
        }
        return c;
    }

    @Override
    public <T> Promise<List<T>> createPromise(List<Closure<T>> closures) {
        return this.createPromise(closures, null);
    }

    @Override
    public <T> Promise<List<T>> createPromise(List<Closure<T>> closures, List<PromiseDecorator> decorators) {
        ArrayList<Closure<T>> newClosures = new ArrayList<Closure<T>>(closures.size());
        for (Closure<T> closure : closures) {
            newClosures.add(this.applyDecorators(closure, decorators));
        }
        closures = newClosures;
        PromiseList promiseList = new PromiseList();
        for (Closure<T> closure : closures) {
            promiseList.add(closure);
        }
        return promiseList;
    }

    @Override
    public <T> Promise<List<T>> createPromise(Promise<T> ... promises) {
        PromiseList<T> promiseList = new PromiseList<T>();
        for (Promise<T> p : promises) {
            promiseList.add(p);
        }
        return promiseList;
    }

    @Override
    public <K, V> Promise<Map<K, V>> createPromise(Map<K, V> map) {
        PromiseMap promiseMap = new PromiseMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (value instanceof Promise) {
                promiseMap.put(key, (Promise)value);
                continue;
            }
            if (value instanceof Closure) {
                Closure c = (Closure)value;
                promiseMap.put(key, this.createPromise(c));
                continue;
            }
            promiseMap.put(key, new BoundPromise<V>(value));
        }
        return promiseMap;
    }

    @Override
    public <T> List<T> waitAll(Promise<T> ... promises) {
        return this.waitAll(Arrays.asList(promises));
    }
}

