/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.bbox;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.bbox.BBoxOverlapRatioValueSource;
import org.apache.lucene.spatial.bbox.BBoxValueSource;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.lucene.spatial.util.DistanceToShapeValueSource;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;

public class BBoxStrategy
extends SpatialStrategy {
    public static final String SUFFIX_MINX = "__minX";
    public static final String SUFFIX_MAXX = "__maxX";
    public static final String SUFFIX_MINY = "__minY";
    public static final String SUFFIX_MAXY = "__maxY";
    public static final String SUFFIX_XDL = "__xdl";
    protected final String field_bbox;
    protected final String field_minX;
    protected final String field_minY;
    protected final String field_maxX;
    protected final String field_maxY;
    protected final String field_xdl;
    protected FieldType fieldType;
    protected FieldType xdlFieldType;

    public BBoxStrategy(SpatialContext ctx, String fieldNamePrefix) {
        super(ctx, fieldNamePrefix);
        this.field_bbox = fieldNamePrefix;
        this.field_minX = fieldNamePrefix + SUFFIX_MINX;
        this.field_maxX = fieldNamePrefix + SUFFIX_MAXX;
        this.field_minY = fieldNamePrefix + SUFFIX_MINY;
        this.field_maxY = fieldNamePrefix + SUFFIX_MAXY;
        this.field_xdl = fieldNamePrefix + SUFFIX_XDL;
        FieldType fieldType = new FieldType(DoubleField.TYPE_NOT_STORED);
        fieldType.setNumericPrecisionStep(8);
        fieldType.setDocValuesType(DocValuesType.NUMERIC);
        this.setFieldType(fieldType);
    }

    private int getPrecisionStep() {
        return this.fieldType.numericPrecisionStep();
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        fieldType.freeze();
        this.fieldType = fieldType;
        if (fieldType.numericType() != FieldType.NumericType.DOUBLE) {
            throw new IllegalArgumentException("BBoxStrategy only supports doubles at this time.");
        }
        this.xdlFieldType = new FieldType(StringField.TYPE_NOT_STORED);
        this.xdlFieldType.setStored(fieldType.stored());
        this.xdlFieldType.setIndexOptions(fieldType.indexOptions());
        this.xdlFieldType.freeze();
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        return this.createIndexableFields(shape.getBoundingBox());
    }

    public Field[] createIndexableFields(Rectangle bbox) {
        Field[] fields = new Field[]{new ComboField(this.field_minX, bbox.getMinX(), this.fieldType), new ComboField(this.field_maxX, bbox.getMaxX(), this.fieldType), new ComboField(this.field_minY, bbox.getMinY(), this.fieldType), new ComboField(this.field_maxY, bbox.getMaxY(), this.fieldType), new ComboField(this.field_xdl, bbox.getCrossesDateLine() ? "T" : "F", this.xdlFieldType)};
        return fields;
    }

    public ValueSource makeShapeValueSource() {
        return new BBoxValueSource(this);
    }

    @Override
    public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        return new DistanceToShapeValueSource(this.makeShapeValueSource(), queryPoint, multiplier, this.ctx);
    }

    public ValueSource makeOverlapRatioValueSource(Rectangle queryBox, double queryTargetProportion) {
        return new BBoxOverlapRatioValueSource(this.makeShapeValueSource(), this.ctx.isGeo(), queryBox, queryTargetProportion, 0.0);
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        return new QueryWrapperFilter(this.makeSpatialQuery(args));
    }

    public ConstantScoreQuery makeQuery(SpatialArgs args) {
        return new ConstantScoreQuery(this.makeSpatialQuery(args));
    }

    private Query makeSpatialQuery(SpatialArgs args) {
        Query spatial;
        Shape shape = args.getShape();
        if (!(shape instanceof Rectangle)) {
            throw new UnsupportedOperationException("Can only query by Rectangle, not " + shape);
        }
        Rectangle bbox = (Rectangle)shape;
        SpatialOperation op = args.getOperation();
        if (op == SpatialOperation.BBoxIntersects) {
            spatial = this.makeIntersects(bbox);
        } else if (op == SpatialOperation.BBoxWithin) {
            spatial = this.makeWithin(bbox);
        } else if (op == SpatialOperation.Contains) {
            spatial = this.makeContains(bbox);
        } else if (op == SpatialOperation.Intersects) {
            spatial = this.makeIntersects(bbox);
        } else if (op == SpatialOperation.IsEqualTo) {
            spatial = this.makeEquals(bbox);
        } else if (op == SpatialOperation.IsDisjointTo) {
            spatial = this.makeDisjoint(bbox);
        } else if (op == SpatialOperation.IsWithin) {
            spatial = this.makeWithin(bbox);
        } else {
            throw new UnsupportedSpatialOperation(op);
        }
        return spatial;
    }

    Query makeContains(Rectangle bbox) {
        Query xConditions;
        NumericRangeQuery qMinY = NumericRangeQuery.newDoubleRange((String)this.field_minY, (int)this.getPrecisionStep(), null, (Double)bbox.getMinY(), (boolean)false, (boolean)true);
        NumericRangeQuery qMaxY = NumericRangeQuery.newDoubleRange((String)this.field_maxY, (int)this.getPrecisionStep(), (Double)bbox.getMaxY(), null, (boolean)true, (boolean)false);
        BooleanQuery yConditions = this.makeQuery(BooleanClause.Occur.MUST, new Query[]{qMinY, qMaxY});
        if (!bbox.getCrossesDateLine()) {
            NumericRangeQuery qMinX = NumericRangeQuery.newDoubleRange((String)this.field_minX, (int)this.getPrecisionStep(), null, (Double)bbox.getMinX(), (boolean)false, (boolean)true);
            NumericRangeQuery qMaxX = NumericRangeQuery.newDoubleRange((String)this.field_maxX, (int)this.getPrecisionStep(), (Double)bbox.getMaxX(), null, (boolean)true, (boolean)false);
            BooleanQuery qMinMax = this.makeQuery(BooleanClause.Occur.MUST, new Query[]{qMinX, qMaxX});
            Query qNonXDL = this.makeXDL(false, (Query)qMinMax);
            if (!this.ctx.isGeo()) {
                xConditions = qNonXDL;
            } else {
                NumericRangeQuery qXDLLeft = NumericRangeQuery.newDoubleRange((String)this.field_minX, (int)this.getPrecisionStep(), null, (Double)bbox.getMinX(), (boolean)false, (boolean)true);
                NumericRangeQuery qXDLRight = NumericRangeQuery.newDoubleRange((String)this.field_maxX, (int)this.getPrecisionStep(), (Double)bbox.getMaxX(), null, (boolean)true, (boolean)false);
                BooleanQuery qXDLLeftRight = this.makeQuery(BooleanClause.Occur.SHOULD, new Query[]{qXDLLeft, qXDLRight});
                Query qXDL = this.makeXDL(true, (Query)qXDLLeftRight);
                BooleanQuery qEdgeDL = null;
                if (bbox.getMinX() == bbox.getMaxX() && Math.abs(bbox.getMinX()) == 180.0) {
                    double edge = bbox.getMinX() * -1.0;
                    qEdgeDL = this.makeQuery(BooleanClause.Occur.SHOULD, this.makeNumberTermQuery(this.field_minX, edge), this.makeNumberTermQuery(this.field_maxX, edge));
                }
                xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, new Query[]{qNonXDL, qXDL, qEdgeDL});
            }
        } else {
            NumericRangeQuery qXDLLeft = NumericRangeQuery.newDoubleRange((String)this.field_minX, (int)this.getPrecisionStep(), null, (Double)bbox.getMinX(), (boolean)false, (boolean)true);
            NumericRangeQuery qXDLRight = NumericRangeQuery.newDoubleRange((String)this.field_maxX, (int)this.getPrecisionStep(), (Double)bbox.getMaxX(), null, (boolean)true, (boolean)false);
            Query qXDLLeftRight = this.makeXDL(true, (Query)this.makeQuery(BooleanClause.Occur.MUST, new Query[]{qXDLLeft, qXDLRight}));
            BooleanQuery qWorld = this.makeQuery(BooleanClause.Occur.MUST, this.makeNumberTermQuery(this.field_minX, -180.0), this.makeNumberTermQuery(this.field_maxX, 180.0));
            xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, new Query[]{qXDLLeftRight, qWorld});
        }
        return this.makeQuery(BooleanClause.Occur.MUST, new Query[]{xConditions, yConditions});
    }

    Query makeDisjoint(Rectangle bbox) {
        Query xConditions;
        NumericRangeQuery qMinY = NumericRangeQuery.newDoubleRange((String)this.field_minY, (int)this.getPrecisionStep(), (Double)bbox.getMaxY(), null, (boolean)false, (boolean)false);
        NumericRangeQuery qMaxY = NumericRangeQuery.newDoubleRange((String)this.field_maxY, (int)this.getPrecisionStep(), null, (Double)bbox.getMinY(), (boolean)false, (boolean)false);
        BooleanQuery yConditions = this.makeQuery(BooleanClause.Occur.SHOULD, new Query[]{qMinY, qMaxY});
        if (!bbox.getCrossesDateLine()) {
            NumericRangeQuery qMinX = NumericRangeQuery.newDoubleRange((String)this.field_minX, (int)this.getPrecisionStep(), (Double)bbox.getMaxX(), null, (boolean)false, (boolean)false);
            if (bbox.getMinX() == -180.0 && this.ctx.isGeo()) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add((Query)qMinX, BooleanClause.Occur.MUST);
                bq.add(this.makeNumberTermQuery(this.field_maxX, 180.0), BooleanClause.Occur.MUST_NOT);
                qMinX = bq.build();
            }
            NumericRangeQuery qMaxX = NumericRangeQuery.newDoubleRange((String)this.field_maxX, (int)this.getPrecisionStep(), null, (Double)bbox.getMinX(), (boolean)false, (boolean)false);
            if (bbox.getMaxX() == 180.0 && this.ctx.isGeo()) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add((Query)qMaxX, BooleanClause.Occur.MUST);
                bq.add(this.makeNumberTermQuery(this.field_minX, -180.0), BooleanClause.Occur.MUST_NOT);
                qMaxX = bq.build();
            }
            BooleanQuery qMinMax = this.makeQuery(BooleanClause.Occur.SHOULD, new Query[]{qMinX, qMaxX});
            Query qNonXDL = this.makeXDL(false, (Query)qMinMax);
            if (!this.ctx.isGeo()) {
                xConditions = qNonXDL;
            } else {
                NumericRangeQuery qMinXLeft = NumericRangeQuery.newDoubleRange((String)this.field_minX, (int)this.getPrecisionStep(), (Double)bbox.getMaxX(), null, (boolean)false, (boolean)false);
                NumericRangeQuery qMaxXRight = NumericRangeQuery.newDoubleRange((String)this.field_maxX, (int)this.getPrecisionStep(), null, (Double)bbox.getMinX(), (boolean)false, (boolean)false);
                BooleanQuery qLeftRight = this.makeQuery(BooleanClause.Occur.MUST, new Query[]{qMinXLeft, qMaxXRight});
                Query qXDL = this.makeXDL(true, (Query)qLeftRight);
                xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qNonXDL, qXDL);
            }
        } else {
            NumericRangeQuery qMinXLeft = NumericRangeQuery.newDoubleRange((String)this.field_minX, (int)this.getPrecisionStep(), (Double)180.0, null, (boolean)false, (boolean)false);
            NumericRangeQuery qMaxXLeft = NumericRangeQuery.newDoubleRange((String)this.field_maxX, (int)this.getPrecisionStep(), null, (Double)bbox.getMinX(), (boolean)false, (boolean)false);
            NumericRangeQuery qMinXRight = NumericRangeQuery.newDoubleRange((String)this.field_minX, (int)this.getPrecisionStep(), (Double)bbox.getMaxX(), null, (boolean)false, (boolean)false);
            NumericRangeQuery qMaxXRight = NumericRangeQuery.newDoubleRange((String)this.field_maxX, (int)this.getPrecisionStep(), null, (Double)-180.0, (boolean)false, (boolean)false);
            BooleanQuery qLeft = this.makeQuery(BooleanClause.Occur.SHOULD, new Query[]{qMinXLeft, qMaxXLeft});
            BooleanQuery qRight = this.makeQuery(BooleanClause.Occur.SHOULD, new Query[]{qMinXRight, qMaxXRight});
            BooleanQuery qLeftRight = this.makeQuery(BooleanClause.Occur.MUST, new Query[]{qLeft, qRight});
            xConditions = this.makeXDL(false, (Query)qLeftRight);
        }
        return this.makeQuery(BooleanClause.Occur.SHOULD, new Query[]{xConditions, yConditions});
    }

    Query makeEquals(Rectangle bbox) {
        Query qMinX = this.makeNumberTermQuery(this.field_minX, bbox.getMinX());
        Query qMinY = this.makeNumberTermQuery(this.field_minY, bbox.getMinY());
        Query qMaxX = this.makeNumberTermQuery(this.field_maxX, bbox.getMaxX());
        Query qMaxY = this.makeNumberTermQuery(this.field_maxY, bbox.getMaxY());
        return this.makeQuery(BooleanClause.Occur.MUST, qMinX, qMinY, qMaxX, qMaxY);
    }

    Query makeIntersects(Rectangle bbox) {
        Query qHasEnv;
        if (this.ctx.isGeo()) {
            Query qIsNonXDL = this.makeXDL(false);
            Query qIsXDL = this.ctx.isGeo() ? this.makeXDL(true) : null;
            qHasEnv = this.makeQuery(BooleanClause.Occur.SHOULD, qIsNonXDL, qIsXDL);
        } else {
            qHasEnv = this.makeXDL(false);
        }
        BooleanQuery.Builder qNotDisjoint = new BooleanQuery.Builder();
        qNotDisjoint.add(qHasEnv, BooleanClause.Occur.MUST);
        Query qDisjoint = this.makeDisjoint(bbox);
        qNotDisjoint.add(qDisjoint, BooleanClause.Occur.MUST_NOT);
        return qNotDisjoint.build();
    }

    BooleanQuery makeQuery(BooleanClause.Occur occur, Query ... queries) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (Query query : queries) {
            if (query == null) continue;
            bq.add(query, occur);
        }
        return bq.build();
    }

    Query makeWithin(Rectangle bbox) {
        Query xConditions;
        NumericRangeQuery qMinY = NumericRangeQuery.newDoubleRange((String)this.field_minY, (int)this.getPrecisionStep(), (Double)bbox.getMinY(), null, (boolean)true, (boolean)false);
        NumericRangeQuery qMaxY = NumericRangeQuery.newDoubleRange((String)this.field_maxY, (int)this.getPrecisionStep(), null, (Double)bbox.getMaxY(), (boolean)false, (boolean)true);
        BooleanQuery yConditions = this.makeQuery(BooleanClause.Occur.MUST, new Query[]{qMinY, qMaxY});
        if (this.ctx.isGeo() && bbox.getMinX() == -180.0 && bbox.getMaxX() == 180.0) {
            return yConditions;
        }
        if (!bbox.getCrossesDateLine()) {
            NumericRangeQuery qMinX = NumericRangeQuery.newDoubleRange((String)this.field_minX, (int)this.getPrecisionStep(), (Double)bbox.getMinX(), null, (boolean)true, (boolean)false);
            NumericRangeQuery qMaxX = NumericRangeQuery.newDoubleRange((String)this.field_maxX, (int)this.getPrecisionStep(), null, (Double)bbox.getMaxX(), (boolean)false, (boolean)true);
            BooleanQuery qMinMax = this.makeQuery(BooleanClause.Occur.MUST, new Query[]{qMinX, qMaxX});
            double edge = 0.0;
            if (bbox.getMinX() == -180.0) {
                edge = 180.0;
            } else if (bbox.getMaxX() == 180.0) {
                edge = -180.0;
            }
            if (edge != 0.0 && this.ctx.isGeo()) {
                BooleanQuery edgeQ = this.makeQuery(BooleanClause.Occur.MUST, this.makeNumberTermQuery(this.field_minX, edge), this.makeNumberTermQuery(this.field_maxX, edge));
                qMinMax = this.makeQuery(BooleanClause.Occur.SHOULD, new Query[]{qMinMax, edgeQ});
            }
            xConditions = this.makeXDL(false, (Query)qMinMax);
        } else {
            NumericRangeQuery qMinXLeft = NumericRangeQuery.newDoubleRange((String)this.field_minX, (int)this.getPrecisionStep(), (Double)bbox.getMinX(), null, (boolean)true, (boolean)false);
            NumericRangeQuery qMaxXLeft = NumericRangeQuery.newDoubleRange((String)this.field_maxX, (int)this.getPrecisionStep(), null, (Double)180.0, (boolean)false, (boolean)true);
            BooleanQuery qLeft = this.makeQuery(BooleanClause.Occur.MUST, new Query[]{qMinXLeft, qMaxXLeft});
            NumericRangeQuery qMinXRight = NumericRangeQuery.newDoubleRange((String)this.field_minX, (int)this.getPrecisionStep(), (Double)-180.0, null, (boolean)true, (boolean)false);
            NumericRangeQuery qMaxXRight = NumericRangeQuery.newDoubleRange((String)this.field_maxX, (int)this.getPrecisionStep(), null, (Double)bbox.getMaxX(), (boolean)false, (boolean)true);
            BooleanQuery qRight = this.makeQuery(BooleanClause.Occur.MUST, new Query[]{qMinXRight, qMaxXRight});
            BooleanQuery qLeftRight = this.makeQuery(BooleanClause.Occur.SHOULD, new Query[]{qLeft, qRight});
            Query qNonXDL = this.makeXDL(false, (Query)qLeftRight);
            NumericRangeQuery qXDLLeft = NumericRangeQuery.newDoubleRange((String)this.field_minX, (int)this.getPrecisionStep(), (Double)bbox.getMinX(), null, (boolean)true, (boolean)false);
            NumericRangeQuery qXDLRight = NumericRangeQuery.newDoubleRange((String)this.field_maxX, (int)this.getPrecisionStep(), null, (Double)bbox.getMaxX(), (boolean)false, (boolean)true);
            BooleanQuery qXDLLeftRight = this.makeQuery(BooleanClause.Occur.MUST, new Query[]{qXDLLeft, qXDLRight});
            Query qXDL = this.makeXDL(true, (Query)qXDLLeftRight);
            xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qNonXDL, qXDL);
        }
        return this.makeQuery(BooleanClause.Occur.MUST, new Query[]{xConditions, yConditions});
    }

    private Query makeXDL(boolean crossedDateLine) {
        return new TermQuery(new Term(this.field_xdl, crossedDateLine ? "T" : "F"));
    }

    private Query makeXDL(boolean crossedDateLine, Query query) {
        if (!this.ctx.isGeo()) {
            assert (!crossedDateLine);
            return query;
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.add(this.makeXDL(crossedDateLine), BooleanClause.Occur.MUST);
        bq.add(query, BooleanClause.Occur.MUST);
        return bq.build();
    }

    private Query makeNumberTermQuery(String field, double number) {
        BytesRefBuilder bytes = new BytesRefBuilder();
        NumericUtils.longToPrefixCodedBytes((long)NumericUtils.doubleToSortableLong((double)number), (int)0, (BytesRefBuilder)bytes);
        return new TermQuery(new Term(field, bytes.get()));
    }

    private static class ComboField
    extends Field {
        private ComboField(String name, Object value, FieldType type) {
            super(name, type);
            this.fieldsData = value;
        }

        public Number numericValue() {
            Number number = super.numericValue();
            if (number == null) {
                return null;
            }
            if (this.fieldType().numericType() == FieldType.NumericType.DOUBLE) {
                return Double.doubleToLongBits(number.doubleValue());
            }
            if (this.fieldType().numericType() == FieldType.NumericType.FLOAT) {
                return Float.floatToIntBits(number.floatValue());
            }
            return number.longValue();
        }
    }
}

