/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteAction
extends TransportReplicationAction<DeleteRequest, DeleteRequest, DeleteResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final TransportCreateIndexAction createIndexAction;

    @Inject
    public TransportDeleteAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, TransportCreateIndexAction createIndexAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MappingUpdatedAction mappingUpdatedAction, AutoCreateIndex autoCreateIndex) {
        super(settings, "indices:data/write/delete", transportService, clusterService, indicesService, threadPool, shardStateAction, mappingUpdatedAction, actionFilters, indexNameExpressionResolver, DeleteRequest.class, DeleteRequest.class, "index");
        this.createIndexAction = createIndexAction;
        this.autoCreateIndex = autoCreateIndex;
    }

    @Override
    protected void doExecute(final DeleteRequest request, final ActionListener<DeleteResponse> listener) {
        ClusterState state = this.clusterService.state();
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), state)) {
            this.createIndexAction.execute(new CreateIndexRequest(request).index(request.index()).cause("auto(delete api)").masterNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportDeleteAction.this.innerExecute(request, listener);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException) {
                        TransportDeleteAction.this.innerExecute(request, listener);
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(request, listener);
        }
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportReplicationAction.InternalRequest request, ActionListener<DeleteResponse> listener) {
        MappingMetaData mappingMd;
        ((DeleteRequest)request.request()).routing(state.metaData().resolveIndexRouting(((DeleteRequest)request.request()).routing(), ((DeleteRequest)request.request()).index()));
        if (state.metaData().hasIndex(request.concreteIndex()) && (mappingMd = state.metaData().index(request.concreteIndex()).mappingOrDefault(((DeleteRequest)request.request()).type())) != null && mappingMd.routing().required() && ((DeleteRequest)request.request()).routing() == null) {
            if (((DeleteRequest)request.request()).versionType() != VersionType.INTERNAL) {
                throw new IllegalArgumentException("routing value is required for deleting documents of type [" + ((DeleteRequest)request.request()).type() + "] while using version_type [" + (Object)((Object)((DeleteRequest)request.request()).versionType()) + "]");
            }
            throw new RoutingMissingException(request.concreteIndex(), ((DeleteRequest)request.request()).type(), ((DeleteRequest)request.request()).id());
        }
    }

    private void innerExecute(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        super.doExecute(request, listener);
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected DeleteResponse newResponseInstance() {
        return new DeleteResponse();
    }

    @Override
    protected Tuple<DeleteResponse, DeleteRequest> shardOperationOnPrimary(ClusterState clusterState, TransportReplicationAction.PrimaryOperationRequest shardRequest) {
        DeleteRequest request = (DeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRequest.shardId.getIndex()).shardSafe(shardRequest.shardId.id());
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version(), request.versionType(), Engine.Operation.Origin.PRIMARY);
        indexShard.delete(delete);
        request.versionType(delete.versionType().versionTypeForReplicationAndRecovery());
        request.version(delete.version());
        assert (request.versionType().validateVersionForWrites(request.version()));
        this.processAfter(request, indexShard, delete.getTranslogLocation());
        DeleteResponse response = new DeleteResponse(shardRequest.shardId.getIndex(), request.type(), request.id(), delete.version(), delete.found());
        return new Tuple<DeleteResponse, DeleteRequest>(response, (DeleteRequest)shardRequest.request);
    }

    @Override
    protected void shardOperationOnReplica(ShardId shardId, DeleteRequest request) {
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).shardSafe(shardId.id());
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version(), request.versionType(), Engine.Operation.Origin.REPLICA);
        indexShard.delete(delete);
        this.processAfter(request, indexShard, delete.getTranslogLocation());
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, TransportReplicationAction.InternalRequest request) {
        return this.clusterService.operationRouting().deleteShards(this.clusterService.state(), request.concreteIndex(), ((DeleteRequest)request.request()).type(), ((DeleteRequest)request.request()).id(), ((DeleteRequest)request.request()).routing());
    }

    private void processAfter(DeleteRequest request, IndexShard indexShard, Translog.Location location) {
        if (request.refresh()) {
            try {
                indexShard.refresh("refresh_flag_delete");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (indexShard.getTranslogDurability() == Translog.Durabilty.REQUEST && location != null) {
            indexShard.sync(location);
        }
    }
}

