/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.IfConfig;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public class NetworkService
extends AbstractComponent {
    public static final String DEFAULT_NETWORK_HOST = "_local_";
    private static final String GLOBAL_NETWORK_HOST_SETTING = "network.host";
    private static final String GLOBAL_NETWORK_BINDHOST_SETTING = "network.bind_host";
    private static final String GLOBAL_NETWORK_PUBLISHHOST_SETTING = "network.publish_host";
    private final List<CustomNameResolver> customNameResolvers = new CopyOnWriteArrayList<CustomNameResolver>();

    @Inject
    public NetworkService(Settings settings) {
        super(settings);
        IfConfig.logIfNecessary();
    }

    public void addCustomNameResolver(CustomNameResolver customNameResolver) {
        this.customNameResolvers.add(customNameResolver);
    }

    public InetAddress[] resolveBindHostAddress(String bindHost) throws IOException {
        InetAddress[] addresses;
        if (bindHost == null) {
            bindHost = this.settings.get(GLOBAL_NETWORK_BINDHOST_SETTING, this.settings.get(GLOBAL_NETWORK_HOST_SETTING));
        }
        if (bindHost == null) {
            for (CustomNameResolver customNameResolver : this.customNameResolvers) {
                InetAddress[] addresses2 = customNameResolver.resolveDefault();
                if (addresses2 == null) continue;
                return addresses2;
            }
        }
        if (bindHost == null) {
            bindHost = DEFAULT_NETWORK_HOST;
        }
        if ((addresses = this.resolveInetAddress(bindHost)) != null) {
            for (InetAddress address : addresses) {
                if (!address.isMulticastAddress()) continue;
                throw new IllegalArgumentException("bind address: {" + NetworkAddress.format(address) + "} is invalid: multicast address");
            }
        }
        return addresses;
    }

    public InetAddress resolvePublishHostAddress(String publishHost) throws IOException {
        InetAddress address;
        if (publishHost == null) {
            publishHost = this.settings.get(GLOBAL_NETWORK_PUBLISHHOST_SETTING, this.settings.get(GLOBAL_NETWORK_HOST_SETTING));
        }
        if (publishHost == null) {
            for (CustomNameResolver customNameResolver : this.customNameResolvers) {
                InetAddress[] addresses = customNameResolver.resolveDefault();
                if (addresses == null) continue;
                return addresses[0];
            }
        }
        if (publishHost == null) {
            publishHost = DEFAULT_NETWORK_HOST;
        }
        if ((address = this.resolveInetAddress(publishHost)[0]) != null) {
            if (address.isMulticastAddress()) {
                throw new IllegalArgumentException("publish address: {" + NetworkAddress.format(address) + "} is invalid: multicast address");
            }
            if (address.isAnyLocalAddress()) {
                InetAddress old = address;
                address = NetworkUtils.getFirstNonLoopbackAddresses()[0];
                this.logger.warn("publish address: {{}} is a wildcard address, falling back to first non-loopback: {{}}", NetworkAddress.format(old), NetworkAddress.format(address));
            }
        }
        return address;
    }

    private InetAddress[] resolveInetAddress(String host) throws IOException {
        if (host.startsWith("#") && host.endsWith("#") || host.startsWith("_") && host.endsWith("_")) {
            host = host.substring(1, host.length() - 1);
            for (CustomNameResolver customNameResolver : this.customNameResolvers) {
                InetAddress[] addresses = customNameResolver.resolveIfPossible(host);
                if (addresses == null) continue;
                return addresses;
            }
            switch (host) {
                case "local": {
                    return NetworkUtils.getLoopbackAddresses();
                }
                case "local:ipv4": {
                    return NetworkUtils.filterIPV4(NetworkUtils.getLoopbackAddresses());
                }
                case "local:ipv6": {
                    return NetworkUtils.filterIPV6(NetworkUtils.getLoopbackAddresses());
                }
                case "non_loopback": {
                    return NetworkUtils.getFirstNonLoopbackAddresses();
                }
                case "non_loopback:ipv4": {
                    return NetworkUtils.filterIPV4(NetworkUtils.getFirstNonLoopbackAddresses());
                }
                case "non_loopback:ipv6": {
                    return NetworkUtils.filterIPV6(NetworkUtils.getFirstNonLoopbackAddresses());
                }
            }
            if (host.endsWith(":ipv4")) {
                host = host.substring(0, host.length() - 5);
                return NetworkUtils.filterIPV4(NetworkUtils.getAddressesForInterface(host));
            }
            if (host.endsWith(":ipv6")) {
                host = host.substring(0, host.length() - 5);
                return NetworkUtils.filterIPV6(NetworkUtils.getAddressesForInterface(host));
            }
            return NetworkUtils.getAddressesForInterface(host);
        }
        return NetworkUtils.getAllByName(host);
    }

    public static interface CustomNameResolver {
        public InetAddress[] resolveDefault();

        public InetAddress[] resolveIfPossible(String var1) throws IOException;
    }

    public static final class TcpSettings {
        public static final String TCP_NO_DELAY = "network.tcp.no_delay";
        public static final String TCP_KEEP_ALIVE = "network.tcp.keep_alive";
        public static final String TCP_REUSE_ADDRESS = "network.tcp.reuse_address";
        public static final String TCP_SEND_BUFFER_SIZE = "network.tcp.send_buffer_size";
        public static final String TCP_RECEIVE_BUFFER_SIZE = "network.tcp.receive_buffer_size";
        public static final String TCP_BLOCKING = "network.tcp.blocking";
        public static final String TCP_BLOCKING_SERVER = "network.tcp.blocking_server";
        public static final String TCP_BLOCKING_CLIENT = "network.tcp.blocking_client";
        public static final String TCP_CONNECT_TIMEOUT = "network.tcp.connect_timeout";
        public static final ByteSizeValue TCP_DEFAULT_SEND_BUFFER_SIZE = null;
        public static final ByteSizeValue TCP_DEFAULT_RECEIVE_BUFFER_SIZE = null;
        public static final TimeValue TCP_DEFAULT_CONNECT_TIMEOUT = new TimeValue(30L, TimeUnit.SECONDS);
    }
}

